/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.api.executor.handler.method;

import cn.sliew.carp.module.scheduler.api.executor.JobContext;
import cn.sliew.carp.module.scheduler.api.executor.JobHandler;
import cn.sliew.carp.module.scheduler.api.executor.entity.job.JobExecutionResult;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;

public class MethodJobHandler
implements JobHandler {
    private final Object target;
    private final Method method;
    private Method initMethod;
    private Method destroyMethod;

    public MethodJobHandler(Object target, Method method, Method initMethod, Method destroyMethod) {
        this.target = target;
        this.method = method;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
    }

    @Override
    public JobExecutionResult init(JobContext context) {
        if (Objects.isNull(this.initMethod)) {
            return null;
        }
        try {
            Object result = ReflectionUtils.invokeMethod((Method)this.initMethod, (Object)this.target, (Object[])new Object[]{context});
            if (Objects.nonNull(result) && result instanceof JobExecutionResult) {
                return (JobExecutionResult)result;
            }
        }
        catch (Exception e) {
            return JobExecutionResult.failed("-1", "init method failed", e);
        }
        return null;
    }

    @Override
    public void destroy(JobContext context) {
        if (Objects.isNull(this.destroyMethod)) {
            return;
        }
        try {
            ReflectionUtils.invokeMethod((Method)this.destroyMethod, (Object)this.target, (Object[])new Object[]{context});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JobExecutionResult execute(JobContext context) {
        try {
            Object result = ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])new Object[]{context});
            if (Objects.nonNull(result) && result instanceof JobExecutionResult) {
                return (JobExecutionResult)result;
            }
            return JobExecutionResult.failed("-1", "job method not return JobExecutionResult", null);
        }
        catch (Exception e) {
            return JobExecutionResult.failed("-1", "job method failed", e);
        }
    }
}

