/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.cache.AbstractCacheMap;
import org.redisson.cache.CachedValue;
import org.redisson.misc.WrappedLock;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final AtomicLong index = new AtomicLong();
    private final List<SortedSet<CachedValue<K, V>>> queues = new ArrayList<SortedSet<CachedValue<K, V>>>();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2; ++i) {
            this.queues.add(new SortedSet());
        }
    }

    @Override
    protected void onValueCreate(CachedValue<K, V> value) {
        SortedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        queue.add(value);
    }

    private SortedSet<CachedValue<K, V>> getQueue(CachedValue<K, V> value) {
        return this.queues.get(Math.abs(value.hashCode() % this.queues.size()));
    }

    @Override
    protected void onValueRemove(CachedValue<K, V> value) {
        SortedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        queue.remove(value);
    }

    @Override
    protected void onValueRead(CachedValue<K, V> value) {
        SortedSet<CachedValue<K, CachedValue<K, V>>> queue = this.getQueue(value);
        if (queue.remove(value)) {
            queue.add(value);
        }
    }

    @Override
    protected void onMapFull() {
        int queueIndex;
        SortedSet<CachedValue<K, V>> queue;
        CachedValue<K, V> removedValue;
        int startIndex = -1;
        do {
            if ((queueIndex = (int)Math.abs(this.index.incrementAndGet() % (long)this.queues.size())) == startIndex) {
                return;
            }
            if (startIndex != -1) continue;
            startIndex = queueIndex;
        } while ((removedValue = (queue = this.queues.get(queueIndex)).removeFirst()) == null);
        this.map.remove(removedValue.getKey(), removedValue);
    }

    @Override
    public void clear() {
        for (SortedSet<CachedValue<K, V>> collection : this.queues) {
            collection.clear();
        }
        super.clear();
    }

    static class SortedSet<V> {
        final Set<V> set = new LinkedHashSet<V>();
        final WrappedLock lock = new WrappedLock();

        SortedSet() {
        }

        void add(V element) {
            this.lock.execute(() -> this.set.add(element));
        }

        boolean remove(V element) {
            return this.lock.execute(() -> this.set.remove(element));
        }

        V removeFirst() {
            return (V)this.lock.execute(() -> {
                Iterator<V> iter = this.set.iterator();
                Object removedValue = null;
                if (iter.hasNext()) {
                    removedValue = iter.next();
                    iter.remove();
                }
                return removedValue;
            });
        }

        void clear() {
            this.lock.execute(() -> this.set.clear());
        }
    }
}

