/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.ArrayList;
import org.zalando.logbook.PathFilter;

final class DefaultPathFilter
implements PathFilter {
    private final String[] filter;
    private final String substitute;

    DefaultPathFilter(String replacement, String pathExpression) {
        String[] parts = pathExpression.split("/");
        ArrayList<String> filterImpl = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.startsWith("{") && part.endsWith("}")) {
                if (builder.length() > 0) {
                    filterImpl.add(builder.toString());
                    builder.setLength(0);
                }
                filterImpl.add(null);
            } else {
                builder.append(part);
            }
            if (i + 1 >= parts.length) continue;
            builder.append('/');
        }
        if (builder.length() > 0) {
            filterImpl.add(builder.toString());
        }
        StringBuilder substituteBuilder = new StringBuilder();
        for (String filter : filterImpl) {
            if (filter == null) {
                substituteBuilder.append(replacement);
                continue;
            }
            substituteBuilder.append(filter);
        }
        this.filter = filterImpl.toArray(new String[0]);
        this.substitute = substituteBuilder.toString();
    }

    public String filter(String path) {
        int filterIndex = 0;
        int previousIndex = 0;
        do {
            if (this.filter[filterIndex] != null) {
                if (!path.regionMatches(previousIndex, this.filter[filterIndex], 0, this.filter[filterIndex].length())) {
                    return path;
                }
                previousIndex += this.filter[filterIndex].length();
                ++filterIndex;
                continue;
            }
            ++filterIndex;
            int nextIndex = path.indexOf(47, previousIndex);
            if (nextIndex != -1) {
                previousIndex = nextIndex;
                continue;
            }
            if (filterIndex < this.filter.length) {
                return path;
            }
            previousIndex = path.length();
            break;
        } while (filterIndex < this.filter.length);
        if (previousIndex == path.length()) {
            return this.substitute;
        }
        return this.substitute + path.substring(previousIndex);
    }
}

