/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.AttributeExtractor;

@API(status=API.Status.EXPERIMENTAL)
public final class JwtClaimsExtractor
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtClaimsExtractor.class);
    private static final String BEARER_JWT_PATTERN = "Bearer [a-z0-9-_]+\\.([a-z0-9-_]+)\\.[a-z0-9-_]+";
    private static final Pattern PATTERN = Pattern.compile("Bearer [a-z0-9-_]+\\.([a-z0-9-_]+)\\.[a-z0-9-_]+", 2);
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final List<String> claimNames;

    public Map<String, Object> extractClaims(@Nonnull HttpRequest request) throws JsonProcessingException {
        HttpHeaders headers = request.getHeaders();
        if (this.claimNames.isEmpty() || headers == null) {
            return Collections.emptyMap();
        }
        String authHeader = headers.getFirst("Authorization");
        if (authHeader == null) {
            return Collections.emptyMap();
        }
        Matcher matcher = PATTERN.matcher(authHeader);
        if (!matcher.matches()) {
            return Collections.emptyMap();
        }
        String payload = new String(Base64.getUrlDecoder().decode(matcher.group(1)));
        return (Map)this.objectMapper.readValue(payload, HashMap.class);
    }

    @Nonnull
    public String toStringValue(Object value) {
        try {
            return value instanceof String ? (String)value : this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public JwtClaimsExtractor(@Nonnull ObjectMapper objectMapper, @Nonnull List<String> claimNames) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (claimNames == null) {
            throw new NullPointerException("claimNames is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.claimNames = claimNames;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtClaimsExtractor)) {
            return false;
        }
        JwtClaimsExtractor other = (JwtClaimsExtractor)o;
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        List<String> this$claimNames = this.claimNames;
        List<String> other$claimNames = other.claimNames;
        return !(this$claimNames == null ? other$claimNames != null : !((Object)this$claimNames).equals(other$claimNames));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        List<String> $claimNames = this.claimNames;
        result = result * 59 + ($claimNames == null ? 43 : ((Object)$claimNames).hashCode());
        return result;
    }
}

