/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class JacksonEnumConverter
implements GenericConverter {
    private Set<GenericConverter.ConvertiblePair> set = new HashSet<GenericConverter.ConvertiblePair>();
    private ObjectMapper mapper;

    public JacksonEnumConverter(ObjectMapper mapper) {
        this.set.add(new GenericConverter.ConvertiblePair(String.class, Enum.class));
        this.mapper = mapper;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.set;
    }

    public Object convert(Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (value == null) {
            return null;
        }
        try {
            return this.mapper.readValue("\"" + value + "\"", targetType.getType());
        }
        catch (IOException e) {
            throw new ConversionFailedException(sourceType, targetType, value, (Throwable)e);
        }
    }
}

