/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.core.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.sliew.carp.framework.common.dict.security.SecUserType;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.module.security.core.repository.entity.SecUser;
import cn.sliew.carp.module.security.core.repository.mapper.SecUserMapper;
import cn.sliew.carp.module.security.core.service.SecUserService;
import cn.sliew.carp.module.security.core.service.convert.SecUserConvert;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.SecUserAddParam;
import cn.sliew.carp.module.security.core.service.param.SecUserListParam;
import cn.sliew.carp.module.security.core.service.param.SecUserUpdateParam;
import cn.sliew.carp.module.security.core.util.PasswordUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SecUserServiceImpl
extends ServiceImpl<SecUserMapper, SecUser>
implements SecUserService {
    @Override
    public PageResult<SecUserDTO> list(SecUserListParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUser.class).like(StringUtils.hasText((String)param.getUserName()), SecUser::getUserName, (Object)param.getUserName())).like(StringUtils.hasText((String)param.getNickName()), SecUser::getNickName, (Object)param.getNickName())).eq(StringUtils.hasText((String)param.getEmail()), SecUser::getEmail, (Object)param.getEmail())).eq(StringUtils.hasText((String)param.getPhone()), SecUser::getPhone, (Object)param.getPhone())).eq(param.getType() != null, SecUser::getType, (Object)param.getType())).eq(param.getStatus() != null, SecUser::getStatus, (Object)param.getStatus())).orderByAsc(SecUser::getOrder, new SFunction[]{BaseDO::getId});
        Page secUserPage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(secUserPage.getCurrent()), Long.valueOf(secUserPage.getSize()), Long.valueOf(secUserPage.getTotal()));
        pageResult.setRecords(SecUserConvert.INSTANCE.toDto(secUserPage.getRecords()));
        return pageResult;
    }

    @Override
    public List<SecUserDTO> listAll(SecUserListParam param) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SecUser.class).like(StringUtils.hasText((String)param.getUserName()), SecUser::getUserName, (Object)param.getUserName())).like(StringUtils.hasText((String)param.getNickName()), SecUser::getNickName, (Object)param.getNickName())).eq(StringUtils.hasText((String)param.getEmail()), SecUser::getEmail, (Object)param.getEmail())).eq(StringUtils.hasText((String)param.getPhone()), SecUser::getPhone, (Object)param.getPhone())).eq(param.getType() != null, SecUser::getType, (Object)param.getType())).eq(param.getStatus() != null, SecUser::getStatus, (Object)param.getStatus())).orderByAsc(SecUser::getOrder, new SFunction[]{BaseDO::getId});
        List entities = this.list((Wrapper)queryChainWrapper);
        return SecUserConvert.INSTANCE.toDto(entities);
    }

    @Override
    public SecUserDTO get(Long id) {
        SecUser entity = (SecUser)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("user not exists for id: " + id)));
        return (SecUserDTO)((Object)SecUserConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public Optional<SecUserDTO> getByUserName(String userName) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(SecUser.class).eq(SecUser::getUserName, (Object)userName);
        Optional optional = this.getOneOpt((Wrapper)queryChainWrapper);
        return optional.map(user -> (SecUserDTO)((Object)((Object)SecUserConvert.INSTANCE.toDto(user))));
    }

    @Override
    public boolean add(SecUserAddParam param) {
        SecUser entity = (SecUser)((Object)BeanUtil.copyProperties((Object)param, SecUser.class, (String[])new String[0]));
        entity.setType(SecUserType.CUSTOM);
        entity.setSalt(RandomStringUtils.randomAlphanumeric((int)32));
        entity.setPassword(PasswordUtil.digestPassword(param.getPassword(), entity.getSalt()));
        return this.save((Object)entity);
    }

    @Override
    public boolean update(SecUserUpdateParam param) {
        SecUser entity = (SecUser)((Object)BeanUtil.copyProperties((Object)param, SecUser.class, (String[])new String[0]));
        return this.saveOrUpdate((Object)entity);
    }

    @Override
    public boolean delete(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        return this.removeByIds(ids);
    }
}

