/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.builder;

import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.Condition;
import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.builder.ExternalTransitionsBuilder;
import com.alibaba.cola.statemachine.builder.From;
import com.alibaba.cola.statemachine.builder.On;
import com.alibaba.cola.statemachine.builder.TransitionBuilderImpl;
import com.alibaba.cola.statemachine.builder.When;
import com.alibaba.cola.statemachine.impl.StateHelper;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransitionsBuilderImpl<S, E, C>
extends TransitionBuilderImpl<S, E, C>
implements ExternalTransitionsBuilder<S, E, C> {
    private List<State<S, E, C>> sources = new ArrayList<State<S, E, C>>();
    private List<Transition<S, E, C>> transitions = new ArrayList<Transition<S, E, C>>();

    public TransitionsBuilderImpl(Map<S, State<S, E, C>> stateMap, TransitionType transitionType) {
        super(stateMap, transitionType);
    }

    @Override
    public From<S, E, C> fromAmong(S ... stateIds) {
        for (S stateId : stateIds) {
            this.sources.add(StateHelper.getState(this.stateMap, stateId));
        }
        return this;
    }

    @Override
    public On<S, E, C> on(E event) {
        for (State source : this.sources) {
            Transition<S, E, C> transition = source.addTransition(event, this.target, this.transitionType);
            this.transitions.add(transition);
        }
        return this;
    }

    @Override
    public When<S, E, C> when(Condition<C> condition) {
        for (Transition<S, E, C> transition : this.transitions) {
            transition.setCondition(condition);
        }
        return this;
    }

    @Override
    public void perform(Action<S, E, C> action) {
        for (Transition<S, E, C> transition : this.transitions) {
            transition.setAction(action);
        }
    }
}

