/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.util;

import cn.sliew.carp.module.security.spring.constant.SecurityConstants;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CookieUtil
extends Enum<CookieUtil> {
    @Generated
    private static final Logger log;
    private static final /* synthetic */ CookieUtil[] $VALUES;

    public static CookieUtil[] values() {
        return (CookieUtil[])$VALUES.clone();
    }

    public static CookieUtil valueOf(String name) {
        return Enum.valueOf(CookieUtil.class, name);
    }

    public static Cookie findCookieByName(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(cookieName) || !StringUtils.isNotBlank((CharSequence)cookie.getValue())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, String token) {
        CookieUtil.addCookie(response, "/", "u_token", token, SecurityConstants.COOKIE_MAX_AGE, true, true);
    }

    public static void refreshCookieMaxAge(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.refreshCookieMaxAge(request, response, "u_token", SecurityConstants.COOKIE_MAX_AGE, "/");
    }

    public static void clearCookieByName(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.clearCookieByName(request, response, "u_token");
    }

    private static void refreshCookieMaxAge(HttpServletRequest request, HttpServletResponse response, String cookieName, int expireTime, String path) {
        Cookie cookie = CookieUtil.findCookieByName(request, cookieName);
        if (cookie != null) {
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                cookie.setPath(path);
            }
            cookie.setMaxAge(expireTime);
            cookie.setSecure(true);
            CookieUtil.addHttpOnlyCookie(response, cookie);
        }
    }

    private static boolean clearCookieByName(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = CookieUtil.findCookieByName(request, cookieName);
        if (cookie != null) {
            cookie.setValue("");
            cookie.setMaxAge(SecurityConstants.COOKIE_MAX_AGE_CLEAR_IMMEDIATELY_REMOVE.intValue());
            response.addCookie(cookie);
            return true;
        }
        return false;
    }

    private static void addCookie(HttpServletResponse response, String path, String name, String value, int maxAge, boolean httpOnly, boolean secured) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        if (secured) {
            cookie.setSecure(secured);
        }
        if (httpOnly) {
            CookieUtil.addHttpOnlyCookie(response, cookie);
        } else {
            response.addCookie(cookie);
        }
    }

    private static void addHttpOnlyCookie(HttpServletResponse response, Cookie cookie) {
        if (cookie == null) {
            return;
        }
        String cookieName = cookie.getName();
        String cookieValue = cookie.getValue();
        int maxAge = cookie.getMaxAge();
        String path = cookie.getPath();
        String domain = cookie.getDomain();
        boolean isSecure = cookie.getSecure();
        StringBuffer sf = new StringBuffer();
        sf.append(cookieName + "=" + cookieValue + ";");
        if (maxAge >= 0) {
            sf.append("Max-Age=" + cookie.getMaxAge() + ";");
        }
        if (domain != null) {
            sf.append("domain=" + domain + ";");
        }
        if (path != null) {
            sf.append("path=" + path + ";");
        }
        if (isSecure) {
            sf.append("secure;HTTPOnly;");
        } else {
            sf.append("HTTPOnly;");
        }
        sf.append("SameSite=None");
        response.addHeader("Set-Cookie", sf.toString());
    }

    private static /* synthetic */ CookieUtil[] $values() {
        return new CookieUtil[0];
    }

    static {
        $VALUES = CookieUtil.$values();
        log = LoggerFactory.getLogger(CookieUtil.class);
    }
}

