/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.controller;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.common.security.annotations.AnonymousAccess;
import cn.sliew.carp.module.plugin.service.PluginService;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginDTO;
import cn.sliew.carp.module.plugin.service.param.CarpPluginAddParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginListParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginPageParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginUpdateParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@AnonymousAccess
@RestController
@RequestMapping(value={"/api/carp/plugin"})
@Tag(name="\u63d2\u4ef6\u6a21\u5757-\u63d2\u4ef6\u7ba1\u7406")
public class PluginController {
    @Autowired
    private PluginService pluginService;

    @GetMapping(value={"page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public PageResult<CarpPluginDTO> list(@Valid CarpPluginPageParam param) {
        return this.pluginService.list(param);
    }

    @GetMapping
    @Operation(summary="\u67e5\u8be2\u6240\u6709", description="\u67e5\u8be2\u6240\u6709")
    public List<CarpPluginDTO> listAll(@Valid CarpPluginListParam param) {
        return this.pluginService.listAll(param);
    }

    @GetMapping(value={"{id}"})
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    public CarpPluginDTO get(@PathVariable(value="id") Long id) {
        return this.pluginService.get(id);
    }

    @PutMapping
    @Operation(summary="\u65b0\u589e", description="\u65b0\u589e")
    public Boolean add(@Valid @RequestBody CarpPluginAddParam param) {
        return this.pluginService.add(param);
    }

    @PostMapping
    @Operation(summary="\u66f4\u65b0", description="\u66f4\u65b0")
    public Boolean update(@Valid @RequestBody CarpPluginUpdateParam param) {
        return this.pluginService.update(param);
    }

    @DeleteMapping(value={"{id}"})
    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    public Boolean delete(@PathVariable(value="id") Long id) {
        return this.pluginService.delete(id);
    }

    @DeleteMapping(value={"batch"})
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    public Boolean deleteBatch(@RequestBody List<Long> ids) {
        return this.pluginService.deleteBatch(ids);
    }

    @PostMapping(value={"{id}/enable"})
    @Operation(summary="\u542f\u7528", description="\u542f\u7528")
    public Boolean enable(@PathVariable(value="id") Long id) {
        return this.pluginService.enable(id);
    }

    @PostMapping(value={"{id}/disable"})
    @Operation(summary="\u7981\u7528", description="\u7981\u7528")
    public Boolean disable(@PathVariable(value="id") Long id) {
        return this.pluginService.disable(id);
    }
}

