/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.scheduler.controller;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.web.response.ApiResponseWrapper;
import cn.sliew.carp.module.scheduler.api.scheduler.JobScheduler;
import cn.sliew.carp.module.scheduler.service.ScheduleJobInstanceService;
import cn.sliew.carp.module.scheduler.service.dto.ScheduleJobInstanceDTO;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceAddParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceListParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstancePageParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobInstanceUpdateParam;
import cn.sliew.carp.module.scheduler.service.param.ScheduleJobManageParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResponseWrapper
@RequestMapping(value={"/api/carp/schedule/instance"})
@Tag(name="\u8c03\u5ea6\u7ba1\u7406-\u5b9e\u4f8b\u7ba1\u7406")
public class CarpJobInstanceController {
    @Autowired
    private ScheduleJobInstanceService scheduleJobInstanceService;
    @Autowired(required=false)
    private JobScheduler jobScheduler;

    @GetMapping(value={"page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public PageResult<ScheduleJobInstanceDTO> list(@Valid ScheduleJobInstancePageParam param) {
        return this.scheduleJobInstanceService.list(param);
    }

    @GetMapping
    @Operation(summary="\u67e5\u8be2\u6240\u6709", description="\u67e5\u8be2\u6240\u6709")
    public List<ScheduleJobInstanceDTO> listAll(@Valid ScheduleJobInstanceListParam param) {
        return this.scheduleJobInstanceService.listAll(param);
    }

    @GetMapping(value={"{id}"})
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    public ScheduleJobInstanceDTO get(@PathVariable(value="id") Long id) {
        return this.scheduleJobInstanceService.get(id);
    }

    @PutMapping
    @Operation(summary="\u65b0\u589e", description="\u65b0\u589e")
    public Boolean add(@Valid @RequestBody ScheduleJobInstanceAddParam param) {
        return this.scheduleJobInstanceService.add(param);
    }

    @PostMapping
    @Operation(summary="\u66f4\u65b0", description="\u66f4\u65b0")
    public Boolean update(@Valid @RequestBody ScheduleJobInstanceUpdateParam param) {
        return this.scheduleJobInstanceService.update(param);
    }

    @DeleteMapping(value={"{id}"})
    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    public Boolean delete(@PathVariable(value="id") Long id) {
        return this.scheduleJobInstanceService.delete(id);
    }

    @DeleteMapping(value={"batch"})
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    public Boolean deleteBatch(@RequestBody List<Long> ids) {
        return this.scheduleJobInstanceService.deleteBatch(ids);
    }

    @PostMapping(value={"manage/execute"})
    @Operation(summary="\u6267\u884c\u4e00\u6b21", description="\u6267\u884c\u4e00\u6b21")
    public void execute(@Valid @RequestBody ScheduleJobManageParam param) {
        this.jobScheduler.execute(param.getJobInstanceId());
    }

    @PostMapping(value={"manage/schedule"})
    @Operation(summary="\u542f\u52a8\u8c03\u5ea6", description="\u542f\u52a8\u8c03\u5ea6")
    public void schedule(@Valid @RequestBody ScheduleJobManageParam param) {
        this.jobScheduler.schedule(param.getJobInstanceId());
    }

    @PostMapping(value={"manage/unschedule"})
    @Operation(summary="\u53d6\u6d88\u8c03\u5ea6", description="\u53d6\u6d88\u8c03\u5ea6")
    public void unschedule(@Valid @RequestBody ScheduleJobManageParam param) {
        this.jobScheduler.unschedule(param.getJobInstanceId());
    }

    @PostMapping(value={"manage/suspend"})
    @Operation(summary="\u6682\u505c", description="\u6682\u505c")
    public void suspend(@Valid @RequestBody ScheduleJobManageParam param) {
        this.jobScheduler.suspend(param.getJobInstanceId());
    }

    @PostMapping(value={"manage/resume"})
    @Operation(summary="\u6062\u590d", description="\u6062\u590d")
    public void resume(@Valid @RequestBody ScheduleJobManageParam param) {
        this.jobScheduler.resume(param.getJobInstanceId());
    }
}

