create database if not exists data_service default character set utf8mb4 collate utf8mb4_unicode_ci;
use data_service;

DROP TABLE IF EXISTS `sample_data_e_commerce_duplicate`;
CREATE TABLE `sample_data_e_commerce_duplicate`
(
    `id`           bigint         NOT NULL AUTO_INCREMENT COMMENT '自增主键',
    `invoice_no`   varchar(32)    NOT NULL COMMENT '发票号码，每笔交易分配唯一的6位整数，而退货订单的代码以字母''c''开头',
    `stock_code`   varchar(32)    NOT NULL COMMENT '产品代码，每个不同的产品分配唯一的5位整数',
    `description`  varchar(255) COMMENT '产品描述，对每件产品的简略描述',
    `quantity`     int            NOT NULL COMMENT '产品数量，每笔交易的每件产品的数量',
    `invoice_date` varchar(32) COMMENT '发票日期和时间，每笔交易发生的日期和时间',
    `unit_price`   decimal(20, 2) NOT NULL COMMENT '单价（英镑），单位产品价格',
    `customer_id`  varchar(32)    NOT NULL COMMENT '顾客号码，每个客户分配唯一的5位整数',
    `country`      varchar(32)    NOT NULL COMMENT '国家的名字，每个客户所在国家/地区的名称',
    PRIMARY KEY (`id`),
    KEY `uniq_invoiceNo` (`invoice_no`)
) ENGINE = InnoDB COMMENT ='E-Commerce 数据集';

DROP TABLE IF EXISTS `sample_data_e_commerce`;
CREATE TABLE `sample_data_e_commerce`
(
    `id`           bigint         NOT NULL AUTO_INCREMENT COMMENT '自增主键',
    `invoice_no`   varchar(32)    NOT NULL COMMENT '发票号码，每笔交易分配唯一的6位整数，而退货订单的代码以字母''c''开头',
    `stock_code`   varchar(32)    NOT NULL COMMENT '产品代码，每个不同的产品分配唯一的5位整数',
    `description`  varchar(255) COMMENT '产品描述，对每件产品的简略描述',
    `quantity`     int            NOT NULL COMMENT '产品数量，每笔交易的每件产品的数量',
    `invoice_date` varchar(32) COMMENT '发票日期和时间，每笔交易发生的日期和时间',
    `unit_price`   decimal(20, 2) NOT NULL COMMENT '单价（英镑），单位产品价格',
    `customer_id`  varchar(32)    NOT NULL COMMENT '顾客号码，每个客户分配唯一的5位整数',
    `country`      varchar(32)    NOT NULL COMMENT '国家的名字，每个客户所在国家/地区的名称',
    PRIMARY KEY (`id`),
    KEY `uniq_invoiceNo` (`invoice_no`)
) ENGINE = InnoDB COMMENT ='E-Commerce 数据集';

INSERT INTO `sample_data_e_commerce` VALUES (1, '536365', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 8:26', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (2, '536365', '71053', 'WHITE METAL LANTERN', 6, '12/1/2010 8:26', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (3, '536365', '84406B', 'CREAM CUPID HEARTS COAT HANGER', 8, '12/1/2010 8:26', 2.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (4, '536365', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 6, '12/1/2010 8:26', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (5, '536365', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 6, '12/1/2010 8:26', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (6, '536365', '22752', 'SET 7 BABUSHKA NESTING BOXES', 2, '12/1/2010 8:26', 7.65, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (7, '536365', '21730', 'GLASS STAR FROSTED T-LIGHT HOLDER', 6, '12/1/2010 8:26', 4.25, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (8, '536366', '22633', 'HAND WARMER UNION JACK', 6, '12/1/2010 8:28', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (9, '536366', '22632', 'HAND WARMER RED POLKA DOT', 6, '12/1/2010 8:28', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (10, '536367', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 32, '12/1/2010 8:34', 1.69, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (11, '536367', '22745', 'POPPY\'S PLAYHOUSE BEDROOM ', 6, '12/1/2010 8:34', 2.10, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (12, '536367', '22748', 'POPPY\'S PLAYHOUSE KITCHEN', 6, '12/1/2010 8:34', 2.10, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (13, '536367', '22749', 'FELTCRAFT PRINCESS CHARLOTTE DOLL', 8, '12/1/2010 8:34', 3.75, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (14, '536367', '22310', 'IVORY KNITTED MUG COSY ', 6, '12/1/2010 8:34', 1.65, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (15, '536367', '84969', 'BOX OF 6 ASSORTED COLOUR TEASPOONS', 6, '12/1/2010 8:34', 4.25, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (16, '536367', '22623', 'BOX OF VINTAGE JIGSAW BLOCKS ', 3, '12/1/2010 8:34', 4.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (17, '536367', '22622', 'BOX OF VINTAGE ALPHABET BLOCKS', 2, '12/1/2010 8:34', 9.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (18, '536367', '21754', 'HOME BUILDING BLOCK WORD', 3, '12/1/2010 8:34', 5.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (19, '536367', '21755', 'LOVE BUILDING BLOCK WORD', 3, '12/1/2010 8:34', 5.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (20, '536367', '21777', 'RECIPE BOX WITH METAL HEART', 4, '12/1/2010 8:34', 7.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (21, '536367', '48187', 'DOORMAT NEW ENGLAND', 4, '12/1/2010 8:34', 7.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (22, '536368', '22960', 'JAM MAKING SET WITH JARS', 6, '12/1/2010 8:34', 4.25, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (23, '536368', '22913', 'RED COAT RACK PARIS FASHION', 3, '12/1/2010 8:34', 4.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (24, '536368', '22912', 'YELLOW COAT RACK PARIS FASHION', 3, '12/1/2010 8:34', 4.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (25, '536368', '22914', 'BLUE COAT RACK PARIS FASHION', 3, '12/1/2010 8:34', 4.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (26, '536369', '21756', 'BATH BUILDING BLOCK WORD', 3, '12/1/2010 8:35', 5.95, '13047', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (27, '536370', '22728', 'ALARM CLOCK BAKELIKE PINK', 24, '12/1/2010 8:45', 3.75, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (28, '536370', '22727', 'ALARM CLOCK BAKELIKE RED ', 24, '12/1/2010 8:45', 3.75, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (29, '536370', '22726', 'ALARM CLOCK BAKELIKE GREEN', 12, '12/1/2010 8:45', 3.75, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (30, '536370', '21724', 'PANDA AND BUNNIES STICKER SHEET', 12, '12/1/2010 8:45', 0.85, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (31, '536370', '21883', 'STARS GIFT TAPE ', 24, '12/1/2010 8:45', 0.65, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (32, '536370', '10002', 'INFLATABLE POLITICAL GLOBE ', 48, '12/1/2010 8:45', 0.85, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (33, '536370', '21791', 'VINTAGE HEADS AND TAILS CARD GAME ', 24, '12/1/2010 8:45', 1.25, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (34, '536370', '21035', 'SET/2 RED RETROSPOT TEA TOWELS ', 18, '12/1/2010 8:45', 2.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (35, '536370', '22326', 'ROUND SNACK BOXES SET OF4 WOODLAND ', 24, '12/1/2010 8:45', 2.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (36, '536370', '22629', 'SPACEBOY LUNCH BOX ', 24, '12/1/2010 8:45', 1.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (37, '536370', '22659', 'LUNCH BOX I LOVE LONDON', 24, '12/1/2010 8:45', 1.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (38, '536370', '22631', 'CIRCUS PARADE LUNCH BOX ', 24, '12/1/2010 8:45', 1.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (39, '536370', '22661', 'CHARLOTTE BAG DOLLY GIRL DESIGN', 20, '12/1/2010 8:45', 0.85, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (40, '536370', '21731', 'RED TOADSTOOL LED NIGHT LIGHT', 24, '12/1/2010 8:45', 1.65, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (41, '536370', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 24, '12/1/2010 8:45', 2.95, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (42, '536370', '21913', 'VINTAGE SEASIDE JIGSAW PUZZLES', 12, '12/1/2010 8:45', 3.75, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (43, '536370', '22540', 'MINI JIGSAW CIRCUS PARADE ', 24, '12/1/2010 8:45', 0.42, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (44, '536370', '22544', 'MINI JIGSAW SPACEBOY', 24, '12/1/2010 8:45', 0.42, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (45, '536370', '22492', 'MINI PAINT SET VINTAGE ', 36, '12/1/2010 8:45', 0.65, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (46, '536370', 'POST', 'POSTAGE', 3, '12/1/2010 8:45', 18.00, '12583', 'France');
INSERT INTO `sample_data_e_commerce` VALUES (47, '536371', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 80, '12/1/2010 9:00', 2.55, '13748', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (48, '536372', '22632', 'HAND WARMER RED POLKA DOT', 6, '12/1/2010 9:01', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (49, '536372', '22633', 'HAND WARMER UNION JACK', 6, '12/1/2010 9:01', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (50, '536373', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 9:02', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (51, '536373', '71053', 'WHITE METAL LANTERN', 6, '12/1/2010 9:02', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (52, '536373', '84406B', 'CREAM CUPID HEARTS COAT HANGER', 8, '12/1/2010 9:02', 2.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (53, '536373', '20679', 'EDWARDIAN PARASOL RED', 6, '12/1/2010 9:02', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (54, '536373', '37370', 'RETRO COFFEE MUGS ASSORTED', 6, '12/1/2010 9:02', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (55, '536373', '21871', 'SAVE THE PLANET MUG', 6, '12/1/2010 9:02', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (56, '536373', '21071', 'VINTAGE BILLBOARD DRINK ME MUG', 6, '12/1/2010 9:02', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (57, '536373', '21068', 'VINTAGE BILLBOARD LOVE/HATE MUG', 6, '12/1/2010 9:02', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (58, '536373', '82483', 'WOOD 2 DRAWER CABINET WHITE FINISH', 2, '12/1/2010 9:02', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (59, '536373', '82486', 'WOOD S/3 CABINET ANT WHITE FINISH', 4, '12/1/2010 9:02', 6.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (60, '536373', '82482', 'WOODEN PICTURE FRAME WHITE FINISH', 6, '12/1/2010 9:02', 2.10, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (61, '536373', '82494L', 'WOODEN FRAME ANTIQUE WHITE ', 6, '12/1/2010 9:02', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (62, '536373', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 6, '12/1/2010 9:02', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (63, '536373', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 6, '12/1/2010 9:02', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (64, '536373', '22752', 'SET 7 BABUSHKA NESTING BOXES', 2, '12/1/2010 9:02', 7.65, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (65, '536373', '21730', 'GLASS STAR FROSTED T-LIGHT HOLDER', 6, '12/1/2010 9:02', 4.25, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (66, '536374', '21258', 'VICTORIAN SEWING BOX LARGE', 32, '12/1/2010 9:09', 10.95, '15100', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (67, '536375', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 9:32', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (68, '536375', '71053', 'WHITE METAL LANTERN', 6, '12/1/2010 9:32', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (69, '536375', '84406B', 'CREAM CUPID HEARTS COAT HANGER', 8, '12/1/2010 9:32', 2.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (70, '536375', '20679', 'EDWARDIAN PARASOL RED', 6, '12/1/2010 9:32', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (71, '536375', '37370', 'RETRO COFFEE MUGS ASSORTED', 6, '12/1/2010 9:32', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (72, '536375', '21871', 'SAVE THE PLANET MUG', 6, '12/1/2010 9:32', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (73, '536375', '21071', 'VINTAGE BILLBOARD DRINK ME MUG', 6, '12/1/2010 9:32', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (74, '536375', '21068', 'VINTAGE BILLBOARD LOVE/HATE MUG', 6, '12/1/2010 9:32', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (75, '536375', '82483', 'WOOD 2 DRAWER CABINET WHITE FINISH', 2, '12/1/2010 9:32', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (76, '536375', '82486', 'WOOD S/3 CABINET ANT WHITE FINISH', 4, '12/1/2010 9:32', 6.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (77, '536375', '82482', 'WOODEN PICTURE FRAME WHITE FINISH', 6, '12/1/2010 9:32', 2.10, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (78, '536375', '82494L', 'WOODEN FRAME ANTIQUE WHITE ', 6, '12/1/2010 9:32', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (79, '536375', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 6, '12/1/2010 9:32', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (80, '536375', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 6, '12/1/2010 9:32', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (81, '536375', '22752', 'SET 7 BABUSHKA NESTING BOXES', 2, '12/1/2010 9:32', 7.65, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (82, '536375', '21730', 'GLASS STAR FROSTED T-LIGHT HOLDER', 6, '12/1/2010 9:32', 4.25, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (83, '536376', '22114', 'HOT WATER BOTTLE TEA AND SYMPATHY', 48, '12/1/2010 9:32', 3.45, '15291', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (84, '536376', '21733', 'RED HANGING HEART T-LIGHT HOLDER', 64, '12/1/2010 9:32', 2.55, '15291', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (85, '536377', '22632', 'HAND WARMER RED POLKA DOT', 6, '12/1/2010 9:34', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (86, '536377', '22633', 'HAND WARMER UNION JACK', 6, '12/1/2010 9:34', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (87, '536378', '22386', 'JUMBO BAG PINK POLKADOT', 10, '12/1/2010 9:37', 1.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (88, '536378', '85099C', 'JUMBO  BAG BAROQUE BLACK WHITE', 10, '12/1/2010 9:37', 1.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (89, '536378', '21033', 'JUMBO BAG CHARLIE AND LOLA TOYS', 10, '12/1/2010 9:37', 2.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (90, '536378', '20723', 'STRAWBERRY CHARLOTTE BAG', 10, '12/1/2010 9:37', 0.85, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (91, '536378', '84997B', 'RED 3 PIECE RETROSPOT CUTLERY SET', 12, '12/1/2010 9:37', 3.75, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (92, '536378', '84997C', 'BLUE 3 PIECE POLKADOT CUTLERY SET', 6, '12/1/2010 9:37', 3.75, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (93, '536378', '21094', 'SET/6 RED SPOTTY PAPER PLATES', 12, '12/1/2010 9:37', 0.85, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (94, '536378', '20725', 'LUNCH BAG RED RETROSPOT', 10, '12/1/2010 9:37', 1.65, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (95, '536378', '21559', 'STRAWBERRY LUNCH BOX WITH CUTLERY', 6, '12/1/2010 9:37', 2.55, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (96, '536378', '22352', 'LUNCH BOX WITH CUTLERY RETROSPOT ', 6, '12/1/2010 9:37', 2.55, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (97, '536378', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 120, '12/1/2010 9:37', 0.42, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (98, '536378', '21975', 'PACK OF 60 DINOSAUR CAKE CASES', 24, '12/1/2010 9:37', 0.55, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (99, '536378', '21977', 'PACK OF 60 PINK PAISLEY CAKE CASES', 24, '12/1/2010 9:37', 0.55, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (100, '536378', '84991', '60 TEATIME FAIRY CAKE CASES', 24, '12/1/2010 9:37', 0.55, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (101, '536378', '84519A', 'TOMATO CHARLIE+LOLA COASTER SET', 6, '12/1/2010 9:37', 2.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (102, '536378', '85183B', 'CHARLIE & LOLA WASTEPAPER BIN FLORA', 48, '12/1/2010 9:37', 1.25, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (103, '536378', '85071B', 'RED CHARLIE+LOLA PERSONAL DOORSIGN', 96, '12/1/2010 9:37', 0.38, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (104, '536378', '21931', 'JUMBO STORAGE BAG SUKI', 10, '12/1/2010 9:37', 1.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (105, '536378', '21929', 'JUMBO BAG PINK VINTAGE PAISLEY', 10, '12/1/2010 9:37', 1.95, '14688', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (106, '536380', '22961', 'JAM MAKING SET PRINTED', 24, '12/1/2010 9:41', 1.45, '17809', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (107, '536381', '22139', 'RETROSPOT TEA SET CERAMIC 11 PC ', 23, '12/1/2010 9:41', 4.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (108, '536381', '84854', 'GIRLY PINK TOOL SET', 5, '12/1/2010 9:41', 4.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (109, '536381', '22411', 'JUMBO SHOPPER VINTAGE RED PAISLEY', 10, '12/1/2010 9:41', 1.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (110, '536381', '82567', 'AIRLINE LOUNGE,METAL SIGN', 2, '12/1/2010 9:41', 2.10, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (111, '536381', '21672', 'WHITE SPOT RED CERAMIC DRAWER KNOB', 6, '12/1/2010 9:41', 1.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (112, '536381', '22774', 'RED DRAWER KNOB ACRYLIC EDWARDIAN', 24, '12/1/2010 9:41', 1.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (113, '536381', '22771', 'CLEAR DRAWER KNOB ACRYLIC EDWARDIAN', 24, '12/1/2010 9:41', 1.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (114, '536381', '71270', 'PHOTO CLIP LINE', 1, '12/1/2010 9:41', 1.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (115, '536381', '22262', 'FELT EGG COSY CHICKEN', 1, '12/1/2010 9:41', 0.85, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (116, '536381', '22637', 'PIGGY BANK RETROSPOT ', 1, '12/1/2010 9:41', 2.55, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (117, '536381', '21934', 'SKULL SHOULDER BAG', 10, '12/1/2010 9:41', 1.65, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (118, '536381', '21169', 'YOU\'RE CONFUSING ME METAL SIGN ', 3, '12/1/2010 9:41', 1.69, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (119, '536381', '21166', 'COOK WITH WINE METAL SIGN ', 1, '12/1/2010 9:41', 1.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (120, '536381', '21175', 'GIN + TONIC DIET METAL SIGN', 2, '12/1/2010 9:41', 2.10, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (121, '536381', '37444A', 'YELLOW BREAKFAST CUP AND SAUCER', 1, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (122, '536381', '37444C', 'PINK BREAKFAST CUP AND SAUCER ', 1, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (123, '536381', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 4, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (124, '536381', '22083', 'PAPER CHAIN KIT RETROSPOT', 1, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (125, '536381', '84971S', 'SMALL HEART FLOWERS HOOK ', 6, '12/1/2010 9:41', 0.85, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (126, '536381', '71270', 'PHOTO CLIP LINE', 3, '12/1/2010 9:41', 1.25, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (127, '536381', '47580', 'TEA TIME DES TEA COSY', 2, '12/1/2010 9:41', 2.55, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (128, '536381', '22261', 'FELT EGG COSY WHITE RABBIT ', 1, '12/1/2010 9:41', 0.85, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (129, '536381', '84832', 'ZINC WILLIE WINKIE  CANDLE STICK', 1, '12/1/2010 9:41', 0.85, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (130, '536381', '22644', 'CERAMIC CHERRY CAKE MONEY BANK', 1, '12/1/2010 9:41', 1.45, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (131, '536381', '21533', 'RETROSPOT LARGE MILK JUG', 1, '12/1/2010 9:41', 4.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (132, '536381', '21557', 'SET OF 6 FUNKY BEAKERS', 2, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (133, '536381', '15056BL', 'EDWARDIAN PARASOL BLACK', 2, '12/1/2010 9:41', 5.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (134, '536381', '15056N', 'EDWARDIAN PARASOL NATURAL', 2, '12/1/2010 9:41', 5.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (135, '536381', '22646', 'CERAMIC STRAWBERRY CAKE MONEY BANK', 4, '12/1/2010 9:41', 1.45, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (136, '536381', '22176', 'BLUE OWL SOFT TOY', 1, '12/1/2010 9:41', 2.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (137, '536381', '22438', 'BALLOON ART MAKE YOUR OWN FLOWERS', 1, '12/1/2010 9:41', 1.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (138, '536381', '21731', 'RED TOADSTOOL LED NIGHT LIGHT', 2, '12/1/2010 9:41', 1.65, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (139, '536381', '22778', 'GLASS CLOCHE SMALL', 3, '12/1/2010 9:41', 3.95, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (140, '536381', '22719', 'GUMBALL MONOCHROME COAT RACK', 36, '12/1/2010 9:41', 1.06, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (141, '536381', '21523', 'DOORMAT FANCY FONT HOME SWEET HOME', 10, '12/1/2010 9:41', 6.75, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (142, 'C536379', 'D', 'Discount', -1, '12/1/2010 9:41', 27.50, '14527', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (143, '536382', '10002', 'INFLATABLE POLITICAL GLOBE ', 12, '12/1/2010 9:45', 0.85, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (144, '536382', '21912', 'VINTAGE SNAKES & LADDERS', 8, '12/1/2010 9:45', 3.75, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (145, '536382', '21832', 'CHOCOLATE CALCULATOR', 12, '12/1/2010 9:45', 1.65, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (146, '536382', '22411', 'JUMBO SHOPPER VINTAGE RED PAISLEY', 10, '12/1/2010 9:45', 1.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (147, '536382', '22379', 'RECYCLING BAG RETROSPOT ', 10, '12/1/2010 9:45', 2.10, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (148, '536382', '22381', 'TOY TIDY PINK POLKADOT', 50, '12/1/2010 9:45', 1.85, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (149, '536382', '22798', 'ANTIQUE GLASS DRESSING TABLE POT', 8, '12/1/2010 9:45', 2.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (150, '536382', '22726', 'ALARM CLOCK BAKELIKE GREEN', 4, '12/1/2010 9:45', 3.75, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (151, '536382', '22926', 'IVORY GIANT GARDEN THERMOMETER', 12, '12/1/2010 9:45', 5.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (152, '536382', '22839', '3 TIER CAKE TIN GREEN AND CREAM', 2, '12/1/2010 9:45', 14.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (153, '536382', '22838', '3 TIER CAKE TIN RED AND CREAM', 2, '12/1/2010 9:45', 14.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (154, '536382', '22783', 'SET 3 WICKER OVAL BASKETS W LIDS', 4, '12/1/2010 9:45', 16.95, '16098', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (155, 'C536383', '35004C', 'SET OF 3 COLOURED  FLYING DUCKS', -1, '12/1/2010 9:49', 4.65, '15311', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (156, '536384', '82484', 'WOOD BLACK BOARD ANT WHITE FINISH', 3, '12/1/2010 9:53', 6.45, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (157, '536384', '84755', 'COLOUR GLASS T-LIGHT HOLDER HANGING', 48, '12/1/2010 9:53', 0.65, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (158, '536384', '22464', 'HANGING METAL HEART LANTERN', 12, '12/1/2010 9:53', 1.65, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (159, '536384', '21324', 'HANGING MEDINA LANTERN SMALL', 6, '12/1/2010 9:53', 2.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (160, '536384', '22457', 'NATURAL SLATE HEART CHALKBOARD ', 12, '12/1/2010 9:53', 2.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (161, '536384', '22469', 'HEART OF WICKER SMALL', 40, '12/1/2010 9:53', 1.45, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (162, '536384', '22470', 'HEART OF WICKER LARGE', 40, '12/1/2010 9:53', 2.55, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (163, '536384', '22224', 'WHITE LOVEBIRD LANTERN', 6, '12/1/2010 9:53', 2.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (164, '536384', '21340', 'CLASSIC METAL BIRDCAGE PLANT HOLDER', 2, '12/1/2010 9:53', 12.75, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (165, '536384', '22189', 'CREAM HEART CARD HOLDER', 4, '12/1/2010 9:53', 3.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (166, '536384', '22427', 'ENAMEL FLOWER JUG CREAM', 3, '12/1/2010 9:53', 5.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (167, '536384', '22428', 'ENAMEL FIRE BUCKET CREAM', 6, '12/1/2010 9:53', 6.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (168, '536384', '22424', 'ENAMEL BREAD BIN CREAM', 8, '12/1/2010 9:53', 10.95, '18074', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (169, '536385', '22783', 'SET 3 WICKER OVAL BASKETS W LIDS', 1, '12/1/2010 9:56', 19.95, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (170, '536385', '22961', 'JAM MAKING SET PRINTED', 12, '12/1/2010 9:56', 1.45, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (171, '536385', '22960', 'JAM MAKING SET WITH JARS', 6, '12/1/2010 9:56', 4.25, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (172, '536385', '22663', 'JUMBO BAG DOLLY GIRL DESIGN', 10, '12/1/2010 9:56', 1.95, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (173, '536385', '85049A', 'TRADITIONAL CHRISTMAS RIBBONS', 12, '12/1/2010 9:56', 1.25, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (174, '536385', '22168', 'ORGANISER WOOD ANTIQUE WHITE ', 2, '12/1/2010 9:56', 8.50, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (175, '536385', '22662', 'LUNCH BAG DOLLY GIRL DESIGN', 10, '12/1/2010 9:56', 1.65, '17420', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (176, '536386', '84880', 'WHITE WIRE EGG HOLDER', 36, '12/1/2010 9:57', 4.95, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (177, '536386', '85099C', 'JUMBO  BAG BAROQUE BLACK WHITE', 100, '12/1/2010 9:57', 1.65, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (178, '536386', '85099B', 'JUMBO BAG RED RETROSPOT', 100, '12/1/2010 9:57', 1.65, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (179, '536387', '79321', 'CHILLI LIGHTS', 192, '12/1/2010 9:58', 3.82, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (180, '536387', '22780', 'LIGHT GARLAND BUTTERFILES PINK', 192, '12/1/2010 9:58', 3.37, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (181, '536387', '22779', 'WOODEN OWLS LIGHT GARLAND ', 192, '12/1/2010 9:58', 3.37, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (182, '536387', '22466', 'FAIRY TALE COTTAGE NIGHTLIGHT', 432, '12/1/2010 9:58', 1.45, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (183, '536387', '21731', 'RED TOADSTOOL LED NIGHT LIGHT', 432, '12/1/2010 9:58', 1.25, '16029', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (184, '536388', '21754', 'HOME BUILDING BLOCK WORD', 3, '12/1/2010 9:59', 5.95, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (185, '536388', '21755', 'LOVE BUILDING BLOCK WORD', 3, '12/1/2010 9:59', 5.95, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (186, '536388', '21523', 'DOORMAT FANCY FONT HOME SWEET HOME', 2, '12/1/2010 9:59', 7.95, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (187, '536388', '21363', 'HOME SMALL WOOD LETTERS', 3, '12/1/2010 9:59', 4.95, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (188, '536388', '21411', 'GINGHAM HEART  DOORSTOP RED', 3, '12/1/2010 9:59', 4.25, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (189, '536388', '22318', 'FIVE HEART HANGING DECORATION', 6, '12/1/2010 9:59', 2.95, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (190, '536388', '22464', 'HANGING METAL HEART LANTERN', 12, '12/1/2010 9:59', 1.65, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (191, '536388', '22915', 'ASSORTED BOTTLE TOP  MAGNETS ', 12, '12/1/2010 9:59', 0.42, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (192, '536388', '22922', 'FRIDGE MAGNETS US DINER ASSORTED', 12, '12/1/2010 9:59', 0.85, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (193, '536388', '22969', 'HOMEMADE JAM SCENTED CANDLES', 12, '12/1/2010 9:59', 1.45, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (194, '536388', '22923', 'FRIDGE MAGNETS LES ENFANTS ASSORTED', 12, '12/1/2010 9:59', 0.85, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (195, '536388', '21115', 'ROSE CARAVAN DOORSTOP', 4, '12/1/2010 9:59', 6.75, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (196, '536388', '22469', 'HEART OF WICKER SMALL', 12, '12/1/2010 9:59', 1.65, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (197, '536388', '22242', '5 HOOK HANGER MAGIC TOADSTOOL', 12, '12/1/2010 9:59', 1.65, '16250', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (198, '536389', '22941', 'CHRISTMAS LIGHTS 10 REINDEER', 6, '12/1/2010 10:03', 8.50, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (199, '536389', '21622', 'VINTAGE UNION JACK CUSHION COVER', 8, '12/1/2010 10:03', 4.95, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (200, '536389', '21791', 'VINTAGE HEADS AND TAILS CARD GAME ', 12, '12/1/2010 10:03', 1.25, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (201, '536389', '35004C', 'SET OF 3 COLOURED  FLYING DUCKS', 6, '12/1/2010 10:03', 5.45, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (202, '536389', '35004G', 'SET OF 3 GOLD FLYING DUCKS', 4, '12/1/2010 10:03', 6.35, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (203, '536389', '85014B', 'RED RETROSPOT UMBRELLA', 6, '12/1/2010 10:03', 5.95, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (204, '536389', '85014A', 'BLACK/BLUE POLKADOT UMBRELLA', 3, '12/1/2010 10:03', 5.95, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (205, '536389', '22193', 'RED DINER WALL CLOCK', 2, '12/1/2010 10:03', 8.50, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (206, '536389', '22726', 'ALARM CLOCK BAKELIKE GREEN', 4, '12/1/2010 10:03', 3.75, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (207, '536389', '22727', 'ALARM CLOCK BAKELIKE RED ', 4, '12/1/2010 10:03', 3.75, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (208, '536389', '22192', 'BLUE DINER WALL CLOCK', 2, '12/1/2010 10:03', 8.50, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (209, '536389', '22191', 'IVORY DINER WALL CLOCK', 2, '12/1/2010 10:03', 8.50, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (210, '536389', '22195', 'LARGE HEART MEASURING SPOONS', 24, '12/1/2010 10:03', 1.65, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (211, '536389', '22196', 'SMALL HEART MEASURING SPOONS', 24, '12/1/2010 10:03', 0.85, '12431', 'Australia');
INSERT INTO `sample_data_e_commerce` VALUES (212, '536390', '22941', 'CHRISTMAS LIGHTS 10 REINDEER', 2, '12/1/2010 10:19', 8.50, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (213, '536390', '22960', 'JAM MAKING SET WITH JARS', 12, '12/1/2010 10:19', 3.75, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (214, '536390', '22961', 'JAM MAKING SET PRINTED', 12, '12/1/2010 10:19', 1.45, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (215, '536390', '22962', 'JAM JAR WITH PINK LID', 48, '12/1/2010 10:19', 0.72, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (216, '536390', '22963', 'JAM JAR WITH GREEN LID', 48, '12/1/2010 10:19', 0.72, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (217, '536390', '22968', 'ROSE COTTAGE KEEPSAKE BOX ', 8, '12/1/2010 10:19', 8.50, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (218, '536390', '84970S', 'HANGING HEART ZINC T-LIGHT HOLDER', 144, '12/1/2010 10:19', 0.64, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (219, '536390', '22910', 'PAPER CHAIN KIT VINTAGE CHRISTMAS', 40, '12/1/2010 10:19', 2.55, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (220, '536390', '20668', 'DISCO BALL CHRISTMAS DECORATION', 288, '12/1/2010 10:19', 0.10, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (221, '536390', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 64, '12/1/2010 10:19', 2.55, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (222, '536390', '22197', 'SMALL POPCORN HOLDER', 100, '12/1/2010 10:19', 0.72, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (223, '536390', '22198', 'LARGE POPCORN HOLDER ', 50, '12/1/2010 10:19', 1.45, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (224, '536390', '21533', 'RETROSPOT LARGE MILK JUG', 12, '12/1/2010 10:19', 4.25, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (225, '536390', '21080', 'SET/20 RED RETROSPOT PAPER NAPKINS ', 96, '12/1/2010 10:19', 0.64, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (226, '536390', '21094', 'SET/6 RED SPOTTY PAPER PLATES', 96, '12/1/2010 10:19', 0.64, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (227, '536390', '21086', 'SET/6 RED SPOTTY PAPER CUPS', 48, '12/1/2010 10:19', 0.65, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (228, '536390', '21786', 'POLKADOT RAIN HAT ', 144, '12/1/2010 10:19', 0.32, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (229, '536390', '22654', 'DELUXE SEWING KIT ', 40, '12/1/2010 10:19', 4.95, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (230, '536390', '21485', 'RETROSPOT HEART HOT WATER BOTTLE', 24, '12/1/2010 10:19', 4.25, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (231, '536390', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 24, '12/1/2010 10:19', 3.39, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (232, '536390', '84030E', 'ENGLISH ROSE HOT WATER BOTTLE', 24, '12/1/2010 10:19', 3.75, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (233, '536390', '22174', 'PHOTO CUBE', 48, '12/1/2010 10:19', 1.48, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (234, '536390', '22969', 'HOMEMADE JAM SCENTED CANDLES', 96, '12/1/2010 10:19', 1.25, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (235, '536390', '85099B', 'JUMBO BAG RED RETROSPOT', 100, '12/1/2010 10:19', 1.65, '17511', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (236, 'C536391', '22556', 'PLASTERS IN TIN CIRCUS PARADE ', -12, '12/1/2010 10:24', 1.65, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (237, 'C536391', '21984', 'PACK OF 12 PINK PAISLEY TISSUES ', -24, '12/1/2010 10:24', 0.29, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (238, 'C536391', '21983', 'PACK OF 12 BLUE PAISLEY TISSUES ', -24, '12/1/2010 10:24', 0.29, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (239, 'C536391', '21980', 'PACK OF 12 RED RETROSPOT TISSUES ', -24, '12/1/2010 10:24', 0.29, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (240, 'C536391', '21484', 'CHICK GREY HOT WATER BOTTLE', -12, '12/1/2010 10:24', 3.45, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (241, 'C536391', '22557', 'PLASTERS IN TIN VINTAGE PAISLEY ', -12, '12/1/2010 10:24', 1.65, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (242, 'C536391', '22553', 'PLASTERS IN TIN SKULLS', -24, '12/1/2010 10:24', 1.65, '17548', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (243, '536392', '22150', '3 STRIPEY MICE FELTCRAFT', 6, '12/1/2010 10:29', 1.95, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (244, '536392', '22619', 'SET OF 6 SOLDIER SKITTLES', 4, '12/1/2010 10:29', 3.75, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (245, '536392', '21891', 'TRADITIONAL WOODEN SKIPPING ROPE', 12, '12/1/2010 10:29', 1.25, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (246, '536392', '21889', 'WOODEN BOX OF DOMINOES', 12, '12/1/2010 10:29', 1.25, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (247, '536392', '22827', 'RUSTIC  SEVENTEEN DRAWER SIDEBOARD', 1, '12/1/2010 10:29', 165.00, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (248, '536392', '22127', 'PARTY CONES CARNIVAL ASSORTED', 12, '12/1/2010 10:29', 1.25, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (249, '536392', '22128', 'PARTY CONES CANDY ASSORTED', 12, '12/1/2010 10:29', 1.25, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (250, '536392', '22502', 'PICNIC BASKET WICKER SMALL', 4, '12/1/2010 10:29', 5.95, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (251, '536392', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 16, '12/1/2010 10:29', 1.69, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (252, '536392', '22338', 'STAR DECORATION PAINTED ZINC ', 24, '12/1/2010 10:29', 0.65, '13705', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (253, '536393', '22180', 'RETROSPOT LAMP', 8, '12/1/2010 10:37', 9.95, '13747', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (254, '536394', '21506', 'FANCY FONT BIRTHDAY CARD, ', 24, '12/1/2010 10:39', 0.42, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (255, '536394', '22633', 'HAND WARMER UNION JACK', 96, '12/1/2010 10:39', 1.85, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (256, '536394', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 96, '12/1/2010 10:39', 1.85, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (257, '536394', '22865', 'HAND WARMER OWL DESIGN', 96, '12/1/2010 10:39', 1.85, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (258, '536394', '22632', 'HAND WARMER RED RETROSPOT', 96, '12/1/2010 10:39', 1.85, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (259, '536394', '21485', 'RETROSPOT HEART HOT WATER BOTTLE', 12, '12/1/2010 10:39', 4.95, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (260, '536394', '22349', 'DOG BOWL CHASING BALL DESIGN', 12, '12/1/2010 10:39', 3.75, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (261, '536394', '22558', 'CLOTHES PEGS RETROSPOT PACK 24 ', 48, '12/1/2010 10:39', 1.25, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (262, '536394', '85152', 'HAND OVER THE CHOCOLATE   SIGN ', 12, '12/1/2010 10:39', 2.10, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (263, '536394', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 32, '12/1/2010 10:39', 2.55, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (264, '536394', '22652', 'TRAVEL SEWING KIT', 20, '12/1/2010 10:39', 1.65, '13408', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (265, '536395', '22188', 'BLACK HEART CARD HOLDER', 8, '12/1/2010 10:47', 3.95, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (266, '536395', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 32, '12/1/2010 10:47', 1.69, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (267, '536395', '21977', 'PACK OF 60 PINK PAISLEY CAKE CASES', 24, '12/1/2010 10:47', 0.55, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (268, '536395', '84991', '60 TEATIME FAIRY CAKE CASES', 24, '12/1/2010 10:47', 0.55, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (269, '536395', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 24, '12/1/2010 10:47', 0.55, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (270, '536395', '21484', 'CHICK GREY HOT WATER BOTTLE', 8, '12/1/2010 10:47', 3.45, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (271, '536395', '21314', 'SMALL GLASS HEART TRINKET POT', 8, '12/1/2010 10:47', 2.10, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (272, '536395', '22730', 'ALARM CLOCK BAKELIKE IVORY', 4, '12/1/2010 10:47', 3.75, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (273, '536395', '22727', 'ALARM CLOCK BAKELIKE RED ', 8, '12/1/2010 10:47', 3.75, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (274, '536395', '22729', 'ALARM CLOCK BAKELIKE ORANGE', 8, '12/1/2010 10:47', 3.75, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (275, '536395', '22726', 'ALARM CLOCK BAKELIKE GREEN', 8, '12/1/2010 10:47', 3.75, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (276, '536395', '22114', 'HOT WATER BOTTLE TEA AND SYMPATHY', 8, '12/1/2010 10:47', 3.95, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (277, '536395', '22867', 'HAND WARMER BIRD DESIGN', 48, '12/1/2010 10:47', 2.10, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (278, '536395', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 48, '12/1/2010 10:47', 2.10, '13767', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (279, '536396', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 10:51', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (280, '536396', '71053', 'WHITE METAL LANTERN', 6, '12/1/2010 10:51', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (281, '536396', '84406B', 'CREAM CUPID HEARTS COAT HANGER', 8, '12/1/2010 10:51', 2.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (282, '536396', '15056BL', 'EDWARDIAN PARASOL BLACK', 6, '12/1/2010 10:51', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (283, '536396', '20679', 'EDWARDIAN PARASOL RED', 6, '12/1/2010 10:51', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (284, '536396', '37370', 'RETRO COFFEE MUGS ASSORTED', 6, '12/1/2010 10:51', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (285, '536396', '21871', 'SAVE THE PLANET MUG', 6, '12/1/2010 10:51', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (286, '536396', '21071', 'VINTAGE BILLBOARD DRINK ME MUG', 6, '12/1/2010 10:51', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (287, '536396', '21068', 'VINTAGE BILLBOARD LOVE/HATE MUG', 6, '12/1/2010 10:51', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (288, '536396', '82483', 'WOOD 2 DRAWER CABINET WHITE FINISH', 2, '12/1/2010 10:51', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (289, '536396', '82486', 'WOOD S/3 CABINET ANT WHITE FINISH', 4, '12/1/2010 10:51', 6.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (290, '536396', '82482', 'WOODEN PICTURE FRAME WHITE FINISH', 6, '12/1/2010 10:51', 2.10, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (291, '536396', '82494L', 'WOODEN FRAME ANTIQUE WHITE ', 12, '12/1/2010 10:51', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (292, '536396', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 6, '12/1/2010 10:51', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (293, '536396', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 6, '12/1/2010 10:51', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (294, '536396', '22752', 'SET 7 BABUSHKA NESTING BOXES', 2, '12/1/2010 10:51', 7.65, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (295, '536396', '22803', 'IVORY EMBROIDERED QUILT ', 2, '12/1/2010 10:51', 35.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (296, '536396', '21730', 'GLASS STAR FROSTED T-LIGHT HOLDER', 6, '12/1/2010 10:51', 4.25, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (297, '536397', '35004B', 'SET OF 3 BLACK FLYING DUCKS', 12, '12/1/2010 10:51', 4.65, '17924', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (298, '536397', '35004C', 'SET OF 3 COLOURED  FLYING DUCKS', 48, '12/1/2010 10:51', 4.65, '17924', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (299, '536398', '21980', 'PACK OF 12 RED RETROSPOT TISSUES ', 24, '12/1/2010 10:52', 0.29, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (300, '536398', '21844', 'RED RETROSPOT MUG', 6, '12/1/2010 10:52', 2.95, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (301, '536398', '22468', 'BABUSHKA LIGHTS STRING OF 10', 4, '12/1/2010 10:52', 6.75, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (302, '536398', '22637', 'PIGGY BANK RETROSPOT ', 8, '12/1/2010 10:52', 2.55, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (303, '536398', '22752', 'SET 7 BABUSHKA NESTING BOXES', 6, '12/1/2010 10:52', 8.50, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (304, '536398', '48185', 'DOORMAT FAIRY CAKE', 2, '12/1/2010 10:52', 7.95, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (305, '536398', '22632', 'HAND WARMER RED RETROSPOT', 12, '12/1/2010 10:52', 2.10, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (306, '536398', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 12, '12/1/2010 10:52', 2.10, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (307, '536398', '22865', 'HAND WARMER OWL DESIGN', 12, '12/1/2010 10:52', 2.10, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (308, '536398', '21232', 'STRAWBERRY CERAMIC TRINKET BOX', 12, '12/1/2010 10:52', 1.25, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (309, '536398', '22064', 'PINK DOUGHNUT TRINKET POT ', 12, '12/1/2010 10:52', 1.65, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (310, '536398', '22449', 'SILK PURSE BABUSHKA PINK', 6, '12/1/2010 10:52', 3.35, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (311, '536398', '22114', 'HOT WATER BOTTLE TEA AND SYMPATHY', 4, '12/1/2010 10:52', 3.95, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (312, '536398', '22835', 'HOT WATER BOTTLE I AM SO POORLY', 8, '12/1/2010 10:52', 4.65, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (313, '536398', '22112', 'CHOCOLATE HOT WATER BOTTLE', 9, '12/1/2010 10:52', 4.95, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (314, '536398', '21479', 'WHITE SKULL HOT WATER BOTTLE ', 4, '12/1/2010 10:52', 3.75, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (315, '536398', '22111', 'SCOTTIE DOG HOT WATER BOTTLE', 9, '12/1/2010 10:52', 4.95, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (316, '536399', '22632', 'HAND WARMER RED POLKA DOT', 6, '12/1/2010 10:52', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (317, '536399', '22633', 'HAND WARMER UNION JACK', 6, '12/1/2010 10:52', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (318, '536400', '22969', 'HOMEMADE JAM SCENTED CANDLES', 12, '12/1/2010 10:53', 1.45, '13448', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (319, '536401', '22110', 'BIRD HOUSE HOT WATER BOTTLE', 1, '12/1/2010 11:21', 2.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (320, '536401', '22098', 'BOUDOIR SQUARE TISSUE BOX', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (321, '536401', '22100', 'SKULLS SQUARE TISSUE BOX', 2, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (322, '536401', '22766', 'PHOTO FRAME CORNICE', 1, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (323, '536401', '22451', 'SILK PURSE BABUSHKA RED', 1, '12/1/2010 11:21', 3.35, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (324, '536401', '22549', 'PICTURE DOMINOES', 1, '12/1/2010 11:21', 1.45, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (325, '536401', '84744', 'S/6 SEW ON CROCHET FLOWERS', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (326, '536401', '85049E', 'SCANDINAVIAN REDS RIBBONS', 2, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (327, '536401', '21328', 'BALLOONS  WRITING SET ', 1, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (328, '536401', '22961', 'JAM MAKING SET PRINTED', 4, '12/1/2010 11:21', 1.45, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (329, '536401', '17091A', 'LAVENDER INCENSE IN TIN', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (330, '536401', '22473', 'TV DINNER TRAY VINTAGE PAISLEY', 1, '12/1/2010 11:21', 4.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (331, '536401', '84509A', 'SET OF 4 ENGLISH ROSE PLACEMATS', 2, '12/1/2010 11:21', 3.75, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (332, '536401', '84510A', 'SET OF 4 ENGLISH ROSE COASTERS', 2, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (333, '536401', '22767', 'TRIPLE PHOTO FRAME CORNICE ', 2, '12/1/2010 11:21', 9.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (334, '536401', '22768', 'FAMILY PHOTO FRAME CORNICE', 1, '12/1/2010 11:21', 9.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (335, '536401', '21463', 'MIRRORED DISCO BALL ', 1, '12/1/2010 11:21', 5.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (336, '536401', '21464', 'DISCO BALL ROTATOR BATTERY OPERATED', 1, '12/1/2010 11:21', 4.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (337, '536401', '20820', 'SILVER LOOKING MIRROR', 3, '12/1/2010 11:21', 4.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (338, '536401', '85150', 'LADIES & GENTLEMEN METAL SIGN', 1, '12/1/2010 11:21', 2.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (339, '536401', '22117', 'METAL SIGN HER DINNER IS SERVED ', 1, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (340, '536401', '21169', 'YOU\'RE CONFUSING ME METAL SIGN ', 2, '12/1/2010 11:21', 1.69, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (341, '536401', '48129', 'DOORMAT TOPIARY', 1, '12/1/2010 11:21', 7.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (342, '536401', '82580', 'BATHROOM METAL SIGN', 1, '12/1/2010 11:21', 0.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (343, '536401', '82578', 'KITCHEN METAL SIGN', 1, '12/1/2010 11:21', 0.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (344, '536401', '82581', 'TOILET METAL SIGN', 2, '12/1/2010 11:21', 0.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (345, '536401', '22413', 'METAL SIGN TAKE IT OR LEAVE IT ', 4, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (346, '536401', '21907', 'I\'M ON HOLIDAY METAL SIGN', 2, '12/1/2010 11:21', 2.10, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (347, '536401', '22441', 'GROW YOUR OWN BASIL IN ENAMEL MUG', 1, '12/1/2010 11:21', 2.10, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (348, '536401', '21122', 'SET/10 PINK POLKADOT PARTY CANDLES', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (349, '536401', '22851', 'SET 20 NAPKINS FAIRY CAKES DESIGN ', 1, '12/1/2010 11:21', 0.85, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (350, '536401', '84991', '60 TEATIME FAIRY CAKE CASES', 3, '12/1/2010 11:21', 0.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (351, '536401', '22810', 'SET OF 6 T-LIGHTS SNOWMEN', 1, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (352, '536401', '22809', 'SET OF 6 T-LIGHTS SANTA', 1, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (353, '536401', '22435', 'SET OF 9 HEART SHAPED BALLOONS', 2, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (354, '536401', '20966', 'SANDWICH BATH SPONGE', 3, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (355, '536401', '20963', 'APPLE BATH SPONGE', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (356, '536401', '20961', 'STRAWBERRY BATH SPONGE ', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (357, '536401', '22068', 'BLACK PIRATE TREASURE CHEST', 2, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (358, '536401', '21743', 'STAR PORTABLE TABLE LIGHT ', 2, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (359, '536401', '21744', 'SNOWFLAKE PORTABLE TABLE LIGHT ', 2, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (360, '536401', '84709B', 'PINK OVAL JEWELLED MIRROR', 1, '12/1/2010 11:21', 5.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (361, '536401', '21592', 'RETROSPOT CIGAR BOX MATCHES ', 1, '12/1/2010 11:21', 1.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (362, '536401', '21587', 'COSY HOUR GIANT TUBE MATCHES', 2, '12/1/2010 11:21', 2.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (363, '536401', '20992', 'JAZZ HEARTS PURSE NOTEBOOK', 9, '12/1/2010 11:21', 0.85, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (364, '536401', '22662', 'LUNCH BAG DOLLY GIRL DESIGN', 1, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (365, '536401', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 4, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (366, '536401', '22804', 'CANDLEHOLDER PINK HANGING HEART', 3, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (367, '536401', '82483', 'WOOD 2 DRAWER CABINET WHITE FINISH', 1, '12/1/2010 11:21', 5.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (368, '536401', '20749', 'ASSORTED COLOUR MINI CASES', 1, '12/1/2010 11:21', 7.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (369, '536401', '20725', 'LUNCH BAG RED RETROSPOT', 1, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (370, '536401', '22382', 'LUNCH BAG SPACEBOY DESIGN ', 2, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (371, '536401', '20726', 'LUNCH BAG WOODLAND', 1, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (372, '536401', '22384', 'LUNCH BAG PINK POLKADOT', 1, '12/1/2010 11:21', 1.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (373, '536401', '22467', 'GUMBALL COAT RACK', 5, '12/1/2010 11:21', 2.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (374, '536401', '84625C', 'BLUE NEW BAROQUE CANDLESTICK CANDLE', 3, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (375, '536401', '84625A', 'PINK NEW BAROQUECANDLESTICK CANDLE', 3, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (376, '536401', '21108', 'FAIRY CAKE FLANNEL ASSORTED COLOUR', 9, '12/1/2010 11:21', 2.55, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (377, '536401', '22848', 'BREAD BIN DINER STYLE PINK', 1, '12/1/2010 11:21', 16.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (378, '536401', '21033', 'JUMBO BAG CHARLIE AND LOLA TOYS', 4, '12/1/2010 11:21', 2.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (379, '536401', '47570B', 'TEA TIME TABLE CLOTH', 1, '12/1/2010 11:21', 10.65, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (380, '536401', '84030E', 'ENGLISH ROSE HOT WATER BOTTLE', 1, '12/1/2010 11:21', 4.25, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (381, '536401', '22428', 'ENAMEL FIRE BUCKET CREAM', 2, '12/1/2010 11:21', 6.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (382, '536401', '22502', 'PICNIC BASKET WICKER SMALL', 2, '12/1/2010 11:21', 5.95, '15862', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (383, '536402', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 40, '12/1/2010 11:22', 2.55, '15513', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (384, '536402', '22910', 'PAPER CHAIN KIT VINTAGE CHRISTMAS', 40, '12/1/2010 11:22', 2.55, '15513', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (385, '536402', '22837', 'HOT WATER BOTTLE BABUSHKA ', 36, '12/1/2010 11:22', 4.25, '15513', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (386, '536403', '22867', 'HAND WARMER BIRD DESIGN', 96, '12/1/2010 11:27', 1.85, '12791', 'Netherlands');
INSERT INTO `sample_data_e_commerce` VALUES (387, '536403', 'POST', 'POSTAGE', 1, '12/1/2010 11:27', 15.00, '12791', 'Netherlands');
INSERT INTO `sample_data_e_commerce` VALUES (388, '536404', '22297', 'HEART IVORY TRELLIS SMALL', 24, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (389, '536404', '22771', 'CLEAR DRAWER KNOB ACRYLIC EDWARDIAN', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (390, '536404', '22772', 'PINK DRAWER KNOB ACRYLIC EDWARDIAN', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (391, '536404', '22773', 'GREEN DRAWER KNOB ACRYLIC EDWARDIAN', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (392, '536404', '22805', 'BLUE DRAWER KNOB ACRYLIC EDWARDIAN', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (393, '536404', '22469', 'HEART OF WICKER SMALL', 12, '12/1/2010 11:29', 1.65, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (394, '536404', '22197', 'SMALL POPCORN HOLDER', 36, '12/1/2010 11:29', 0.85, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (395, '536404', '21125', 'SET 6 FOOTBALL CELEBRATION CANDLES', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (396, '536404', '21126', 'SET OF 6 GIRLS CELEBRATION CANDLES', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (397, '536404', '85049C', 'ROMANTIC PINKS RIBBONS ', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (398, '536404', '85049D', 'BRIGHT BLUES RIBBONS ', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (399, '536404', '85049E', 'SCANDINAVIAN REDS RIBBONS', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (400, '536404', '85049G', 'CHOCOLATE BOX RIBBONS ', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (401, '536404', '21061', 'PARTY INVITES FOOTBALL', 12, '12/1/2010 11:29', 0.85, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (402, '536404', '21063', 'PARTY INVITES JAZZ HEARTS', 12, '12/1/2010 11:29', 0.85, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (403, '536404', '21062', 'PARTY INVITES SPACEMAN', 12, '12/1/2010 11:29', 0.85, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (404, '536404', '84380', 'SET OF 3 BUTTERFLY COOKIE CUTTERS', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (405, '536404', '84378', 'SET OF 3 HEART COOKIE CUTTERS', 12, '12/1/2010 11:29', 1.25, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (406, '536404', '22964', '3 PIECE SPACEBOY COOKIE CUTTER SET', 12, '12/1/2010 11:29', 2.10, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (407, '536404', '21213', 'PACK OF 72 SKULL CAKE CASES', 24, '12/1/2010 11:29', 0.55, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (408, '536404', '22417', 'PACK OF 60 SPACEBOY CAKE CASES', 24, '12/1/2010 11:29', 0.55, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (409, '536404', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 24, '12/1/2010 11:29', 0.55, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (410, '536404', '84992', '72 SWEETHEART FAIRY CAKE CASES', 24, '12/1/2010 11:29', 0.55, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (411, '536404', '21975', 'PACK OF 60 DINOSAUR CAKE CASES', 24, '12/1/2010 11:29', 0.55, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (412, '536404', '22383', 'LUNCH BAG SUKI  DESIGN ', 10, '12/1/2010 11:29', 1.65, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (413, '536404', '20728', 'LUNCH BAG CARS BLUE', 10, '12/1/2010 11:29', 1.65, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (414, '536404', '20727', 'LUNCH BAG  BLACK SKULL.', 10, '12/1/2010 11:29', 1.65, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (415, '536404', '22296', 'HEART IVORY TRELLIS LARGE', 24, '12/1/2010 11:29', 1.65, '16218', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (416, '536405', '20914', 'SET/5 RED RETROSPOT LID GLASS BOWLS', 128, '12/1/2010 11:32', 2.55, '14045', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (417, '536406', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 8, '12/1/2010 11:33', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (418, '536406', '71053', 'WHITE METAL LANTERN', 8, '12/1/2010 11:33', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (419, '536406', '84406B', 'CREAM CUPID HEARTS COAT HANGER', 8, '12/1/2010 11:33', 2.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (420, '536406', '20679', 'EDWARDIAN PARASOL RED', 6, '12/1/2010 11:33', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (421, '536406', '37370', 'RETRO COFFEE MUGS ASSORTED', 6, '12/1/2010 11:33', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (422, '536406', '21871', 'SAVE THE PLANET MUG', 6, '12/1/2010 11:33', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (423, '536406', '21071', 'VINTAGE BILLBOARD DRINK ME MUG', 6, '12/1/2010 11:33', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (424, '536406', '21068', 'VINTAGE BILLBOARD LOVE/HATE MUG', 6, '12/1/2010 11:33', 1.06, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (425, '536406', '82483', 'WOOD 2 DRAWER CABINET WHITE FINISH', 4, '12/1/2010 11:33', 4.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (426, '536406', '82486', 'WOOD S/3 CABINET ANT WHITE FINISH', 4, '12/1/2010 11:33', 6.95, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (427, '536406', '82482', 'WOODEN PICTURE FRAME WHITE FINISH', 6, '12/1/2010 11:33', 2.10, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (428, '536406', '82494L', 'WOODEN FRAME ANTIQUE WHITE ', 6, '12/1/2010 11:33', 2.55, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (429, '536406', '84029G', 'KNITTED UNION FLAG HOT WATER BOTTLE', 6, '12/1/2010 11:33', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (430, '536406', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 6, '12/1/2010 11:33', 3.39, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (431, '536406', '22752', 'SET 7 BABUSHKA NESTING BOXES', 2, '12/1/2010 11:33', 7.65, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (432, '536406', '22803', 'IVORY EMBROIDERED QUILT ', 2, '12/1/2010 11:33', 35.75, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (433, '536406', '21730', 'GLASS STAR FROSTED T-LIGHT HOLDER', 6, '12/1/2010 11:33', 4.25, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (434, '536407', '22632', 'HAND WARMER RED POLKA DOT', 6, '12/1/2010 11:34', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (435, '536407', '22633', 'HAND WARMER UNION JACK', 6, '12/1/2010 11:34', 1.85, '17850', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (436, '536408', '22537', 'MAGIC DRAWING SLATE DINOSAUR', 24, '12/1/2010 11:41', 0.42, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (437, '536408', '22533', 'MAGIC DRAWING SLATE BAKE A CAKE ', 24, '12/1/2010 11:41', 0.42, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (438, '536408', '20982', '12 PENCILS TALL TUBE SKULLS', 12, '12/1/2010 11:41', 0.85, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (439, '536408', '21832', 'CHOCOLATE CALCULATOR', 12, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (440, '536408', '21915', 'RED  HARMONICA IN BOX ', 12, '12/1/2010 11:41', 1.25, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (441, '536408', '21914', 'BLUE HARMONICA IN BOX ', 12, '12/1/2010 11:41', 1.25, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (442, '536408', '21544', 'SKULLS  WATER TRANSFER TATTOOS ', 12, '12/1/2010 11:41', 0.85, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (443, '536408', '22813', 'PACK 3 BOXES BIRD PANNETONE ', 12, '12/1/2010 11:41', 1.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (444, '536408', '22114', 'HOT WATER BOTTLE TEA AND SYMPATHY', 4, '12/1/2010 11:41', 3.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (445, '536408', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 4, '12/1/2010 11:41', 3.75, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (446, '536408', '21479', 'WHITE SKULL HOT WATER BOTTLE ', 4, '12/1/2010 11:41', 3.75, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (447, '536408', '22964', '3 PIECE SPACEBOY COOKIE CUTTER SET', 6, '12/1/2010 11:41', 2.10, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (448, '536408', '84375', 'SET OF 20 KIDS COOKIE CUTTERS', 12, '12/1/2010 11:41', 2.10, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (449, '536408', '22418', '10 COLOUR SPACEBOY PEN', 24, '12/1/2010 11:41', 0.85, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (450, '536408', '22178', 'VICTORIAN GLASS HANGING T-LIGHT', 12, '12/1/2010 11:41', 1.25, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (451, '536408', '84970L', 'SINGLE HEART ZINC T-LIGHT HOLDER', 12, '12/1/2010 11:41', 0.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (452, '536408', '21733', 'RED HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 11:41', 2.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (453, '536408', '22465', 'HANGING METAL STAR LANTERN', 12, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (454, '536408', '84949', 'SILVER HANGING T-LIGHT HOLDER', 6, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (455, '536408', '20685', 'DOORMAT RED RETROSPOT', 2, '12/1/2010 11:41', 7.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (456, '536408', '48194', 'DOORMAT HEARTS', 2, '12/1/2010 11:41', 7.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (457, '536408', '22488', 'NATURAL SLATE RECTANGLE CHALKBOARD', 12, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (458, '536408', '22219', 'LOVEBIRD HANGING DECORATION WHITE ', 12, '12/1/2010 11:41', 0.85, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (459, '536408', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 8, '12/1/2010 11:41', 1.69, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (460, '536408', '21754', 'HOME BUILDING BLOCK WORD', 3, '12/1/2010 11:41', 5.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (461, '536408', '21755', 'LOVE BUILDING BLOCK WORD', 3, '12/1/2010 11:41', 5.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (462, '536408', '22766', 'PHOTO FRAME CORNICE', 8, '12/1/2010 11:41', 2.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (463, '536408', '22610', 'PENS ASSORTED FUNNY FACE', 36, '12/1/2010 11:41', 0.85, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (464, '536408', '22716', 'CARD CIRCUS PARADE', 12, '12/1/2010 11:41', 0.42, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (465, '536408', '22706', 'WRAP COWBOYS  ', 25, '12/1/2010 11:41', 0.42, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (466, '536408', '22371', 'AIRLINE BAG VINTAGE TOKYO 78', 4, '12/1/2010 11:41', 4.25, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (467, '536408', '85014B', 'RED RETROSPOT UMBRELLA', 3, '12/1/2010 11:41', 5.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (468, '536408', '85014A', 'BLACK/BLUE POLKADOT UMBRELLA', 3, '12/1/2010 11:41', 5.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (469, '536408', '84997B', 'RED 3 PIECE RETROSPOT CUTLERY SET', 6, '12/1/2010 11:41', 3.75, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (470, '536408', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 24, '12/1/2010 11:41', 0.55, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (471, '536408', '21210', 'SET OF 72 RETROSPOT PAPER  DOILIES', 12, '12/1/2010 11:41', 1.45, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (472, '536408', '22914', 'BLUE COAT RACK PARIS FASHION', 3, '12/1/2010 11:41', 4.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (473, '536408', '22553', 'PLASTERS IN TIN SKULLS', 12, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (474, '536408', '16237', 'SLEEPING CAT ERASERS', 30, '12/1/2010 11:41', 0.21, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (475, '536408', '22714', 'CARD BIRTHDAY COWBOY', 12, '12/1/2010 11:41', 0.42, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (476, '536408', '22812', 'PACK 3 BOXES CHRISTMAS PANNETONE', 12, '12/1/2010 11:41', 1.95, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (477, '536408', '84347', 'ROTATING SILVER ANGELS T-LIGHT HLDR', 6, '12/1/2010 11:41', 2.55, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (478, '536408', '21587', 'COSY HOUR GIANT TUBE MATCHES', 12, '12/1/2010 11:41', 2.55, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (479, '536408', '22736', 'RIBBON REEL MAKING SNOWMEN ', 10, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (480, '536408', '22492', 'MINI PAINT SET VINTAGE ', 36, '12/1/2010 11:41', 0.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (481, '536408', '22620', '4 TRADITIONAL SPINNING TOPS', 12, '12/1/2010 11:41', 1.25, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (482, '536408', '22619', 'SET OF 6 SOLDIER SKITTLES', 4, '12/1/2010 11:41', 3.75, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (483, '536408', '21705', 'BAG 500g SWIRLY MARBLES', 12, '12/1/2010 11:41', 1.65, '14307', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (484, '536409', '90199C', '5 STRAND GLASS NECKLACE CRYSTAL', 3, '12/1/2010 11:45', 6.35, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (485, '536409', '21479', 'WHITE SKULL HOT WATER BOTTLE ', 1, '12/1/2010 11:45', 3.75, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (486, '536409', '22111', 'SCOTTIE DOG HOT WATER BOTTLE', 1, '12/1/2010 11:45', 4.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (487, '536409', '22785', 'SQUARECUSHION COVER PINK UNION FLAG', 1, '12/1/2010 11:45', 6.75, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (488, '536409', '22975', 'SPACEBOY CHILDRENS EGG CUP', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (489, '536409', '22972', 'CHILDREN\'S SPACEBOY MUG', 1, '12/1/2010 11:45', 1.65, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (490, '536409', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 1, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (491, '536409', '22568', 'FELTCRAFT CUSHION OWL', 1, '12/1/2010 11:45', 3.75, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (492, '536409', '85116', 'BLACK CANDELABRA T-LIGHT HOLDER', 1, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (493, '536409', '22664', 'TOY TIDY DOLLY GIRL DESIGN', 1, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (494, '536409', '21609', 'SET 12 LAVENDER  BOTANICAL T-LIGHTS', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (495, '536409', '21866', 'UNION JACK FLAG LUGGAGE TAG', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (496, '536409', '20669', 'RED HEART LUGGAGE TAG', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (497, '536409', '90129F', 'RED GLASS TASSLE BAG CHARM', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (498, '536409', '90210B', 'CLEAR ACRYLIC FACETED BANGLE', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (499, '536409', '90199C', '5 STRAND GLASS NECKLACE CRYSTAL', 1, '12/1/2010 11:45', 6.35, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (500, '536409', '21955', 'DOORMAT UNION JACK GUNS AND ROSES', 1, '12/1/2010 11:45', 7.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (501, '536409', '72802C', 'VANILLA SCENT CANDLE JEWELLED BOX', 1, '12/1/2010 11:45', 4.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (502, '536409', '22109', 'FULL ENGLISH BREAKFAST PLATE', 1, '12/1/2010 11:45', 3.75, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (503, '536409', '85116', 'BLACK CANDELABRA T-LIGHT HOLDER', 5, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (504, '536409', '22531', 'MAGIC DRAWING SLATE CIRCUS PARADE  ', 1, '12/1/2010 11:45', 0.42, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (505, '536409', '21811', 'CHRISTMAS HANGING HEART WITH BELL', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (506, '536409', '22183', 'CAKE STAND VICTORIAN FILIGREE MED', 1, '12/1/2010 11:45', 6.75, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (507, '536409', '21678', 'PAISLEY PATTERN  STICKERS', 6, '12/1/2010 11:45', 0.85, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (508, '536409', '21676', 'FLOWERS  STICKERS', 6, '12/1/2010 11:45', 0.85, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (509, '536409', '84625A', 'PINK NEW BAROQUECANDLESTICK CANDLE', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (510, '536409', '84625C', 'BLUE NEW BAROQUE CANDLESTICK CANDLE', 3, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (511, '536409', '21931', 'JUMBO STORAGE BAG SUKI', 2, '12/1/2010 11:45', 1.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (512, '536409', '85169B', 'BLACK LOVE BIRD CANDLE', 12, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (513, '536409', '16238', 'PARTY TIME PENCIL ERASERS', 28, '12/1/2010 11:45', 0.21, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (514, '536409', '20668', 'DISCO BALL CHRISTMAS DECORATION', 24, '12/1/2010 11:45', 0.12, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (515, '536409', '84906', 'PINK B\'FLY C/COVER W BOBBLES', 1, '12/1/2010 11:45', 5.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (516, '536409', '21867', 'PINK UNION JACK  LUGGAGE TAG', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (517, '536409', '22075', '6 RIBBONS ELEGANT CHRISTMAS ', 1, '12/1/2010 11:45', 1.65, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (518, '536409', '21866', 'UNION JACK FLAG LUGGAGE TAG', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (519, '536409', '21326', 'AGED GLASS SILVER T-LIGHT HOLDER', 12, '12/1/2010 11:45', 0.65, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (520, '536409', '21065', 'BOOM BOX SPEAKER GIRLS', 1, '12/1/2010 11:45', 5.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (521, '536409', '22074', '6 RIBBONS SHIMMERING PINKS ', 1, '12/1/2010 11:45', 1.65, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (522, '536409', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (523, '536409', '20713', 'JUMBO BAG OWLS', 1, '12/1/2010 11:45', 1.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (524, '536409', '20966', 'SANDWICH BATH SPONGE', 2, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (525, '536409', '21116', 'OWL DOORSTOP', 1, '12/1/2010 11:45', 4.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (526, '536409', '90199C', '5 STRAND GLASS NECKLACE CRYSTAL', 2, '12/1/2010 11:45', 6.35, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (527, '536409', '22633', 'HAND WARMER UNION JACK', 1, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (528, '536409', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 1, '12/1/2010 11:45', 2.10, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (529, '536409', '22198', 'LARGE POPCORN HOLDER ', 1, '12/1/2010 11:45', 1.65, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (530, '536409', '21824', 'PAINTED METAL STAR WITH HOLLY BELLS', 3, '12/1/2010 11:45', 1.45, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (531, '536409', '21823', 'PAINTED METAL HEART WITH HOLLY BELL', 3, '12/1/2010 11:45', 1.45, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (532, '536409', '22153', 'ANGEL DECORATION STARS ON DRESS', 6, '12/1/2010 11:45', 0.42, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (533, '536409', '22197', 'SMALL POPCORN HOLDER', 2, '12/1/2010 11:45', 0.85, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (534, '536409', '85099B', 'JUMBO BAG RED RETROSPOT', 2, '12/1/2010 11:45', 1.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (535, '536409', '85099F', 'JUMBO BAG STRAWBERRY', 1, '12/1/2010 11:45', 1.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (536, '536409', '20717', 'STRAWBERRY SHOPPER BAG', 1, '12/1/2010 11:45', 1.25, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (537, '536409', '20723', 'STRAWBERRY CHARLOTTE BAG', 1, '12/1/2010 11:45', 0.85, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (538, '536409', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 1, '12/1/2010 11:45', 2.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (539, '536409', '21980', 'PACK OF 12 RED RETROSPOT TISSUES ', 12, '12/1/2010 11:45', 0.29, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (540, '536409', '22111', 'SCOTTIE DOG HOT WATER BOTTLE', 1, '12/1/2010 11:45', 4.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (541, '536409', '22112', 'CHOCOLATE HOT WATER BOTTLE', 1, '12/1/2010 11:45', 4.95, '17908', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (542, '536412', '20728', 'LUNCH BAG CARS BLUE', 3, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (543, '536412', '22382', 'LUNCH BAG SPACEBOY DESIGN ', 3, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (544, '536412', '22326', 'ROUND SNACK BOXES SET OF4 WOODLAND ', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (545, '536412', '22662', 'LUNCH BAG DOLLY GIRL DESIGN', 4, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (546, '536412', '22383', 'LUNCH BAG SUKI  DESIGN ', 3, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (547, '536412', '20727', 'LUNCH BAG  BLACK SKULL.', 3, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (548, '536412', '22328', 'ROUND SNACK BOXES SET OF 4 FRUITS ', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (549, '536412', '22327', 'ROUND SNACK BOXES SET OF 4 SKULLS', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (550, '536412', '22630', 'DOLLY GIRL LUNCH BOX', 1, '12/1/2010 11:49', 1.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (551, '536412', '22629', 'SPACEBOY LUNCH BOX ', 1, '12/1/2010 11:49', 1.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (552, '536412', '21245', 'GREEN POLKADOT PLATE ', 1, '12/1/2010 11:49', 1.69, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (553, '536412', '21244', 'BLUE POLKADOT PLATE ', 1, '12/1/2010 11:49', 1.69, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (554, '536412', '21242', 'RED RETROSPOT PLATE ', 1, '12/1/2010 11:49', 1.69, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (555, '536412', '21243', 'PINK  POLKADOT PLATE ', 1, '12/1/2010 11:49', 1.69, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (556, '536412', '22327', 'ROUND SNACK BOXES SET OF 4 SKULLS', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (557, '536412', '22273', 'FELTCRAFT DOLL MOLLY', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (558, '536412', '22940', 'FELTCRAFT CHRISTMAS FAIRY', 3, '12/1/2010 11:49', 4.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (559, '536412', '22652', 'TRAVEL SEWING KIT', 5, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (560, '536412', '22759', 'SET OF 3 NOTEBOOKS IN PARCEL', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (561, '536412', '21880', 'RED RETROSPOT TAPE', 10, '12/1/2010 11:49', 0.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (562, '536412', '21738', 'COSY SLIPPER SHOES SMALL  RED ', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (563, '536412', '22077', '6 RIBBONS RUSTIC CHARM', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (564, '536412', '85049E', 'SCANDINAVIAN REDS RIBBONS', 3, '12/1/2010 11:49', 1.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (565, '536412', '22961', 'JAM MAKING SET PRINTED', 24, '12/1/2010 11:49', 1.45, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (566, '536412', '21448', '12 DAISY PEGS IN WOOD BOX', 2, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (567, '536412', '22837', 'HOT WATER BOTTLE BABUSHKA ', 3, '12/1/2010 11:49', 4.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (568, '536412', '22749', 'FELTCRAFT PRINCESS CHARLOTTE DOLL', 2, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (569, '536412', '22940', 'FELTCRAFT CHRISTMAS FAIRY', 1, '12/1/2010 11:49', 4.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (570, '536412', '22749', 'FELTCRAFT PRINCESS CHARLOTTE DOLL', 1, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (571, '536412', '22077', '6 RIBBONS RUSTIC CHARM', 2, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (572, '536412', '21738', 'COSY SLIPPER SHOES SMALL  RED ', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (573, '536412', '85049E', 'SCANDINAVIAN REDS RIBBONS', 1, '12/1/2010 11:49', 1.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (574, '536412', '22243', '5 HOOK HANGER RED MAGIC TOADSTOOL', 6, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (575, '536412', '22141', 'CHRISTMAS CRAFT TREE TOP ANGEL', 1, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (576, '536412', '22144', 'CHRISTMAS CRAFT LITTLE FRIENDS', 2, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (577, '536412', '22243', '5 HOOK HANGER RED MAGIC TOADSTOOL', 3, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (578, '536412', '22077', '6 RIBBONS RUSTIC CHARM', 7, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (579, '536412', '21448', '12 DAISY PEGS IN WOOD BOX', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (580, '536412', '22759', 'SET OF 3 NOTEBOOKS IN PARCEL', 5, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (581, '536412', '22242', '5 HOOK HANGER MAGIC TOADSTOOL', 5, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (582, '536412', '85049E', 'SCANDINAVIAN REDS RIBBONS', 12, '12/1/2010 11:49', 1.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (583, '536412', '21731', 'RED TOADSTOOL LED NIGHT LIGHT', 5, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (584, '536412', '22243', '5 HOOK HANGER RED MAGIC TOADSTOOL', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (585, '536412', '21739', 'COSY SLIPPER SHOES SMALL GREEN', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (586, '536412', '21738', 'COSY SLIPPER SHOES SMALL  RED ', 5, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (587, '536412', '22271', 'FELTCRAFT DOLL ROSIE', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (588, '536412', '22273', 'FELTCRAFT DOLL MOLLY', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (589, '536412', '22274', 'FELTCRAFT DOLL EMILY', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (590, '536412', '22749', 'FELTCRAFT PRINCESS CHARLOTTE DOLL', 1, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (591, '536412', '22751', 'FELTCRAFT PRINCESS OLIVIA DOLL', 2, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (592, '536412', '21034', 'REX CASH+CARRY JUMBO SHOPPER', 1, '12/1/2010 11:49', 0.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (593, '536412', '22273', 'FELTCRAFT DOLL MOLLY', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (594, '536412', '22568', 'FELTCRAFT CUSHION OWL', 3, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (595, '536412', '22141', 'CHRISTMAS CRAFT TREE TOP ANGEL', 1, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (596, '536412', '22144', 'CHRISTMAS CRAFT LITTLE FRIENDS', 1, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (597, '536412', '22570', 'FELTCRAFT CUSHION RABBIT', 3, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (598, '536412', '22569', 'FELTCRAFT CUSHION BUTTERFLY', 2, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (599, '536412', '21448', '12 DAISY PEGS IN WOOD BOX', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (600, '536412', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (601, '536412', '22569', 'FELTCRAFT CUSHION BUTTERFLY', 2, '12/1/2010 11:49', 3.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (602, '536412', '21448', '12 DAISY PEGS IN WOOD BOX', 2, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (603, '536412', '22968', 'ROSE COTTAGE KEEPSAKE BOX ', 4, '12/1/2010 11:49', 9.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (604, '536412', '22902', 'TOTE BAG I LOVE LONDON', 7, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (605, '536412', '21448', '12 DAISY PEGS IN WOOD BOX', 2, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (606, '536412', '22902', 'TOTE BAG I LOVE LONDON', 7, '12/1/2010 11:49', 2.10, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (607, '536412', '21710', 'FOLDING UMBRELLA PINKWHITE POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (608, '536412', '21708', 'FOLDING UMBRELLA CREAM POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (609, '536412', '21711', 'FOLDING UMBRELLA WHITE/RED POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (610, '536412', '22179', 'SET 10 LIGHTS NIGHT OWL', 2, '12/1/2010 11:49', 6.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (611, '536412', '22197', 'SMALL POPCORN HOLDER', 5, '12/1/2010 11:49', 0.85, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (612, '536412', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (613, '536412', '21706', 'FOLDING UMBRELLA RED/WHITE POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (614, '536412', '22468', 'BABUSHKA LIGHTS STRING OF 10', 2, '12/1/2010 11:49', 6.75, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (615, '536412', '20725', 'LUNCH BAG RED RETROSPOT', 1, '12/1/2010 11:49', 1.65, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (616, '536412', '85184C', 'S/4 VALENTINE DECOUPAGE HEART BOX', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (617, '536412', '21708', 'FOLDING UMBRELLA CREAM POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (618, '536412', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 2, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (619, '536412', '21706', 'FOLDING UMBRELLA RED/WHITE POLKADOT', 1, '12/1/2010 11:49', 4.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (620, '536412', '22988', 'SOLDIERS EGG CUP ', 6, '12/1/2010 11:49', 1.25, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (621, '536412', '85184C', 'S/4 VALENTINE DECOUPAGE HEART BOX', 1, '12/1/2010 11:49', 2.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (622, '536412', '20750', 'RED RETROSPOT MINI CASES', 1, '12/1/2010 11:49', 7.95, '17920', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (623, '536414', '22139', NULL, 56, '12/1/2010 11:52', 0.00, '', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (624, '536415', '22952', '60 CAKE CASES VINTAGE CHRISTMAS', 10, '12/1/2010 11:57', 0.55, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (625, '536415', '22910', 'PAPER CHAIN KIT VINTAGE CHRISTMAS', 5, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (626, '536415', '22739', 'RIBBON REEL CHRISTMAS SOCK BAUBLE', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (627, '536415', '22738', 'RIBBON REEL SNOWY VILLAGE', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (628, '536415', '22736', 'RIBBON REEL MAKING SNOWMEN ', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (629, '536415', '22909', 'SET OF 20 VINTAGE CHRISTMAS NAPKINS', 5, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (630, '536415', '35591T', 'TURQUOISE CHRISTMAS TREE ', 2, '12/1/2010 11:57', 1.25, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (631, '536415', '22186', 'RED STAR CARD HOLDER', 5, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (632, '536415', '22695', 'WICKER WREATH SMALL', 3, '12/1/2010 11:57', 1.45, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (633, '536415', '22470', 'HEART OF WICKER LARGE', 1, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (634, '536415', '22580', 'ADVENT CALENDAR GINGHAM SACK', 1, '12/1/2010 11:57', 5.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (635, '536415', '22469', 'HEART OF WICKER SMALL', 5, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (636, '536415', '22147', 'FELTCRAFT BUTTERFLY HEARTS', 4, '12/1/2010 11:57', 1.45, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (637, '536415', '22130', 'PARTY CONE CHRISTMAS DECORATION ', 6, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (638, '536415', '21791', 'VINTAGE HEADS AND TAILS CARD GAME ', 3, '12/1/2010 11:57', 1.25, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (639, '536415', '22694', 'WICKER STAR ', 5, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (640, '536415', '21790', 'VINTAGE SNAP CARDS', 3, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (641, '536415', '22149', 'FELTCRAFT 6 FLOWER FRIENDS', 4, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (642, '536415', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 3, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (643, '536415', '22961', 'JAM MAKING SET PRINTED', 3, '12/1/2010 11:57', 1.45, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (644, '536415', '22321', 'BIRD DECORATION RED RETROSPOT', 12, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (645, '536415', '22594', 'CHRISTMAS GINGHAM TREE', 5, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (646, '536415', '22593', 'CHRISTMAS GINGHAM STAR', 4, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (647, '536415', '22595', 'CHRISTMAS GINGHAM HEART', 6, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (648, '536415', '21986', 'PACK OF 12 PINK POLKADOT TISSUES', 12, '12/1/2010 11:57', 0.29, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (649, '536415', '22750', 'FELTCRAFT PRINCESS LOLA DOLL', 2, '12/1/2010 11:57', 3.75, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (650, '536415', '22616', 'PACK OF 12 LONDON TISSUES ', 12, '12/1/2010 11:57', 0.29, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (651, '536415', '22775', 'PURPLE DRAWERKNOB ACRYLIC EDWARDIAN', 1, '12/1/2010 11:57', 1.25, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (652, '536415', '22899', 'CHILDREN\'S APRON DOLLY GIRL ', 2, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (653, '536415', '22367', 'CHILDRENS APRON SPACEBOY DESIGN', 3, '12/1/2010 11:57', 1.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (654, '536415', '22942', 'CHRISTMAS LIGHTS 10 SANTAS ', 3, '12/1/2010 11:57', 8.50, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (655, '536415', '22941', 'CHRISTMAS LIGHTS 10 REINDEER', 3, '12/1/2010 11:57', 8.50, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (656, '536415', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 6, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (657, '536415', '22940', 'FELTCRAFT CHRISTMAS FAIRY', 2, '12/1/2010 11:57', 4.25, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (658, '536415', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 2, '12/1/2010 11:57', 0.55, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (659, '536415', '21976', 'PACK OF 60 MUSHROOM CAKE CASES', 2, '12/1/2010 11:57', 0.55, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (660, '536415', '22951', '60 CAKE CASES DOLLY GIRL DESIGN', 2, '12/1/2010 11:57', 0.55, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (661, '536415', '21977', 'PACK OF 60 PINK PAISLEY CAKE CASES', 3, '12/1/2010 11:57', 0.55, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (662, '536415', '22834', 'HAND WARMER BABUSHKA DESIGN', 3, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (663, '536415', '22867', 'HAND WARMER BIRD DESIGN', 3, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (664, '536415', '22865', 'HAND WARMER OWL DESIGN', 3, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (665, '536415', '22632', 'HAND WARMER RED RETROSPOT', 3, '12/1/2010 11:57', 2.10, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (666, '536415', '21916', 'SET 12 RETRO WHITE CHALK STICKS', 2, '12/1/2010 11:57', 0.42, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (667, '536415', '22587', 'FELTCRAFT HAIRBAND RED AND BLUE', 4, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (668, '536415', '22566', 'FELTCRAFT HAIRBAND PINK AND PURPLE', 3, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (669, '536415', '22565', 'FELTCRAFT HAIRBANDS PINK AND WHITE ', 3, '12/1/2010 11:57', 0.85, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (670, '536415', '22472', 'TV DINNER TRAY DOLLY GIRL', 2, '12/1/2010 11:57', 4.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (671, '536415', '22557', 'PLASTERS IN TIN VINTAGE PAISLEY ', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (672, '536415', '22551', 'PLASTERS IN TIN SPACEBOY', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (673, '536415', '22554', 'PLASTERS IN TIN WOODLAND ANIMALS', 3, '12/1/2010 11:57', 1.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (674, '536415', '22534', 'MAGIC DRAWING SLATE SPACEBOY ', 3, '12/1/2010 11:57', 0.42, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (675, '536415', '22531', 'MAGIC DRAWING SLATE CIRCUS PARADE  ', 3, '12/1/2010 11:57', 0.42, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (676, '536415', '22529', 'MAGIC DRAWING SLATE GO TO THE FAIR ', 3, '12/1/2010 11:57', 0.42, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (677, '536415', '22530', 'MAGIC DRAWING SLATE DOLLY GIRL ', 3, '12/1/2010 11:57', 0.42, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (678, '536415', '84032B', 'CHARLIE + LOLA RED HOT WATER BOTTLE', 3, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (679, '536415', '22837', 'HOT WATER BOTTLE BABUSHKA ', 3, '12/1/2010 11:57', 4.65, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (680, '536415', '85049H', 'URBAN BLACK RIBBONS ', 2, '12/1/2010 11:57', 1.25, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (681, '536415', '22749', 'FELTCRAFT PRINCESS CHARLOTTE DOLL', 2, '12/1/2010 11:57', 3.75, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (682, '536415', '22807', 'SET OF 6 T-LIGHTS TOADSTOOLS', 12, '12/1/2010 11:57', 2.95, '12838', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (683, '536416', '21494', 'ROTATING LEAVES T-LIGHT HOLDER', 12, '12/1/2010 11:58', 1.25, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (684, '536416', '21915', 'RED  HARMONICA IN BOX ', 72, '12/1/2010 11:58', 1.25, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (685, '536416', '22938', 'CUPCAKE LACE PAPER SET 6', 12, '12/1/2010 11:58', 1.95, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (686, '536416', '22768', 'FAMILY PHOTO FRAME CORNICE', 4, '12/1/2010 11:58', 9.95, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (687, '536416', '22767', 'TRIPLE PHOTO FRAME CORNICE ', 4, '12/1/2010 11:58', 9.95, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (688, '536416', '82494L', 'WOODEN FRAME ANTIQUE WHITE ', 6, '12/1/2010 11:58', 2.95, '13255', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (689, '536420', '21889', 'WOODEN BOX OF DOMINOES', 12, '12/1/2010 12:03', 1.25, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (690, '536420', '21892', 'TRADITIONAL WOODEN CATCH CUP GAME ', 12, '12/1/2010 12:03', 1.25, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (691, '536420', '21891', 'TRADITIONAL WOODEN SKIPPING ROPE', 12, '12/1/2010 12:03', 1.25, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (692, '536420', '21890', 'S/6 WOODEN SKITTLES IN COTTON BAG', 6, '12/1/2010 12:03', 2.95, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (693, '536420', '21718', 'RED METAL BEACH SPADE ', 12, '12/1/2010 12:03', 1.25, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (694, '536420', '21716', 'BOYS VINTAGE TIN SEASIDE BUCKET', 8, '12/1/2010 12:03', 2.55, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (695, '536420', '21715', 'GIRLS VINTAGE TIN SEASIDE BUCKET', 8, '12/1/2010 12:03', 2.55, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (696, '536420', '22113', 'GREY HEART HOT WATER BOTTLE', 4, '12/1/2010 12:03', 3.75, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (697, '536420', '22111', 'SCOTTIE DOG HOT WATER BOTTLE', 3, '12/1/2010 12:03', 4.95, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (698, '536420', '22110', 'BIRD HOUSE HOT WATER BOTTLE', 6, '12/1/2010 12:03', 2.55, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (699, '536420', '22358', 'KINGS CHOICE TEA CADDY ', 6, '12/1/2010 12:03', 2.95, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (700, '536420', '22357', 'KINGS CHOICE BISCUIT TIN', 4, '12/1/2010 12:03', 4.25, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (701, '536420', '22115', 'METAL SIGN EMPIRE TEA', 6, '12/1/2010 12:03', 2.95, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (702, '536420', '22969', 'HOMEMADE JAM SCENTED CANDLES', 12, '12/1/2010 12:03', 1.45, '16583', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (703, '536423', '22619', 'SET OF 6 SOLDIER SKITTLES', 4, '12/1/2010 12:08', 3.75, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (704, '536423', '21481', 'FAWN BLUE HOT WATER BOTTLE', 6, '12/1/2010 12:08', 2.95, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (705, '536423', '22632', 'HAND WARMER RED RETROSPOT', 12, '12/1/2010 12:08', 2.10, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (706, '536423', '22837', 'HOT WATER BOTTLE BABUSHKA ', 8, '12/1/2010 12:08', 4.65, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (707, '536423', '21479', 'WHITE SKULL HOT WATER BOTTLE ', 8, '12/1/2010 12:08', 3.75, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (708, '536423', '21485', 'RETROSPOT HEART HOT WATER BOTTLE', 8, '12/1/2010 12:08', 4.95, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (709, '536423', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 8, '12/1/2010 12:08', 3.75, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (710, '536423', '22111', 'SCOTTIE DOG HOT WATER BOTTLE', 16, '12/1/2010 12:08', 4.95, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (711, '536423', '22113', 'GREY HEART HOT WATER BOTTLE', 8, '12/1/2010 12:08', 3.75, '18085', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (712, '536425', '22837', 'HOT WATER BOTTLE BABUSHKA ', 8, '12/1/2010 12:08', 4.65, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (713, '536425', '22585', 'PACK OF 6 BIRDY GIFT TAGS', 12, '12/1/2010 12:08', 1.25, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (714, '536425', '79321', 'CHILLI LIGHTS', 8, '12/1/2010 12:08', 4.95, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (715, '536425', '22637', 'PIGGY BANK RETROSPOT ', 12, '12/1/2010 12:08', 2.55, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (716, '536425', '21556', 'CERAMIC STRAWBERRY MONEY BOX', 6, '12/1/2010 12:08', 2.55, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (717, '536425', '22646', 'CERAMIC STRAWBERRY CAKE MONEY BANK', 12, '12/1/2010 12:08', 1.45, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (718, '536425', '22644', 'CERAMIC CHERRY CAKE MONEY BANK', 12, '12/1/2010 12:08', 1.45, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (719, '536425', '22645', 'CERAMIC HEART FAIRY CAKE MONEY BANK', 12, '12/1/2010 12:08', 1.45, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (720, '536425', '22650', 'CERAMIC PIRATE CHEST MONEY BANK', 12, '12/1/2010 12:08', 1.45, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (721, '536425', '22508', 'DOORSTOP RETROSPOT HEART', 8, '12/1/2010 12:08', 3.75, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (722, '536425', '21411', 'GINGHAM HEART  DOORSTOP RED', 3, '12/1/2010 12:08', 4.25, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (723, '536425', '22511', 'RETROSPOT BABUSHKA DOORSTOP', 4, '12/1/2010 12:08', 3.75, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (724, '536425', '22451', 'SILK PURSE BABUSHKA RED', 6, '12/1/2010 12:08', 3.35, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (725, '536425', '22449', 'SILK PURSE BABUSHKA PINK', 6, '12/1/2010 12:08', 3.35, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (726, '536425', '22768', 'FAMILY PHOTO FRAME CORNICE', 2, '12/1/2010 12:08', 9.95, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (727, '536425', '22829', 'SWEETHEART WIRE WALL TIDY', 2, '12/1/2010 12:08', 9.95, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (728, '536425', '22961', 'JAM MAKING SET PRINTED', 12, '12/1/2010 12:08', 1.45, '13758', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (729, '536437', '21154', 'RED RETROSPOT OVEN GLOVE ', 200, '12/1/2010 12:12', 1.06, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (730, '536437', '22189', 'CREAM HEART CARD HOLDER', 72, '12/1/2010 12:12', 3.39, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (731, '536437', '17021', 'NAMASTE SWAGAT INCENSE', 600, '12/1/2010 12:12', 0.24, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (732, '536437', '22059', 'CERAMIC STRAWBERRY DESIGN MUG', 48, '12/1/2010 12:12', 1.25, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (733, '536437', '22188', 'BLACK HEART CARD HOLDER', 36, '12/1/2010 12:12', 3.39, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (734, '536437', '84678', 'CLASSICAL ROSE SMALL VASE', 48, '12/1/2010 12:12', 1.25, '13694', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (735, '536446', '85172', 'HYACINTH BULB T-LIGHT CANDLES', 32, '12/1/2010 12:15', 0.42, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (736, '536446', '22142', 'CHRISTMAS CRAFT WHITE FAIRY ', 2, '12/1/2010 12:15', 1.45, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (737, '536446', '22144', 'CHRISTMAS CRAFT LITTLE FRIENDS', 2, '12/1/2010 12:15', 2.10, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (738, '536446', '21591', 'COSY HOUR CIGAR BOX MATCHES ', 6, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (739, '536446', '22480', 'RED TEA TOWEL CLASSIC DESIGN', 12, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (740, '536446', '22294', 'HEART FILIGREE DOVE  SMALL', 48, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (741, '536446', '21156', 'RETROSPOT CHILDRENS APRON', 1, '12/1/2010 12:15', 1.95, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (742, '536446', '10133', 'COLOURING PENCILS BROWN TUBE', 5, '12/1/2010 12:15', 0.85, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (743, '536446', '72800E', '4 IVORY DINNER CANDLES SILVER FLOCK', 6, '12/1/2010 12:15', 2.55, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (744, '536446', '22294', 'HEART FILIGREE DOVE  SMALL', 24, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (745, '536446', '84836', 'ZINC METAL HEART DECORATION', 12, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (746, '536446', '20774', 'GREEN FERN NOTEBOOK', 2, '12/1/2010 12:15', 1.65, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (747, '536446', '20773', 'BLUE PAISLEY NOTEBOOK', 2, '12/1/2010 12:15', 1.65, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (748, '536446', '20777', 'CHRYSANTHEMUM NOTEBOOK', 2, '12/1/2010 12:15', 1.65, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (749, '536446', '16016', 'LARGE CHINESE STYLE SCISSOR', 10, '12/1/2010 12:15', 0.85, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (750, '536446', '16014', 'SMALL CHINESE STYLE SCISSOR', 10, '12/1/2010 12:15', 0.42, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (751, '536446', '21890', 'S/6 WOODEN SKITTLES IN COTTON BAG', 2, '12/1/2010 12:15', 2.95, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (752, '536446', '21891', 'TRADITIONAL WOODEN SKIPPING ROPE', 2, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (753, '536446', '22619', 'SET OF 6 SOLDIER SKITTLES', 8, '12/1/2010 12:15', 3.75, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (754, '536446', '22620', '4 TRADITIONAL SPINNING TOPS', 6, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (755, '536446', '84347', 'ROTATING SILVER ANGELS T-LIGHT HLDR', 12, '12/1/2010 12:15', 2.55, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (756, '536446', '85169B', 'BLACK LOVE BIRD CANDLE', 24, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (757, '536446', '21156', 'RETROSPOT CHILDRENS APRON', 3, '12/1/2010 12:15', 1.95, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (758, '536446', '21651', 'HANGING GLASS ETCHED TEALIGHT', 6, '12/1/2010 12:15', 1.65, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (759, '536446', '21651', 'HANGING GLASS ETCHED TEALIGHT', 6, '12/1/2010 12:15', 1.65, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (760, '536446', '84625C', 'BLUE NEW BAROQUE CANDLESTICK CANDLE', 10, '12/1/2010 12:15', 2.95, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (761, '536446', '22618', 'COOKING SET RETROSPOT', 2, '12/1/2010 12:15', 9.95, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (762, '536446', '21586', 'KINGS CHOICE GIANT TUBE MATCHES', 4, '12/1/2010 12:15', 2.55, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (763, '536446', '21587', 'COSY HOUR GIANT TUBE MATCHES', 4, '12/1/2010 12:15', 2.55, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (764, '536446', '22152', 'PLACE SETTING WHITE STAR', 24, '12/1/2010 12:15', 0.42, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (765, '536446', '85172', 'HYACINTH BULB T-LIGHT CANDLES', 16, '12/1/2010 12:15', 0.42, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (766, '536446', '84754', 'S/15 SILVER GLASS BAUBLES IN BAG', 24, '12/1/2010 12:15', 1.25, '15983', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (767, '536460', '22670', 'FRENCH WC SIGN BLUE METAL', 12, '12/1/2010 12:22', 1.25, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (768, '536460', '21586', 'KINGS CHOICE GIANT TUBE MATCHES', 12, '12/1/2010 12:22', 2.55, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (769, '536460', '84992', '72 SWEETHEART FAIRY CAKE CASES', 24, '12/1/2010 12:22', 0.55, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (770, '536460', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 24, '12/1/2010 12:22', 1.69, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (771, '536460', '84849B', 'FAIRY SOAP SOAP HOLDER', 12, '12/1/2010 12:22', 1.69, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (772, '536460', '22927', 'GREEN GIANT GARDEN THERMOMETER', 2, '12/1/2010 12:22', 5.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (773, '536460', '22926', 'IVORY GIANT GARDEN THERMOMETER', 4, '12/1/2010 12:22', 5.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (774, '536460', '22925', 'BLUE GIANT GARDEN THERMOMETER', 2, '12/1/2010 12:22', 5.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (775, '536460', '21977', 'PACK OF 60 PINK PAISLEY CAKE CASES', 24, '12/1/2010 12:22', 0.55, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (776, '536460', '21485', 'RETROSPOT HEART HOT WATER BOTTLE', 6, '12/1/2010 12:22', 4.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (777, '536460', '21484', 'CHICK GREY HOT WATER BOTTLE', 8, '12/1/2010 12:22', 3.45, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (778, '536460', '21259', 'VICTORIAN SEWING BOX SMALL ', 2, '12/1/2010 12:22', 5.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (779, '536460', '21257', 'VICTORIAN SEWING BOX MEDIUM', 2, '12/1/2010 12:22', 7.95, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (780, '536460', '21121', 'SET/10 RED POLKADOT PARTY CANDLES', 24, '12/1/2010 12:22', 1.25, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (781, '536463', '82552', 'WASHROOM METAL SIGN', 12, '12/1/2010 12:22', 1.45, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (782, '536464', '90200B', 'BLACK SWEETHEART BRACELET', 2, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (783, '536464', '90059B', 'DIAMANTE HAIR GRIP PACK/2 BLACK DIA', 2, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (784, '536464', '90185C', 'BLACK DIAMANTE EXPANDABLE RING', 2, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (785, '536464', '90059E', 'DIAMANTE HAIR GRIP PACK/2 RUBY', 3, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (786, '536464', '90059C', 'DIAMANTE HAIR GRIP PACK/2 MONTANA', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (787, '536464', '90200C', 'BLUE SWEETHEART BRACELET', 1, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (788, '536464', '90200D', 'PINK SWEETHEART BRACELET', 3, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (789, '536464', '90200A', 'PURPLE SWEETHEART BRACELET', 1, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (790, '536464', '22386', 'JUMBO BAG PINK POLKADOT', 1, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (791, '536464', '85099B', 'JUMBO BAG RED RETROSPOT', 1, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (792, '536464', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 8, '12/1/2010 12:23', 1.69, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (793, '536464', '22086', 'PAPER CHAIN KIT 50\'S CHRISTMAS ', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (794, '536464', '22737', 'RIBBON REEL CHRISTMAS PRESENT ', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (795, '536464', '21260', 'FIRST AID TIN', 1, '12/1/2010 12:23', 3.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (796, '536464', '22744', 'MAKE YOUR OWN MONSOON CARD KIT', 2, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (797, '536464', '21985', 'PACK OF 12 HEARTS DESIGN TISSUES ', 1, '12/1/2010 12:23', 0.29, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (798, '536464', '21980', 'PACK OF 12 RED RETROSPOT TISSUES ', 1, '12/1/2010 12:23', 0.29, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (799, '536464', '22988', 'SOLDIERS EGG CUP ', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (800, '536464', '22297', 'HEART IVORY TRELLIS SMALL', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (801, '536464', '22294', 'HEART FILIGREE DOVE  SMALL', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (802, '536464', '22295', 'HEART FILIGREE DOVE LARGE', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (803, '536464', '22813', 'PACK 3 BOXES BIRD PANNETONE ', 2, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (804, '536464', '22812', 'PACK 3 BOXES CHRISTMAS PANNETONE', 6, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (805, '536464', '22197', 'SMALL POPCORN HOLDER', 5, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (806, '536464', '21977', 'PACK OF 60 PINK PAISLEY CAKE CASES', 1, '12/1/2010 12:23', 0.55, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (807, '536464', '22619', 'SET OF 6 SOLDIER SKITTLES', 1, '12/1/2010 12:23', 3.75, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (808, '536464', '16258A', 'SWIRLY CIRCULAR RUBBERS IN BAG', 1, '12/1/2010 12:23', 0.42, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (809, '536464', '21992', 'VINTAGE PAISLEY STATIONERY SET', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (810, '536464', '22910', 'PAPER CHAIN KIT VINTAGE CHRISTMAS', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (811, '536464', '21124', 'SET/10 BLUE POLKADOT PARTY CANDLES', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (812, '536464', '22735', 'RIBBON REEL SOCKS AND MITTENS', 2, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (813, '536464', '22952', '60 CAKE CASES VINTAGE CHRISTMAS', 2, '12/1/2010 12:23', 0.55, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (814, '536464', '22945', 'CHRISTMAS METAL TAGS ASSORTED ', 6, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (815, '536464', '21816', 'CHRISTMAS TREE T-LIGHT HOLDER', 2, '12/1/2010 12:23', 1.45, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (816, '536464', '21815', 'STAR  T-LIGHT HOLDER ', 4, '12/1/2010 12:23', 1.45, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (817, '536464', '21814', 'HEART T-LIGHT HOLDER ', 2, '12/1/2010 12:23', 1.45, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (818, '536464', '10125', 'MINI FUNKY DESIGN TAPES', 2, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (819, '536464', '22810', 'SET OF 6 T-LIGHTS SNOWMEN', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (820, '536464', '22573', 'STAR WOODEN CHRISTMAS DECORATION', 1, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (821, '536464', '22577', 'WOODEN HEART CHRISTMAS SCANDINAVIAN', 1, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (822, '536464', '22603', 'CHRISTMAS RETROSPOT TREE WOOD', 2, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (823, '536464', '22809', 'SET OF 6 T-LIGHTS SANTA', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (824, '536464', '20878', 'SET/9 CHRISTMAS T-LIGHTS SCENTED ', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (825, '536464', '20866', 'BLUE ROSE FABRIC MIRROR', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (826, '536464', '85095', 'THREE CANVAS LUGGAGE TAGS', 1, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (827, '536464', '22333', 'RETROSPOT PARTY BAG + STICKER SET', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (828, '536464', '22557', 'PLASTERS IN TIN VINTAGE PAISLEY ', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (829, '536464', '21584', 'RETROSPOT SMALL TUBE MATCHES', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (830, '536464', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 1, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (831, '536464', '22731', '3D CHRISTMAS STAMPS STICKERS ', 2, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (832, '536464', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 1, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (833, '536464', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 3, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (834, '536464', '22558', 'CLOTHES PEGS RETROSPOT PACK 24 ', 2, '12/1/2010 12:23', 1.49, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (835, '536464', '22956', '36 FOIL HEART CAKE CASES', 1, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (836, '536464', '22945', 'CHRISTMAS METAL TAGS ASSORTED ', 6, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (837, '536464', '22582', 'PACK OF 6 SWEETIE GIFT BOXES', 1, '12/1/2010 12:23', 2.55, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (838, '536464', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 1, '12/1/2010 12:23', 0.55, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (839, '536464', '21212', 'PACK OF 72 RETROSPOT CAKE CASES', 2, '12/1/2010 12:23', 0.55, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (840, '536464', '22585', 'PACK OF 6 BIRDY GIFT TAGS', 3, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (841, '536464', '21121', 'SET/10 RED POLKADOT PARTY CANDLES', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (842, '536464', '21122', 'SET/10 PINK POLKADOT PARTY CANDLES', 1, '12/1/2010 12:23', 1.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (843, '536464', '22759', 'SET OF 3 NOTEBOOKS IN PARCEL', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (844, '536464', '21815', 'STAR  T-LIGHT HOLDER ', 1, '12/1/2010 12:23', 1.45, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (845, '536464', '85231B', 'CINAMMON SET OF 9 T-LIGHTS', 3, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (846, '536464', '85231G', 'ORANGE SCENTED SET/9 T-LIGHTS', 5, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (847, '536464', '22082', 'RIBBON REEL STRIPES DESIGN ', 5, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (848, '536464', '22500', 'SET OF 2 TINS JARDIN DE PROVENCE', 2, '12/1/2010 12:23', 4.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (849, '536464', '22742', 'MAKE YOUR OWN PLAYTIME CARD KIT', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (850, '536464', '21329', 'DINOSAURS  WRITING SET ', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (851, '536464', '21328', 'BALLOONS  WRITING SET ', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (852, '536464', '21327', 'SKULLS WRITING SET ', 1, '12/1/2010 12:23', 1.65, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (853, '536464', '21992', 'VINTAGE PAISLEY STATIONERY SET', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (854, '536464', '21738', 'COSY SLIPPER SHOES SMALL  RED ', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (855, '536464', '48173C', 'DOORMAT BLACK FLOCK ', 1, '12/1/2010 12:23', 7.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (856, '536464', '85099C', 'JUMBO  BAG BAROQUE BLACK WHITE', 1, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (857, '536464', '22960', 'JAM MAKING SET WITH JARS', 1, '12/1/2010 12:23', 4.25, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (858, '536464', '85231G', 'ORANGE SCENTED SET/9 T-LIGHTS', 1, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (859, '536464', '85231B', 'CINAMMON SET OF 9 T-LIGHTS', 2, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (860, '536464', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 1, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (861, '536464', '72818', 'CHRISTMAS DECOUPAGE CANDLE', 1, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (862, '536464', '21814', 'HEART T-LIGHT HOLDER ', 8, '12/1/2010 12:23', 1.45, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (863, '536464', '22441', 'GROW YOUR OWN BASIL IN ENAMEL MUG', 1, '12/1/2010 12:23', 2.10, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (864, '536464', '22312', 'OFFICE MUG WARMER POLKADOT', 1, '12/1/2010 12:23', 2.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (865, '536464', '22197', 'SMALL POPCORN HOLDER', 6, '12/1/2010 12:23', 0.85, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (866, '536464', '22663', 'JUMBO BAG DOLLY GIRL DESIGN', 1, '12/1/2010 12:23', 1.95, '17968', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (867, '536466', '22960', 'JAM MAKING SET WITH JARS', 6, '12/1/2010 12:23', 4.25, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (868, '536466', '22961', 'JAM MAKING SET PRINTED', 12, '12/1/2010 12:23', 1.45, '14849', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (869, '536477', '21314', 'SMALL GLASS HEART TRINKET POT', 48, '12/1/2010 12:27', 1.85, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (870, '536477', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 24, '12/1/2010 12:27', 3.39, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (871, '536477', '21137', 'BLACK RECORD COVER FRAME', 480, '12/1/2010 12:27', 3.39, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (872, '536477', '22041', 'RECORD FRAME 7\" SINGLE SIZE ', 48, '12/1/2010 12:27', 2.10, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (873, '536477', '20979', '36 PENCILS TUBE RED RETROSPOT', 16, '12/1/2010 12:27', 1.25, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (874, '536477', '20977', '36 PENCILS TUBE WOODLAND', 16, '12/1/2010 12:27', 1.25, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (875, '536477', '22619', 'SET OF 6 SOLDIER SKITTLES', 4, '12/1/2010 12:27', 3.75, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (876, '536477', '22571', 'ROCKING HORSE RED CHRISTMAS ', 96, '12/1/2010 12:27', 0.72, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (877, '536477', '22595', 'CHRISTMAS GINGHAM HEART', 144, '12/1/2010 12:27', 0.72, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (878, '536477', '22593', 'CHRISTMAS GINGHAM STAR', 144, '12/1/2010 12:27', 0.72, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (879, '536477', '22633', 'HAND WARMER UNION JACK', 12, '12/1/2010 12:27', 2.10, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (880, '536477', '22632', 'HAND WARMER RED RETROSPOT', 12, '12/1/2010 12:27', 2.10, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (881, '536477', '22423', 'REGENCY CAKESTAND 3 TIER', 16, '12/1/2010 12:27', 10.95, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (882, '536477', '22411', 'JUMBO SHOPPER VINTAGE RED PAISLEY', 10, '12/1/2010 12:27', 1.95, '16210', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (883, '536488', '22738', 'RIBBON REEL SNOWY VILLAGE', 5, '12/1/2010 12:31', 1.65, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (884, '536488', '21621', 'VINTAGE UNION JACK BUNTING', 1, '12/1/2010 12:31', 8.50, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (885, '536488', '22960', 'JAM MAKING SET WITH JARS', 8, '12/1/2010 12:31', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (886, '536488', '22082', 'RIBBON REEL STRIPES DESIGN ', 5, '12/1/2010 12:31', 1.65, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (887, '536488', '47563A', 'RETRO LONGBOARD IRONING BOARD COVER', 1, '12/1/2010 12:31', 3.75, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (888, '536488', '84558A', '3D DOG PICTURE PLAYING CARDS', 1, '12/1/2010 12:31', 2.95, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (889, '536488', '21592', 'RETROSPOT CIGAR BOX MATCHES ', 1, '12/1/2010 12:31', 1.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (890, '536488', '20878', 'SET/9 CHRISTMAS T-LIGHTS SCENTED ', 2, '12/1/2010 12:31', 1.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (891, '536488', '84347', 'ROTATING SILVER ANGELS T-LIGHT HLDR', 1, '12/1/2010 12:31', 2.55, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (892, '536488', '84347', 'ROTATING SILVER ANGELS T-LIGHT HLDR', 1, '12/1/2010 12:31', 2.55, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (893, '536488', '21577', 'SAVE THE PLANET COTTON TOTE BAG', 1, '12/1/2010 12:31', 2.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (894, '536488', '22909', 'SET OF 20 VINTAGE CHRISTMAS NAPKINS', 1, '12/1/2010 12:31', 0.85, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (895, '536488', '22087', 'PAPER BUNTING WHITE LACE', 1, '12/1/2010 12:31', 2.95, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (896, '536488', '22651', 'GENTLEMAN SHIRT REPAIR KIT ', 2, '12/1/2010 12:31', 0.85, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (897, '536488', '22713', 'CARD I LOVE LONDON ', 12, '12/1/2010 12:31', 0.42, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (898, '536488', '22910', 'PAPER CHAIN KIT VINTAGE CHRISTMAS', 1, '12/1/2010 12:31', 2.95, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (899, '536488', '21370', 'MIRRORED WALL ART FOXY', 2, '12/1/2010 12:31', 6.35, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (900, '536488', '21367', 'MIRRORED WALL ART GENTS', 1, '12/1/2010 12:31', 2.55, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (901, '536488', '22376', 'AIRLINE BAG VINTAGE JET SET WHITE', 1, '12/1/2010 12:31', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (902, '536488', '22961', 'JAM MAKING SET PRINTED', 1, '12/1/2010 12:31', 1.45, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (903, '536488', '21895', 'POTTING SHED SOW \'N\' GROW SET', 1, '12/1/2010 12:31', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (904, '536488', '22468', 'BABUSHKA LIGHTS STRING OF 10', 1, '12/1/2010 12:31', 6.75, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (905, '536488', '21034', 'REX CASH+CARRY JUMBO SHOPPER', 1, '12/1/2010 12:31', 0.95, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (906, '536488', '22372', 'AIRLINE BAG VINTAGE WORLD CHAMPION ', 1, '12/1/2010 12:31', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (907, '536488', '22867', 'HAND WARMER BIRD DESIGN', 1, '12/1/2010 12:31', 2.10, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (908, '536488', '22144', 'CHRISTMAS CRAFT LITTLE FRIENDS', 1, '12/1/2010 12:31', 2.10, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (909, '536488', '21190', 'PINK HEARTS PAPER GARLAND', 1, '12/1/2010 12:31', 1.65, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (910, '536488', '21894', 'POTTING SHED SEED ENVELOPES', 3, '12/1/2010 12:31', 1.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (911, '536488', '70007', 'HI TEC ALPINE HAND WARMER', 3, '12/1/2010 12:31', 1.65, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (912, '536488', '22940', 'FELTCRAFT CHRISTMAS FAIRY', 1, '12/1/2010 12:31', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (913, '536488', '70007', 'HI TEC ALPINE HAND WARMER', 1, '12/1/2010 12:31', 1.65, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (914, '536488', '84347', 'ROTATING SILVER ANGELS T-LIGHT HLDR', 3, '12/1/2010 12:31', 2.55, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (915, '536488', '22150', '3 STRIPEY MICE FELTCRAFT', 1, '12/1/2010 12:31', 1.95, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (916, '536488', '22149', 'FELTCRAFT 6 FLOWER FRIENDS', 2, '12/1/2010 12:31', 2.10, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (917, '536488', '22144', 'CHRISTMAS CRAFT LITTLE FRIENDS', 2, '12/1/2010 12:31', 2.10, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (918, '536500', '21622', 'VINTAGE UNION JACK CUSHION COVER', 10, '12/1/2010 12:35', 4.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (919, '536500', '46000M', 'POLYESTER FILLER PAD 45x45cm', 10, '12/1/2010 12:35', 1.55, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (920, '536500', '22630', 'DOLLY GIRL LUNCH BOX', 2, '12/1/2010 12:35', 1.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (921, '536500', '22616', 'PACK OF 12 LONDON TISSUES ', 12, '12/1/2010 12:35', 0.29, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (922, '536500', '22712', 'CARD DOLLY GIRL ', 12, '12/1/2010 12:35', 0.42, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (923, '536500', '22983', 'CARD BILLBOARD FONT', 12, '12/1/2010 12:35', 0.42, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (924, '536500', '22024', 'RAINY LADIES BIRTHDAY CARD', 12, '12/1/2010 12:35', 0.42, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (925, '536500', '22113', 'GREY HEART HOT WATER BOTTLE', 3, '12/1/2010 12:35', 3.75, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (926, '536500', '84029E', 'RED WOOLLY HOTTIE WHITE HEART.', 2, '12/1/2010 12:35', 3.75, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (927, '536500', '21488', 'RED WHITE SCARF  HOT WATER BOTTLE', 2, '12/1/2010 12:35', 3.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (928, '536500', '22900', 'SET 2 TEA TOWELS I LOVE LONDON ', 7, '12/1/2010 12:35', 2.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (929, '536500', '22895', 'SET OF 2 TEA TOWELS APPLE AND PEARS', 3, '12/1/2010 12:35', 2.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (930, '536500', '21035', 'SET/2 RED RETROSPOT TEA TOWELS ', 3, '12/1/2010 12:35', 2.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (931, '536500', '21755', 'LOVE BUILDING BLOCK WORD', 6, '12/1/2010 12:35', 5.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (932, '536500', '21754', 'HOME BUILDING BLOCK WORD', 6, '12/1/2010 12:35', 5.95, '17377', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (933, '536502', '84879', 'ASSORTED COLOUR BIRD ORNAMENT', 16, '12/1/2010 12:36', 1.69, '16552', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (934, '536502', '22784', 'LANTERN CREAM GAZEBO ', 3, '12/1/2010 12:36', 4.95, '16552', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (935, '536502', '21441', 'BLUE BIRDHOUSE DECORATION', 12, '12/1/2010 12:36', 0.85, '16552', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (936, '536502', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 6, '12/1/2010 12:36', 2.95, '16552', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (937, '536502', '22423', 'REGENCY CAKESTAND 3 TIER', 2, '12/1/2010 12:36', 12.75, '16552', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (938, '536508', '84947', 'ANTIQUE SILVER TEA GLASS ENGRAVED', 72, '12/1/2010 12:38', 1.06, '17181', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (939, '536508', '21326', 'AGED GLASS SILVER T-LIGHT HOLDER', 144, '12/1/2010 12:38', 0.55, '17181', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (940, 'C536506', '22960', 'JAM MAKING SET WITH JARS', -6, '12/1/2010 12:38', 4.25, '17897', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (941, '536514', '22865', 'HAND WARMER OWL DESIGN', 36, '12/1/2010 12:40', 2.10, '17951', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (942, '536514', '22485', 'SET OF 2 WOODEN MARKET CRATES', 4, '12/1/2010 12:40', 12.75, '17951', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (943, '536514', '22807', 'SET OF 6 T-LIGHTS TOADSTOOLS', 6, '12/1/2010 12:40', 2.95, '17951', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (944, '536514', '22633', 'HAND WARMER UNION JACK', 36, '12/1/2010 12:40', 2.10, '17951', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (945, '536514', '22866', 'HAND WARMER SCOTTY DOG DESIGN', 36, '12/1/2010 12:40', 2.10, '17951', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (946, '536520', '21794', 'CLASSIC FRENCH STYLE BASKET NATURAL', 1, '12/1/2010 12:43', 6.75, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (947, '536520', '20707', 'CRAZY DAISY HEART DECORATION', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (948, '536520', '21175', 'GIN + TONIC DIET METAL SIGN', 1, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (949, '536520', '22926', 'IVORY GIANT GARDEN THERMOMETER', 1, '12/1/2010 12:43', 5.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (950, '536520', '22588', 'CARD HOLDER GINGHAM HEART', 2, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (951, '536520', '21292', 'SMALL STRIPES CHOCOLATE GIFT BAG ', 16, '12/1/2010 12:43', 0.85, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (952, '536520', '21890', 'S/6 WOODEN SKITTLES IN COTTON BAG', 1, '12/1/2010 12:43', 2.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (953, '536520', '22632', 'HAND WARMER RED RETROSPOT', 4, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (954, '536520', '22633', 'HAND WARMER UNION JACK', 3, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (955, '536520', '22670', 'FRENCH WC SIGN BLUE METAL', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (956, '536520', '21867', 'PINK UNION JACK  LUGGAGE TAG', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (957, '536520', '22760', 'TRAY, BREAKFAST IN BED', 1, '12/1/2010 12:43', 12.75, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (958, '536520', '22107', 'PIZZA PLATE IN BOX', 2, '12/1/2010 12:43', 3.75, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (959, '536520', '22470', 'HEART OF WICKER LARGE', 1, '12/1/2010 12:43', 2.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (960, '536520', '21486', 'PINK HEART DOTS HOT WATER BOTTLE', 1, '12/1/2010 12:43', 3.75, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (961, '536520', '22151', 'PLACE SETTING WHITE HEART', 14, '12/1/2010 12:43', 0.42, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (962, '536520', '22643', 'SET OF 4 NAPKIN CHARMS LEAVES   ', 4, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (963, '536520', '22642', 'SET OF 4 NAPKIN CHARMS STARS   ', 4, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (964, '536520', '22604', 'SET OF 4 NAPKIN CHARMS CUTLERY', 3, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (965, '536520', '22099', 'CARAVAN SQUARE TISSUE BOX', 2, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (966, '536520', '22553', 'PLASTERS IN TIN SKULLS', 1, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (967, '536520', '22551', 'PLASTERS IN TIN SPACEBOY', 1, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (968, '536520', '22653', 'BUTTON BOX ', 1, '12/1/2010 12:43', 1.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (969, '536520', '22557', 'PLASTERS IN TIN VINTAGE PAISLEY ', 2, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (970, '536520', '22906', '12 MESSAGE CARDS WITH ENVELOPES', 6, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (971, '536520', '22754', 'SMALL RED BABUSHKA NOTEBOOK ', 1, '12/1/2010 12:43', 0.85, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (972, '536520', '22938', 'CUPCAKE LACE PAPER SET 6', 5, '12/1/2010 12:43', 1.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (973, '536520', '22812', 'PACK 3 BOXES CHRISTMAS PANNETONE', 3, '12/1/2010 12:43', 1.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (974, '536520', '22919', 'HERB MARKER MINT', 2, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (975, '536520', '22917', 'HERB MARKER ROSEMARY', 1, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (976, '536520', '22920', 'HERB MARKER BASIL', 3, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (977, '536520', '22921', 'HERB MARKER CHIVES ', 2, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (978, '536520', '22918', 'HERB MARKER PARSLEY', 2, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (979, '536520', '22916', 'HERB MARKER THYME', 1, '12/1/2010 12:43', 0.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (980, '536520', '85123A', 'WHITE HANGING HEART T-LIGHT HOLDER', 3, '12/1/2010 12:43', 2.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (981, '536520', '22575', 'METAL MERRY CHRISTMAS WREATH', 1, '12/1/2010 12:43', 1.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (982, '536520', '21804', 'WHITE CHRISTMAS GARLAND STARS TREES', 3, '12/1/2010 12:43', 3.75, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (983, '536520', '21584', 'RETROSPOT SMALL TUBE MATCHES', 12, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (984, '536520', '21588', 'RETROSPOT GIANT TUBE MATCHES', 3, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (985, '536520', '22152', 'PLACE SETTING WHITE STAR', 12, '12/1/2010 12:43', 0.42, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (986, '536520', '22441', 'GROW YOUR OWN BASIL IN ENAMEL MUG', 1, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (987, '536520', '22955', '36 FOIL STAR CAKE CASES ', 2, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (988, '536520', '22956', '36 FOIL HEART CAKE CASES', 2, '12/1/2010 12:43', 2.10, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (989, '536520', '22582', 'PACK OF 6 SWEETIE GIFT BOXES', 2, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (990, '536520', '22583', 'PACK OF 6 HANDBAG GIFT BOXES', 3, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (991, '536520', '22241', 'GARLAND WOODEN HAPPY EASTER', 2, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (992, '536520', '22904', 'CALENDAR PAPER CUT DESIGN', 3, '12/1/2010 12:43', 2.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (993, '536520', '22905', 'CALENDAR IN SEASON DESIGN', 2, '12/1/2010 12:43', 2.95, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (994, '536520', '22197', 'SMALL POPCORN HOLDER', 3, '12/1/2010 12:43', 0.85, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (995, '536520', '22092', 'BLUE PAISLEY TISSUE BOX', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (996, '536520', '22469', 'HEART OF WICKER SMALL', 1, '12/1/2010 12:43', 1.65, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (997, '536520', '22100', 'SKULLS SQUARE TISSUE BOX', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (998, '536520', '22096', 'PINK PAISLEY SQUARE TISSUE BOX ', 1, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (999, '536520', '22583', 'PACK OF 6 HANDBAG GIFT BOXES', 1, '12/1/2010 12:43', 2.55, '14729', 'United Kingdom');
INSERT INTO `sample_data_e_commerce` VALUES (1000, '536520', '21358', 'TOAST ITS - HAPPY BIRTHDAY', 2, '12/1/2010 12:43', 1.25, '14729', 'United Kingdom');