/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.statemachine;

import cn.sliew.carp.framework.common.dict.workflow.WorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.WorkflowTaskInstanceStage;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.publisher.InternalWorkflowTaskInstanceEventPublisher;
import com.alibaba.cola.statemachine.Action;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.builder.StateMachineBuilder;
import com.alibaba.cola.statemachine.builder.StateMachineBuilderFactory;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowTaskInstanceStateMachine
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowTaskInstanceStateMachine.class);
    public static final String CONSUMER_GROUP = "WorkflowTaskInstanceStateMachine";
    public static final String EXECUTOR = "WorkflowTaskInstanceExecute";
    @Autowired
    private InternalWorkflowTaskInstanceEventPublisher statusPublisher;
    private StateMachine<WorkflowTaskInstanceStage, WorkflowTaskInstanceEvent, Pair<Long, Throwable>> stateMachine;

    public void afterPropertiesSet() throws Exception {
        StateMachineBuilder builder = StateMachineBuilderFactory.create();
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.PENDING).to((Object)WorkflowTaskInstanceStage.RUNNING).on((Object)WorkflowTaskInstanceEvent.COMMAND_DEPLOY).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.RUNNING).to((Object)WorkflowTaskInstanceStage.SUCCESS).on((Object)WorkflowTaskInstanceEvent.PROCESS_SUCCESS).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.RUNNING).to((Object)WorkflowTaskInstanceStage.FAILURE).on((Object)WorkflowTaskInstanceEvent.PROCESS_FAILURE).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.RUNNING).to((Object)WorkflowTaskInstanceStage.SUSPEND).on((Object)WorkflowTaskInstanceEvent.COMMAND_SUSPEND).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.RUNNING).to((Object)WorkflowTaskInstanceStage.TERMINATED).on((Object)WorkflowTaskInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.SUSPEND).to((Object)WorkflowTaskInstanceStage.RUNNING).on((Object)WorkflowTaskInstanceEvent.COMMAND_RESUME).perform(this.doPerform());
        builder.externalTransition().from((Object)WorkflowTaskInstanceStage.SUSPEND).to((Object)WorkflowTaskInstanceStage.TERMINATED).on((Object)WorkflowTaskInstanceEvent.COMMAND_SHUTDOWN).perform(this.doPerform());
        this.stateMachine = builder.build(CONSUMER_GROUP);
    }

    private Action<WorkflowTaskInstanceStage, WorkflowTaskInstanceEvent, Pair<Long, Throwable>> doPerform() {
        return (fromState, toState, eventEnum, pair) -> {
            WorkflowTaskInstanceEventDTO eventDTO = new WorkflowTaskInstanceEventDTO((WorkflowTaskInstanceStage)fromState, (WorkflowTaskInstanceStage)toState, (WorkflowTaskInstanceEvent)eventEnum, (Long)pair.getLeft(), (Throwable)pair.getRight());
            this.statusPublisher.publish(eventDTO);
        };
    }

    public void deploy(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.COMMAND_DEPLOY, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void shutdown(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.COMMAND_SHUTDOWN, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void suspend(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.COMMAND_SUSPEND, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void resume(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.COMMAND_RESUME, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void onSuccess(WorkflowTaskInstance taskInstance) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.PROCESS_SUCCESS, (Object)Pair.of((Object)taskInstance.getId(), null));
    }

    public void onFailure(WorkflowTaskInstance taskInstance, Throwable throwable) {
        this.stateMachine.fireEvent((Object)taskInstance.getStatus(), (Object)WorkflowTaskInstanceEvent.PROCESS_FAILURE, (Object)Pair.of((Object)taskInstance.getId(), (Object)throwable));
    }
}

