/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.config;

import cn.sliew.carp.framework.web.converter.JacksonEnumConverter;
import cn.sliew.carp.framework.web.interceptor.AsyncWebLogInterceptor;
import cn.sliew.carp.framework.web.util.RequestParamUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    @Autowired
    private ObjectMapper mapper;

    public void addFormatters(FormatterRegistry registry) {
        super.addFormatters(registry);
        registry.addConverter((GenericConverter)new JacksonEnumConverter(this.mapper));
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        localeResolver.setDefaultLocale(Locale.getDefault());
        return localeResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("lang");
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
        super.addInterceptors(registry);
        try {
            registry.addInterceptor((HandlerInterceptor)new AsyncWebLogInterceptor());
            List allFieldsList = FieldUtils.getAllFieldsList(InterceptorRegistry.class);
            for (Field field : allFieldsList) {
                if (!field.getName().equals("registrations")) continue;
                ReflectionUtils.makeAccessible((Field)field);
                List registrations = (List)ReflectionUtils.getField((Field)field, (Object)registry);
                if (registrations != null) {
                    for (InterceptorRegistration interceptorRegistration : registrations) {
                        interceptorRegistration.excludePathPatterns(RequestParamUtil.getIgnorePaths());
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/"});
        registry.addResourceHandler(new String[]{"/doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCacheControl(CacheControl.maxAge((long)5L, (TimeUnit)TimeUnit.HOURS).cachePublic());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("redirect:/ui/");
        registry.addViewController("/ui/").setViewName("forward:/ui/index.html");
    }
}

