/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.filter;

import cn.sliew.carp.framework.web.util.RequestParamUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class RequestResponseCacheFilter
extends OncePerRequestFilter
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestResponseCacheFilter.class);

    public int getOrder() {
        return 0x7FFFFFF5;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!RequestParamUtil.isRequestValid(request) || RequestParamUtil.ignorePath(request.getRequestURI()) || RequestParamUtil.ignoreContentType(request.getContentType())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!(request instanceof ContentCachingRequestWrapper)) {
            request = new ContentCachingRequestWrapper(request);
        }
        if (!(response instanceof ContentCachingResponseWrapper)) {
            response = new ContentCachingResponseWrapper(response);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

