/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.interceptor;

import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.framework.log.model.LogRecord;
import cn.sliew.carp.framework.log.model.LogRequest;
import cn.sliew.carp.framework.log.model.LogResponse;
import cn.sliew.carp.framework.log.service.CarpSystemLogActionService;
import cn.sliew.milky.common.util.JacksonUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;

@Component
public class LogbookWebLogSink
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogbookWebLogSink.class);
    @Autowired
    private CarpSystemLogActionService carpSystemLogActionService;

    public void write(Precorrelation precorrelation, HttpRequest request) throws IOException {
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        try {
            this.printLog(correlation, request, response);
        }
        catch (Exception e) {
            log.error("Log exceptions", (Throwable)e);
        }
    }

    public void printLog(Correlation correlation, HttpRequest request, HttpResponse response) throws IOException {
        LogRecord record = new LogRecord();
        record.setStartTime(Date.from(correlation.getStart()));
        record.setEndTime(Date.from(correlation.getEnd()));
        record.setDuration(Long.valueOf(DateUtil.betweenMs((Date)record.getStartTime(), (Date)record.getEndTime())));
        LogRequest logRequest = new LogRequest();
        logRequest.setMethod(request.getMethod());
        logRequest.setPath(request.getPath());
        logRequest.setParam(request.getQuery());
        logRequest.setBody(request.getBodyAsString());
        logRequest.setHeaders((Map)request.getHeaders());
        logRequest.setIp(request.getHost());
        record.setRequest(logRequest);
        LogResponse logResponse = new LogResponse();
        logResponse.setStatus(Integer.valueOf(response.getStatus()));
        logResponse.setBody(response.getBodyAsString());
        record.setResponse(logResponse);
        log.info("{}", (Object)JacksonUtil.toJsonString((Object)record));
    }
}

