/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.AbstractProcessJob;
import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.manager.LockManager;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobContext;
import cn.sliew.milky.common.util.JacksonUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.pekko.Done;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.SpawnProtocol;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.stream.UniqueKillSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class AbstractLockJob
extends AbstractProcessJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLockJob.class);

    public AbstractLockJob(ActorSystem<SpawnProtocol.Command> actorSystem, MeterRegistry meterRegistry) {
        super(actorSystem, meterRegistry);
    }

    @Override
    protected boolean doExecuteBefore(JobContext context, Object param) {
        LockManager lockManager = context.lockManager();
        JobInfo jobInfo = context.jobInfo();
        boolean lock = lockManager.lock(jobInfo);
        if (context.logLevel() == JobLogLevel.COMPLEX || context.logLevel() == JobLogLevel.FULL) {
            if (lock) {
                context.log(log, Level.DEBUG, "ttl: {}, \u83b7\u53d6\u6267\u884c\u9501\u6210\u529f, param: {}", DurationFormatUtils.formatDurationHMS((long)lockManager.lockReleaseTime(jobInfo)), JacksonUtil.toJsonString((Object)param));
            } else {
                context.log(log, Level.DEBUG, "ttl: {}, \u83b7\u53d6\u6267\u884c\u9501\u5931\u8d25, param: {}", DurationFormatUtils.formatDurationHMS((long)lockManager.lockReleaseTime(jobInfo)), JacksonUtil.toJsonString((Object)param));
            }
        }
        return lock;
    }

    @Override
    protected void doExecuteAfter(JobContext context, Object param) {
        LockManager lockManager = context.lockManager();
        JobInfo jobInfo = context.jobInfo();
        boolean unlock = lockManager.unlock(jobInfo);
        if (context.logLevel() == JobLogLevel.COMPLEX || context.logLevel() == JobLogLevel.FULL) {
            if (unlock) {
                context.log(log, Level.DEBUG, "\u91ca\u653e\u6267\u884c\u9501\u6210\u529f, param: {}", JacksonUtil.toJsonString((Object)param));
            } else {
                context.log(log, Level.DEBUG, "ttl: {}, \u91ca\u653e\u6267\u884c\u9501\u5931\u8d25, param: {}", DurationFormatUtils.formatDurationHMS((long)lockManager.lockReleaseTime(jobInfo)), JacksonUtil.toJsonString((Object)param));
            }
        }
    }

    @Override
    protected void handleAsyncResult(JobContext context, Object param, Pair<UniqueKillSwitch, CompletionStage<Done>> pair) {
    }
}

