/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model;

import cn.sliew.carp.module.http.sync.framework.model.AbstractAroundJob;
import cn.sliew.carp.module.http.sync.framework.model.JobSetting;
import cn.sliew.carp.module.http.sync.framework.model.job.JobInfo;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.manager.DefaultSplitManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.LockManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.JobProcessor;
import cn.sliew.carp.module.http.sync.framework.model.processor.Result;
import cn.sliew.carp.module.http.sync.framework.model.processor.RootTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.Done;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.SpawnProtocol;
import org.apache.pekko.event.Logging;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.function.Function;
import org.apache.pekko.japi.function.Procedure;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.KillSwitches;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.UniformFanOutShape;
import org.apache.pekko.stream.UniqueKillSwitch;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.stream.javadsl.GraphDSL;
import org.apache.pekko.stream.javadsl.Keep;
import org.apache.pekko.stream.javadsl.MergeSequence;
import org.apache.pekko.stream.javadsl.Partition;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;

public abstract class AbstractProcessJob
extends AbstractAroundJob {
    protected final ActorSystem<SpawnProtocol.Command> actorSystem;
    protected final MeterRegistry meterRegistry;

    public AbstractProcessJob(ActorSystem<SpawnProtocol.Command> actorSystem, MeterRegistry meterRegistry) {
        this.actorSystem = actorSystem;
        this.meterRegistry = meterRegistry;
    }

    @Override
    protected Pair<UniqueKillSwitch, CompletionStage<Done>> doExecuteAsync(JobContext context, Object param) {
        JobProcessor processor = this.buildJobProcessor(context);
        RootTask rootTask = this.buildRootTask(param);
        Source source = Source.single((Object)rootTask).mapConcat((Function & Serializable)root -> processor.map(root)).viaMat(KillSwitches.single(), Keep.right());
        Flow process = Flow.create().map((Function & Serializable)subTask -> processor.process(subTask)).mapAsync(1, (Function & Serializable)future -> future);
        Flow subTasks = Flow.fromGraph((Graph)GraphDSL.create((Function & Serializable)b -> {
            int concurrency = context.jobSetting().getParallelism();
            UniformFanOutShape partition = (UniformFanOutShape)b.add(Partition.create((int)concurrency, (Function & Serializable)subTask -> Math.toIntExact(subTask.getIdentifier()) % concurrency));
            UniformFanInShape merge = (UniformFanInShape)b.add(MergeSequence.create((int)concurrency, (Function & Serializable)result -> result.getSubTask().getIdentifier()));
            for (int i = 0; i < concurrency; ++i) {
                b.from(partition.out(i)).via((FlowShape)b.add((Graph)process.async())).viaFanIn(merge);
            }
            return FlowShape.of((Inlet)partition.in(), (Outlet)merge.out());
        }));
        return (Pair)source.via((Graph)subTasks).log(this.getJobName(context.jobInfo())).withAttributes(Attributes.createLogLevels((int)this.getElementLogLevel(context), (int)this.getFinishLogLevel(context), (int)Logging.ErrorLevel())).toMat((Graph)Sink.foreach((Procedure & Serializable)result -> processor.reduce((Result)result)), Keep.both()).run(this.actorSystem);
    }

    protected String getJobName(JobInfo jobInfo) {
        if (jobInfo.getSubJob().isPresent()) {
            return String.format("%s.%s.%s", jobInfo.getGroup(), jobInfo.getJob(), jobInfo.getSubJob().get());
        }
        return String.format("%s.%s", jobInfo.getGroup(), jobInfo.getJob());
    }

    private int getElementLogLevel(JobContext context) {
        return switch (context.logLevel()) {
            case JobLogLevel.FULL, JobLogLevel.COMPLEX -> Logging.DebugLevel();
            default -> Logging.InfoLevel();
        };
    }

    private int getFinishLogLevel(JobContext context) {
        return switch (context.logLevel()) {
            case JobLogLevel.FULL, JobLogLevel.COMPLEX -> Logging.DebugLevel();
            default -> Logging.InfoLevel();
        };
    }

    @Override
    protected DefaultJobContext buildJobContext(String param) {
        return DefaultJobContext.builder().setting(this.getSetting(param)).actorSystem(this.actorSystem).meterRegistry(this.meterRegistry).splitManagerSupplier(setting -> this.buildSplitManager((JobSetting)setting)).syncOffsetManagerSupplier(setting -> this.buildSyncOffsetManager((JobSetting)setting)).lockManagerSupplier(setting -> this.buildLockManager((JobSetting)setting)).build();
    }

    protected SplitManager buildSplitManager(JobSetting setting) {
        return new DefaultSplitManager(setting);
    }

    protected abstract SyncOffsetManager buildSyncOffsetManager(JobSetting var1);

    protected abstract LockManager buildLockManager(JobSetting var1);

    protected JobProcessor buildJobProcessor(JobContext context) {
        return new DefaultJobProcessor(context);
    }

    protected abstract RootTask buildRootTask(Object var1);
}

