/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.framework.model.processor;

import cn.sliew.carp.module.http.sync.framework.model.manager.SplitManager;
import cn.sliew.carp.module.http.sync.framework.model.manager.SyncOffsetManager;
import cn.sliew.carp.module.http.sync.framework.model.processor.AbstractSubTask;
import cn.sliew.carp.module.http.sync.framework.model.processor.DefaultJobContext;
import cn.sliew.carp.module.http.sync.framework.model.processor.RootTask;
import cn.sliew.carp.module.http.sync.framework.repository.entity.JobSyncOffset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.pekko.japi.Pair;

public abstract class AbstractRootTask<Sub extends AbstractSubTask>
implements RootTask<DefaultJobContext, Sub> {
    private Long rootTaskId;

    public AbstractRootTask(Long rootTaskId) {
        this.rootTaskId = rootTaskId;
    }

    @Override
    public Long getIdentifier() {
        return this.rootTaskId;
    }

    @Override
    public List<Sub> split(DefaultJobContext context) {
        SyncOffsetManager syncOffsetManager = context.syncOffsetManager();
        JobSyncOffset syncOffset = syncOffsetManager.getSyncOffset(context);
        SplitManager splitManager = context.splitManager();
        Optional<Duration> optional = splitManager.getGradients().stream().filter(gradient -> splitManager.supportSplit(syncOffset.getSyncOffset(), syncOffsetManager.finalSyncOffset(), (Duration)gradient)).findFirst();
        Duration gradient2 = null;
        if (optional.isEmpty()) {
            if (splitManager.forceMinGradient() || splitManager.supportSplit(syncOffset.getSyncOffset(), syncOffsetManager.finalSyncOffset(), splitManager.getMinGradient())) {
                gradient2 = splitManager.getMinGradient();
            }
        } else {
            gradient2 = optional.get();
        }
        if (gradient2 == null) {
            return Collections.emptyList();
        }
        List<Pair<String, String>> splits = splitManager.split(syncOffset.getSyncOffset(), syncOffsetManager.finalSyncOffset(), gradient2);
        ArrayList<AbstractSubTask> subs = new ArrayList<AbstractSubTask>();
        for (int i = 0; i < splits.size(); ++i) {
            Pair<String, String> pair = splits.get(i);
            subs.add((AbstractSubTask)this.build(Long.valueOf(i), (String)pair.first(), (String)pair.second()));
        }
        return subs;
    }
}

