/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.jackson.Compression;
import org.apache.pekko.serialization.jackson.Compression$Off$;
import org.apache.pekko.serialization.jackson.JacksonMigration;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$LZ4Meta$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00115uA\u00023f\u0011\u0003IwN\u0002\u0004rK\"\u0005\u0011N\u001d\u0005\u0006s\u0006!\ta\u001f\u0004\u0005y\u0006\u0001Q\u0010\u0003\u0004z\u0007\u0011\u0005\u00111\u0004\u0005\b\u0003C\u0019A\u0011BA\u0012\u0011%\tYe\u0001b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002P\r\u0001\u000b\u0011BA\u001b\u0011%\t\tf\u0001b\u0001\n\u0013\ti\u0005\u0003\u0005\u0002T\r\u0001\u000b\u0011BA\u001b\u0011\u001d\t)f\u0001C\u0001\u0003/Bq!a\u0019\u0004\t\u0003\t)\u0007C\u0004\u0002\n\u000e!I!a#\t\u0013\u0005\u001d\u0016A1A\u0005\u0002\u0005%\u0006\u0002CA]\u0003\u0001\u0006I!a+\t\u000f\u0005m\u0016\u0001\"\u0001\u0002>\u001a1\u0011qZ\u0001C\u0003#D!\"a8\u0011\u0005+\u0007I\u0011AAq\u0011)\tI\u000f\u0005B\tB\u0003%\u00111\u001d\u0005\u000b\u0003W\u0004\"Q3A\u0005\u0002\u0005\u0005\bBCAw!\tE\t\u0015!\u0003\u0002d\"1\u0011\u0010\u0005C\u0001\u0003_Dq!a>\u0011\t\u0003\tI\u0010C\u0004\u0003\u0012A!\tAa\u0005\t\u0013\t]\u0001#!A\u0005\u0002\te\u0001\"\u0003B\u0010!E\u0005I\u0011\u0001B\u0011\u0011%\u0011\u0019\u0004EI\u0001\n\u0003\u0011\t\u0003C\u0005\u00036A\t\t\u0011\"\u0011\u00038!I!1\t\t\u0002\u0002\u0013\u0005\u0011\u0011\u001d\u0005\n\u0005\u000b\u0002\u0012\u0011!C\u0001\u0005\u000fB\u0011B!\u0014\u0011\u0003\u0003%\tEa\u0014\t\u0013\tu\u0003#!A\u0005\u0002\t}\u0003\"\u0003B2!\u0005\u0005I\u0011\tB3\u0011%\u00119\u0007EA\u0001\n\u0003\u0012I\u0007C\u0005\u0003lA\t\t\u0011\"\u0011\u0003n\u001d9!\u0011O\u0001\t\u0002\tMdaBAh\u0003!\u0005!Q\u000f\u0005\u0007s\u0012\"\tAa\u001e\t\u0013\teDE1A\u0005\u0002\u0005\u0005\b\u0002\u0003B>I\u0001\u0006I!a9\t\u000f\tuD\u0005\"\u0001\u0003\u0000!9!1\u0011\u0013\u0005\u0002\t\u0015\u0005b\u0002BBI\u0011\u0005!1\u0013\u0005\n\u0005{\"\u0013\u0011!CA\u0005/C\u0011B!(%\u0003\u0003%\tIa(\t\u0013\tEF%!A\u0005\n\tM\u0006b\u0002B^\u0003\u0011\u0005!Q\u0018\u0004\bc\u0016\f\t!\u001bBh\u0011)\u0011In\fBC\u0002\u0013\u0005!1\u001c\u0005\u000b\u0005S|#\u0011!Q\u0001\n\tu\u0007B\u0003Bv_\t\u0015\r\u0011\"\u0001\u0002N!Q!Q^\u0018\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\t=xF!b\u0001\n\u0003\u0011\t\u0010\u0003\u0006\u0003|>\u0012\t\u0011)A\u0005\u0005gDa!_\u0018\u0005\u0002\tu\b\"CB\u0004_\t\u0007I\u0011BB\u0005\u0011!\u00199b\fQ\u0001\n\r-\u0001\"CB\r_\t\u0007I\u0011BB\u000e\u0011!\u0019ic\fQ\u0001\n\ru\u0001\"CB\u0018_\t\u0007I\u0011BB\u0019\u0011!\u0019\u0019d\fQ\u0001\n\u0005e\u0003\"CB\u001b_\t\u0007IQBB\u001c\u0011!\u0019id\fQ\u0001\u000e\re\u0002\"CB _\t\u0007I\u0011BB!\u0011!\u0019\tf\fQ\u0001\n\r\r\u0003\"CB*_\t\u0007I\u0011BB+\u0011!\u0019\u0019g\fQ\u0001\n\r]\u0003\"CB3_\t\u0007I\u0011BB4\u0011!\u0019ig\fQ\u0001\n\r%\u0004\"CB8_\t\u0007I\u0011BB9\u0011!\u0019\ti\fQ\u0001\n\rM\u0004\"CBB_\t\u0007I\u0011BB\u0019\u0011!\u0019)i\fQ\u0001\n\u0005e\u0003\"CBD_\t\u0007I\u0011BBE\u0011!\u00199j\fQ\u0001\n\r-\u0005\"\u000350\u0011\u000b\u0007I\u0011BBN\u0011)\u0019\u0019k\fEC\u0002\u0013%1Q\u0015\u0005\n\u0007g{\u0003\u0019!C\u0005\u0007cA\u0011b!.0\u0001\u0004%Iaa.\t\u0011\rmv\u0006)Q\u0005\u00033B!b!00\u0011\u000b\u0007I\u0011BB`\u0011)\u0019)n\fEC\u0002\u0013%1q\u001b\u0005\u000b\u0007?|\u0003R1A\u0005\n\r\u0005\b\"CBu_\t\u0007I\u0011IAq\u0011!\u0019Yo\fQ\u0001\n\u0005\r\bbBBw_\u0011\u00053q\u001e\u0005\b\u0007k|C\u0011IB|\u0011\u001d\u0019Yp\fC\u0005\u0007{Dq\u0001\"\u00050\t\u0003\"\u0019\u0002C\u0004\u0005\u001a=\"I\u0001b\u0007\t\u000f\u0011Er\u0006\"\u0003\u00054!9AqG\u0018\u0005\n\u0011e\u0002b\u0002C\u001f_\u0011%Aq\b\u0005\b\t\u001bzC\u0011\u0002C(\u0011\u001d!if\fC\u0005\t?Bq\u0001\"\u001c0\t\u0013!y\u0007C\u0004\u0005t=\"I\u0001\"\u001e\t\u000f\u0011]t\u0006\"\u0003\u0005z!9AqP\u0018\u0005\u0002\u0011\u0005\u0005b\u0002CC_\u0011\u0005AqQ\u0001\u0012\u0015\u0006\u001c7n]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u00014h\u0003\u001dQ\u0017mY6t_:T!\u0001[5\u0002\u001bM,'/[1mSj\fG/[8o\u0015\tQ7.A\u0003qK.\\wN\u0003\u0002m[\u00061\u0011\r]1dQ\u0016T\u0011A\\\u0001\u0004_J<\u0007C\u00019\u0002\u001b\u0005)'!\u0005&bG.\u001cxN\\*fe&\fG.\u001b>feN\u0011\u0011a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0002m\u0006)1oY1mC&\u0011\u00010\u001e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\u001c\u0002\u0014\u000f\u0006$w-\u001a;DY\u0006\u001c8\u000fR3os2K7\u000f^\n\u0003\u0007y\u00042a`A\f\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B5na2TA!a\u0002\u0002\n\u0005A!n]8oif\u0004XM\u0003\u0003\u0002\f\u00055\u0011\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0007\u0019\fyA\u0003\u0003\u0002\u0012\u0005M\u0011!\u00034bgR,'\u000f_7m\u0015\t\t)\"A\u0002d_6LA!!\u0007\u0002\u0002\t\u00012+\u001e2UsB,g+\u00197jI\u0006$xN\u001d\u000b\u0003\u0003;\u00012!a\b\u0004\u001b\u0005\t\u0011\u0001\u00073fM\u0006,H\u000e\u001e(p\t\u0016\u001cXM]\"mCN\u001ch*Y7fgV\u0011\u0011Q\u0005\t\u0007\u0003O\t\t$!\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tA!\u001e;jY*\u0011\u0011qF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005%\"aA*fiB!\u0011qGA#\u001d\u0011\tI$!\u0011\u0011\u0007\u0005mR/\u0004\u0002\u0002>)\u0019\u0011q\b>\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019%^\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\rS/\u0001\u0007qe\u00164\u0017\u000e_*qe&tw-\u0006\u0002\u00026\u0005i\u0001O]3gSb\u001c\u0006O]5oO\u0002\n!\u0002\u001d:fM&D8i\r)1\u0003-\u0001(/\u001a4jq\u000e\u001b\u0004\u000b\r\u0011\u0002%%\u001c\u0018\t\u001c7po\u0016$7\t\\1tg:\u000bW.\u001a\u000b\u0005\u00033\ny\u0006E\u0002u\u00037J1!!\u0018v\u0005\u001d\u0011un\u001c7fC:Dq!!\u0019\u000b\u0001\u0004\t)$A\u0005dY\u0006\u001c8OT1nK\u0006q\u0011n]!mY><X\rZ\"mCN\u001cH\u0003BA-\u0003OBq!!\u001b\f\u0001\u0004\tY'A\u0003dY\u0006T(\u0010\r\u0003\u0002n\u0005]\u0004CBA\u001c\u0003_\n\u0019(\u0003\u0003\u0002r\u0005%#!B\"mCN\u001c\b\u0003BA;\u0003ob\u0001\u0001\u0002\u0007\u0002z\u0005\u001d\u0014\u0011!A\u0001\u0006\u0003\tYHA\u0002`IE\nB!! \u0002\u0004B\u0019A/a \n\u0007\u0005\u0005UOA\u0004O_RD\u0017N\\4\u0011\u0007Q\f))C\u0002\u0002\bV\u00141!\u00118z\u0003QI7/\u00117m_^,Gm\u00159sS:<7\t\\1tgR!\u0011\u0011LAG\u0011\u001d\tI\u0007\u0004a\u0001\u0003\u001f\u0003D!!%\u0002\u0016B1\u0011qGA8\u0003'\u0003B!!\u001e\u0002\u0016\u0012a\u0011qSAG\u0003\u0003\u0005\tQ!\u0001\u0002|\t\u0019q\f\n\u001a)\u00071\tY\n\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\t+^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u0003?\u0013q\u0001^1jYJ,7-A\u0010eSN\fG\u000e\\8xK\u0012\u001cVM]5bY&T\u0018\r^5p]\nKg\u000eZ5oON,\"!a+\u0011\r\u0005]\u0012QVAX\u0013\u0011\t\u0019$!\u00131\t\u0005E\u0016Q\u0017\t\u0007\u0003o\ty'a-\u0011\t\u0005U\u0014Q\u0017\u0003\f\u0003os\u0011\u0011!A\u0001\u0006\u0003\tYHA\u0002`IM\n\u0001\u0005Z5tC2dwn^3e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4tA\u0005I\u0011n]$[SB\u0004X\r\u001a\u000b\u0005\u00033\ny\fC\u0004\u0002B>\u0001\r!a1\u0002\u000b\tLH/Z:\u0011\u000bQ\f)-!3\n\u0007\u0005\u001dWOA\u0003BeJ\f\u0017\u0010E\u0002u\u0003\u0017L1!!4v\u0005\u0011\u0011\u0015\u0010^3\u0003\u000f1SF'T3uCN1\u0001c]Aj\u00033\u00042\u0001^Ak\u0013\r\t9.\u001e\u0002\b!J|G-^2u!\r!\u00181\\\u0005\u0004\u0003;,(\u0001D*fe&\fG.\u001b>bE2,\u0017AB8gMN,G/\u0006\u0002\u0002dB\u0019A/!:\n\u0007\u0005\u001dXOA\u0002J]R\fqa\u001c4gg\u0016$\b%\u0001\u0004mK:<G\u000f[\u0001\bY\u0016tw\r\u001e5!)\u0019\t\t0a=\u0002vB\u0019\u0011q\u0004\t\t\u000f\u0005}W\u00031\u0001\u0002d\"9\u00111^\u000bA\u0002\u0005\r\u0018a\u00029vi&sGo\u001c\u000b\u0005\u0003w\u0014\t\u0001E\u0002u\u0003{L1!a@v\u0005\u0011)f.\u001b;\t\u000f\t\ra\u00031\u0001\u0003\u0006\u00051!-\u001e4gKJ\u0004BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\ti#A\u0002oS>LAAa\u0004\u0003\n\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0013A\u0014X\r]3oIR{G\u0003BAb\u0005+Aq!!1\u0018\u0001\u0004\t\u0019-\u0001\u0003d_BLHCBAy\u00057\u0011i\u0002C\u0005\u0002`b\u0001\n\u00111\u0001\u0002d\"I\u00111\u001e\r\u0011\u0002\u0003\u0007\u00111]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019C\u000b\u0003\u0002d\n\u00152F\u0001B\u0014!\u0011\u0011ICa\f\u000e\u0005\t-\"\u0002\u0002B\u0017\u0003?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\tE\"1\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0002\u0003\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\t\t}\u0012QF\u0001\u0005Y\u0006tw-\u0003\u0003\u0002H\tu\u0012\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0007\u0013I\u0005C\u0005\u0003Lu\t\t\u00111\u0001\u0002d\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0015\u0011\r\tM#\u0011LAB\u001b\t\u0011)FC\u0002\u0003XU\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YF!\u0016\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u00033\u0012\t\u0007C\u0005\u0003L}\t\t\u00111\u0001\u0002\u0004\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002d\u0006AAo\\*ue&tw\r\u0006\u0002\u0003:\u00051Q-];bYN$B!!\u0017\u0003p!I!1\n\u0012\u0002\u0002\u0003\u0007\u00111Q\u0001\b\u0019j#T*\u001a;b!\r\ty\u0002J\n\u0005IM\fI\u000e\u0006\u0002\u0003t\u0005IAJ\u0017\u001b`\u001b\u0006;\u0015jQ\u0001\u000b\u0019j#t,T!H\u0013\u000e\u0003\u0013!B1qa2LH\u0003BAy\u0005\u0003Cq!!1)\u0001\u0004\t\u0019-A\u0002hKR$BAa\"\u0003\u0012B1!\u0011\u0012BG\u0003cl!Aa#\u000b\u0007\u0005-\u0012.\u0003\u0003\u0003\u0010\n-%!C(qi&|gNV1m\u0011\u001d\u0011\u0019!\u000ba\u0001\u0005\u000b!BAa\"\u0003\u0016\"9\u0011\u0011\u0019\u0016A\u0002\u0005\rGCBAy\u00053\u0013Y\nC\u0004\u0002`.\u0002\r!a9\t\u000f\u0005-8\u00061\u0001\u0002d\u00069QO\\1qa2LH\u0003\u0002BQ\u0005[\u0003R\u0001\u001eBR\u0005OK1A!*v\u0005\u0019y\u0005\u000f^5p]B9AO!+\u0002d\u0006\r\u0018b\u0001BVk\n1A+\u001e9mKJB\u0011Ba,-\u0003\u0003\u0005\r!!=\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B[!\u0011\u0011YDa.\n\t\te&Q\b\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b%\u001cHJ\u0017\u001b\u0015\t\u0005e#q\u0018\u0005\b\u0003\u0003t\u0003\u0019AAbQ\r\t!1\u0019\t\u0005\u0005\u000b\u0014I-\u0004\u0002\u0003H*\u0019\u0011\u0011U5\n\t\t-'q\u0019\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eK\u0002\u0001\u0005\u0007\u001c2a\fBi!\u0011\u0011\u0019N!6\u000e\u0003\u001dL1Aa6h\u0005q\u0019VM]5bY&TXM],ji\"\u001cFO]5oO6\u000bg.\u001b4fgR\faa]=ti\u0016lWC\u0001Bo!\u0011\u0011yN!:\u000e\u0005\t\u0005(b\u0001BrS\u0006)\u0011m\u0019;pe&!!q\u001dBq\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\n1BY5oI&twMT1nK\u0006a!-\u001b8eS:<g*Y7fA\u0005aqN\u00196fGRl\u0015\r\u001d9feV\u0011!1\u001f\t\u0005\u0005k\u001490\u0004\u0002\u0002\n%!!\u0011`A\u0005\u00051y%M[3di6\u000b\u0007\u000f]3s\u00035y'M[3di6\u000b\u0007\u000f]3sAQA!q`B\u0001\u0007\u0007\u0019)\u0001\u0005\u0002q_!9!\u0011\u001c\u001cA\u0002\tu\u0007b\u0002Bvm\u0001\u0007\u0011Q\u0007\u0005\b\u0005_4\u0004\u0019\u0001Bz\u0003\rawnZ\u000b\u0003\u0007\u0017\u0001Ba!\u0004\u0004\u00145\u00111q\u0002\u0006\u0004\u0007#I\u0017!B3wK:$\u0018\u0002BB\u000b\u0007\u001f\u0011A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nAaY8oMV\u00111Q\u0004\t\u0005\u0007?\u0019I#\u0004\u0002\u0004\")!11EB\u0013\u0003\u0019\u0019wN\u001c4jO*!1qEA\n\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BB\u0016\u0007C\u0011aaQ8oM&<\u0017!B2p]\u001a\u0004\u0013AD5t\t\u0016\u0014WoZ#oC\ndW\rZ\u000b\u0003\u00033\nq\"[:EK\n,x-\u00128bE2,G\rI\u0001\u000b\u0005V4g-\u001a:TSj,WCAB\u001d\u001f\t\u0019Y$\b\u0002\u0011\u0001\u0005Y!)\u001e4gKJ\u001c\u0016N_3!\u0003Q\u0019w.\u001c9sKN\u001c\u0018n\u001c8BY\u001e|'/\u001b;i[V\u001111\t\t\u0005\u0007\u000b\u001aYED\u0002q\u0007\u000fJ1a!\u0013f\u0003-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\n\t\r53q\n\u0002\t\u00032<wN]5u[*\u00191\u0011J3\u0002+\r|W\u000e\u001d:fgNLwN\\!mO>\u0014\u0018\u000e\u001e5nA\u0005QQ.[4sCRLwN\\:\u0016\u0005\r]\u0003\u0003CA\u001c\u00073\n)d!\u0018\n\t\rm\u0013\u0011\n\u0002\u0004\u001b\u0006\u0004\bc\u00019\u0004`%\u00191\u0011M3\u0003!)\u000b7m[:p]6KwM]1uS>t\u0017aC7jOJ\fG/[8og\u0002\n\u0001\u0002Z3os2K7\u000f^\u000b\u0003\u0007S\u00022aa\u001b\u0004\u001d\t\u0001\b!A\u0005eK:LH*[:uA\u0005\u0011\u0012\r\u001c7po\u0016$7\t\\1tgB\u0013XMZ5y+\t\u0019\u0019\b\u0005\u0004\u0004v\rm$\u0011\b\b\u0004i\u000e]\u0014bAB=k\u00069\u0001/Y2lC\u001e,\u0017\u0002BB?\u0007\u007f\u0012aAV3di>\u0014(bAB=k\u0006\u0019\u0012\r\u001c7po\u0016$7\t\\1tgB\u0013XMZ5yA\u0005qA/\u001f9f\u0013:l\u0015M\\5gKN$\u0018a\u0004;za\u0016Le.T1oS\u001a,7\u000f\u001e\u0011\u0002;\r|gNZ5hkJ,G\rR3tKJL\u0017\r\\5{CRLwN\u001c+za\u0016,\"aa#\u0011\u000bQ\u0014\u0019k!$1\t\r=51\u0013\t\u0007\u0003o\tyg!%\u0011\t\u0005U41\u0013\u0003\f\u0007+S\u0015\u0011!A\u0001\u0006\u0003\u0019IJA\u0002`IU\nadY8oM&<WO]3e\t\u0016\u001cXM]5bY&T\u0018\r^5p]RK\b/\u001a\u0011\u0012\u0007\u0005u4/\u0006\u0002\u0004\u001eB!!1[BP\u0013\r\u0019\tk\u001a\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002'\u0011,7/\u001a:jC2L'0\u0019;j_:$\u0016\u0010]3\u0016\u0005\r\u001d\u0006#\u0002;\u0003$\u000e%\u0006\u0007BBV\u0007_\u0003b!a\u000e\u0002p\r5\u0006\u0003BA;\u0007_#1b!-M\u0003\u0003\u0005\tQ!\u0001\u0004\u001a\n\u0019q\f\n\u001c\u0002=M,'/[1mSj\fG/[8o\u0005&tG-\u001b8hg\u000eCWmY6fI>[\u0017AI:fe&\fG.\u001b>bi&|gNQ5oI&twm]\"iK\u000e\\W\rZ(l?\u0012*\u0017\u000f\u0006\u0003\u0002|\u000ee\u0006\"\u0003B&\u001d\u0006\u0005\t\u0019AA-\u0003}\u0019XM]5bY&T\u0018\r^5p]\nKg\u000eZ5oON\u001c\u0005.Z2lK\u0012|5\u000eI\u0001\u000bYj$d)Y2u_JLXCABa!\u0011\u0019\u0019m!5\u000e\u0005\r\u0015'\u0002BBd\u0007\u0013\f1\u0001\u001c>5\u0015\u0011\u0019Ym!4\u0002\u000f)\u0004x.\u001e8uu*\u00111qZ\u0001\u0004]\u0016$\u0018\u0002BBj\u0007\u000b\u0014!\u0002\u0014.5\r\u0006\u001cGo\u001c:z\u00035a'\u0010N\"p[B\u0014Xm]:peV\u00111\u0011\u001c\t\u0005\u0007\u0007\u001cY.\u0003\u0003\u0004^\u000e\u0015'!\u0004'[i\r{W\u000e\u001d:fgN|'/A\bmuR\"UmY8naJ,7o]8s+\t\u0019\u0019\u000f\u0005\u0003\u0004D\u000e\u0015\u0018\u0002BBt\u0007\u000b\u00141\u0003\u0014.5'\u00064W\rR3d_6\u0004(/Z:t_J\f!\"\u001b3f]RLg-[3s\u0003-IG-\u001a8uS\u001aLWM\u001d\u0011\u0002\u00115\fg.\u001b4fgR$B!!\u000e\u0004r\"111_+A\u0002M\f1a\u001c2k\u0003!!xNQ5oCJLH\u0003BAb\u0007sDaaa=W\u0001\u0004\u0019\u0018a\u00057pOR{')\u001b8bef$UO]1uS>tGCCA~\u0007\u007f$\t\u0001b\u0003\u0005\u000e!111_,A\u0002MDq\u0001b\u0001X\u0001\u0004!)!A\u0005ti\u0006\u0014H\u000fV5nKB\u0019A\u000fb\u0002\n\u0007\u0011%QO\u0001\u0003M_:<\u0007bBAa/\u0002\u0007\u00111\u0019\u0005\b\t\u001f9\u0006\u0019AAb\u0003\u0019\u0011Xm];mi\u0006QaM]8n\u0005&t\u0017M]=\u0015\u000bM$)\u0002b\u0006\t\u000f\u0005\u0005\u0007\f1\u0001\u0002D\"91Q\u001e-A\u0002\u0005U\u0012!\u00067pO\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010R;sCRLwN\u001c\u000b\u000b\u0003w$i\u0002b\b\u0005$\u0011\u0015\u0002bBAa3\u0002\u0007\u00111\u0019\u0005\b\tCI\u0006\u0019AAb\u0003=!WmY8naJ,7o\u001d\"zi\u0016\u001c\bb\u0002C\u00023\u0002\u0007AQ\u0001\u0005\b\u0003SJ\u0006\u0019\u0001C\u0014a\u0011!I\u0003\"\f\u0011\r\u0005]\u0012q\u000eC\u0016!\u0011\t)\b\"\f\u0005\u0019\u0011=BQEA\u0001\u0002\u0003\u0015\ta!'\u0003\u0007}#s'\u0001\u0007jg\u000e\u000b7/Z(cU\u0016\u001cG\u000f\u0006\u0003\u0002Z\u0011U\u0002bBA15\u0002\u0007\u0011QG\u0001\u0016G\",7m[!mY><X\rZ\"mCN\u001ch*Y7f)\u0011\tY\u0010b\u000f\t\u000f\u0005\u00054\f1\u0001\u00026\u0005\t2\r[3dW\u0006cGn\\<fI\u000ec\u0017m]:\u0015\t\u0005mH\u0011\t\u0005\b\u0003Sb\u0006\u0019\u0001C\"a\u0011!)\u0005\"\u0013\u0011\r\u0005]\u0012q\u000eC$!\u0011\t)\b\"\u0013\u0005\u0019\u0011-C\u0011IA\u0001\u0002\u0003\u0015\t!a\u001f\u0003\u0007}#\u0003(A\u0007jg&s\u0017\t\u001c7po2K7\u000f\u001e\u000b\u0005\u00033\"\t\u0006C\u0004\u0002ju\u0003\r\u0001b\u00151\t\u0011UC\u0011\f\t\u0007\u0003o\ty\u0007b\u0016\u0011\t\u0005UD\u0011\f\u0003\r\t7\"\t&!A\u0001\u0002\u000b\u0005\u00111\u0010\u0002\u0004?\u0012J\u0014AG5t\u0005>,h\u000e\u001a+p\u0015\u0006\u001c7n]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014H\u0003BA-\tCBq!!\u001b_\u0001\u0004!\u0019\u0007\r\u0003\u0005f\u0011%\u0004CBA\u001c\u0003_\"9\u0007\u0005\u0003\u0002v\u0011%D\u0001\u0004C6\tC\n\t\u0011!A\u0003\u0002\u0005m$\u0001B0%cA\nQ\u0003[1t\u00032dwn^3e\u00072\f7o\u001d)sK\u001aL\u0007\u0010\u0006\u0003\u0002Z\u0011E\u0004bBA1?\u0002\u0007\u0011QG\u0001\"G\",7m[!mY><X\rZ*fe&\fG.\u001b>bi&|gNQ5oI&twm\u001d\u000b\u0003\u0003w\fQ\u0002]1sg\u0016l\u0015M\\5gKN$H\u0003\u0002C>\t{\u0002r\u0001\u001eBU\u0003G\f)\u0004C\u0004\u0004n\u0006\u0004\r!!\u000e\u0002\u0011\r|W\u000e\u001d:fgN$B!a1\u0005\u0004\"9\u0011\u0011\u00192A\u0002\u0005\r\u0017A\u00033fG>l\u0007O]3tgR!\u00111\u0019CE\u0011\u001d\t\tm\u0019a\u0001\u0003\u0007D3a\fBb\u0001")
@InternalApi
public abstract class JacksonSerializer
extends SerializerWithStringManifest {
    private Serialization serialization;
    private Option<Class<?>> deserializationType;
    private LZ4Factory lz4Factory;
    private LZ4Compressor lz4Compressor;
    private LZ4SafeDecompressor lz4Decompressor;
    private final ExtendedActorSystem system;
    private final String bindingName;
    private final ObjectMapper objectMapper;
    private final MarkerLoggingAdapter log;
    private final Config conf;
    private final boolean isDebugEnabled;
    private final Compression.Algoritm compressionAlgorithm;
    private final Map<String, JacksonMigration> migrations;
    private final GadgetClassDenyList denyList;
    private final Vector<String> allowedClassPrefix;
    private final boolean typeInManifest;
    private Option<Class<?>> configuredDeserializationType;
    private boolean serializationBindingsCheckedOk;
    private final int identifier;
    private volatile byte bitmap$0;

    public static boolean isLZ4(byte[] byArray) {
        return JacksonSerializer$.MODULE$.isLZ4(byArray);
    }

    public static boolean isGZipped(byte[] byArray) {
        return JacksonSerializer$.MODULE$.isGZipped(byArray);
    }

    public static scala.collection.immutable.Set<Class<?>> disallowedSerializationBindings() {
        return JacksonSerializer$.MODULE$.disallowedSerializationBindings();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public String bindingName() {
        return this.bindingName;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private Config conf() {
        return this.conf;
    }

    private boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    private final int BufferSize() {
        return 4096;
    }

    private Compression.Algoritm compressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    private Map<String, JacksonMigration> migrations() {
        return this.migrations;
    }

    private GadgetClassDenyList denyList() {
        return this.denyList;
    }

    private Vector<String> allowedClassPrefix() {
        return this.allowedClassPrefix;
    }

    private boolean typeInManifest() {
        return this.typeInManifest;
    }

    private Option<Class<?>> configuredDeserializationType() {
        return this.configuredDeserializationType;
    }

    private Serialization serialization$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private Option<Class<?>> deserializationType$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deserializationType = this.typeInManifest() ? None$.MODULE$ : this.configuredDeserializationType().orElse((Function0 & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2;
                    scala.collection.immutable.Seq bindings = (scala.collection.immutable.Seq)this.serialization().bindings().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JacksonSerializer.$anonfun$deserializationType$2(this, x$1)));
                    if (Nil$.MODULE$.equals(bindings)) {
                        throw new IllegalArgumentException(new StringBuilder(160).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but none were configured").toString());
                    }
                    Some some = Seq$.MODULE$.unapplySeq((Seq)bindings);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (tuple2 = (Tuple2)((SeqLike)some.get()).apply(0)) != null) {
                        Class clazz = (Class)tuple2._1();
                        return new Some(clazz.asSubclass(Object.class));
                    }
                    throw new IllegalArgumentException(new StringBuilder(176).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but multiple bindings").append(" were configured [").append(bindings.mkString(", ")).append("]").toString());
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.configuredDeserializationType = null;
        return this.deserializationType;
    }

    private Option<Class<?>> deserializationType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deserializationType$lzycompute();
        }
        return this.deserializationType;
    }

    private boolean serializationBindingsCheckedOk() {
        return this.serializationBindingsCheckedOk;
    }

    private void serializationBindingsCheckedOk_$eq(boolean x$1) {
        this.serializationBindingsCheckedOk = x$1;
    }

    private LZ4Factory lz4Factory$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lz4Factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lz4Factory;
    }

    private LZ4Factory lz4Factory() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.lz4Factory$lzycompute();
        }
        return this.lz4Factory;
    }

    private LZ4Compressor lz4Compressor$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.lz4Compressor = this.lz4Factory().fastCompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.lz4Compressor;
    }

    private LZ4Compressor lz4Compressor() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.lz4Compressor$lzycompute();
        }
        return this.lz4Compressor;
    }

    private LZ4SafeDecompressor lz4Decompressor$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.lz4Decompressor = this.lz4Factory().safeDecompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.lz4Decompressor;
    }

    private LZ4SafeDecompressor lz4Decompressor() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.lz4Decompressor$lzycompute();
        }
        return this.lz4Decompressor;
    }

    public int identifier() {
        return this.identifier;
    }

    public String manifest(Object obj) {
        this.checkAllowedSerializationBindings();
        Option<Class<?>> option = this.deserializationType();
        if (option instanceof Some) {
            Class clazz = (Class)((Some)option).value();
            Option option2 = this.migrations().get((Object)clazz.getName());
            if (option2 instanceof Some) {
                JacksonMigration transformer = (JacksonMigration)((Some)option2).value();
                return new StringBuilder(1).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option2)) {
                return "";
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String className = obj.getClass().getName();
            this.checkAllowedClassName(className);
            this.checkAllowedClass(obj.getClass());
            Option option3 = this.migrations().get((Object)className);
            if (option3 instanceof Some) {
                JacksonMigration transformer = (JacksonMigration)((Some)option3).value();
                return new StringBuilder(1).append(className).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option3)) {
                return className;
            }
            throw new MatchError((Object)option3);
        }
        throw new MatchError(option);
    }

    public byte[] toBinary(Object obj) {
        this.checkAllowedSerializationBindings();
        long startTime = this.isDebugEnabled() ? System.nanoTime() : 0L;
        byte[] bytes = this.objectMapper().writeValueAsBytes(obj);
        byte[] result = this.compress(bytes);
        this.logToBinaryDuration(obj, startTime, bytes, result);
        return result;
    }

    private void logToBinaryDuration(Object obj, long startTime, byte[] bytes, byte[] result) {
        if (this.isDebugEnabled()) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == result.length) {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length));
                return;
            }
            this.log().debug("Serialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object fromBinary(byte[] bytes, String manifest) {
        this.checkAllowedSerializationBindings();
        startTime = this.isDebugEnabled() != false ? System.nanoTime() : 0L;
        var5_4 = this.parseManifest(manifest);
        if (var5_4 == null) {
            throw new MatchError(null);
        }
        fromVersion = var5_4._1$mcI$sp();
        manifestClassName = (String)var5_4._2();
        if (this.typeInManifest()) {
            this.checkAllowedClassName((String)var7_6);
        }
        migration = this.migrations().get(this.deserializationType().fold((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$1(java.lang.String ), ()Ljava/lang/String;)((String)var7_6), (Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fromBinary$2(java.lang.Class ), (Ljava/lang/Class;)Ljava/lang/String;)()));
        var10_8 = false;
        var11_9 = null;
        if (!(migration instanceof Some)) ** GOTO lbl-1000
        var10_8 = true;
        var11_9 = (Some)migration;
        transformer = (JacksonMigration)var11_9.value();
        if (var6_5 < transformer.currentVersion()) {
            v0 = transformer.transformClassName((int)var6_5, (String)var7_6);
        } else if (var10_8 && var6_5 == (transformer = (JacksonMigration)var11_9.value()).currentVersion()) {
            v0 = var7_6;
        } else if (var10_8 && var6_5 <= (transformer = (JacksonMigration)var11_9.value()).supportedForwardVersion()) {
            v0 = transformer.transformClassName((int)var6_5, (String)var7_6);
        } else {
            if (var10_8 && var6_5 > (transformer = (JacksonMigration)var11_9.value()).supportedForwardVersion()) {
                throw new IllegalStateException(new StringBuilder(61).append("Migration version ").append(transformer.supportedForwardVersion()).append(" is ").append("behind version ").append((int)var6_5).append(" of deserialized type [").append((String)var7_6).append("]").toString());
            }
            v0 = className = var7_6;
        }
        if (this.typeInManifest() && className != var7_6) {
            this.checkAllowedClassName((String)className);
        }
        if (this.isCaseObject((String)className)) {
            var16_15 = this.system().dynamicAccess().getObjectFor((String)className, ClassTag$.MODULE$.AnyRef());
            if (!(var16_15 instanceof Success)) {
                if (var16_15 instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(54).append("Cannot find manifest case object [").append((String)className).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
                }
                throw new MatchError((Object)var16_15);
            }
            obj = ((Success)var16_15).value();
            clazz = var17_16.getClass();
            this.checkAllowedClass(clazz);
            this.logFromBinaryDuration(bytes, bytes, startTime, clazz);
            return var17_16;
        }
        clazz = (Class)this.deserializationType().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$3(org.apache.pekko.serialization.jackson.JacksonSerializer java.lang.String ), ()Ljava/lang/Class;)((JacksonSerializer)this, (String)className));
        if (this.typeInManifest()) {
            this.checkAllowedClass(clazz);
        }
        decompressedBytes = this.decompress(bytes);
        var22_20 = false;
        var23_21 = null;
        if (!(migration instanceof Some)) ** GOTO lbl-1000
        var22_20 = true;
        var23_21 = (Some)migration;
        transformer = (JacksonMigration)var23_21.value();
        if (var6_5 < transformer.currentVersion()) {
            jsonTree = this.objectMapper().readTree(decompressedBytes);
            newJsonTree = transformer.transform((int)var6_5, jsonTree);
            v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else if (var22_20 && var6_5 == (transformer = (JacksonMigration)var23_21.value()).currentVersion()) {
            v1 = this.objectMapper().readValue(decompressedBytes, clazz);
        } else if (var22_20 && var6_5 <= (transformer = (JacksonMigration)var23_21.value()).supportedForwardVersion()) {
            jsonTree = this.objectMapper().readTree(decompressedBytes);
            newJsonTree = transformer.transform((int)var6_5, jsonTree);
            v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else {
            v1 = this.objectMapper().readValue(decompressedBytes, clazz);
        }
        result = v1;
        this.logFromBinaryDuration(bytes, decompressedBytes, startTime, clazz);
        return result;
    }

    private void logFromBinaryDuration(byte[] bytes, byte[] decompressBytes, long startTime, Class<?> clazz) {
        if (this.isDebugEnabled()) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == decompressBytes.length) {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
                return;
            }
            this.log().debug("Deserialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)bytes.length), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            return;
        }
    }

    private boolean isCaseObject(String className) {
        return className.length() > 0 && className.charAt(className.length() - 1) == '$';
    }

    private void checkAllowedClassName(String className) {
        if (!this.denyList().isAllowedClassName(className)) {
            String warnMsg = new StringBuilder(100).append("Can't serialize/deserialize object of type [").append(className).append("] in [").append(this.getClass().getName()).append("]. ").append("Disallowed (on deny list) for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.denyList().isAllowedClass(clazz)) {
            String warnMsg = new StringBuilder(86).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Not allowed for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(245).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Only classes that are listed as allowed are allowed for security reasons. ").append("Configure allowed classes with pekko.actor.serialization-bindings or ").append("pekko.serialization.jackson.allowed-class-prefix.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToJacksonSerializer(clazz) || this.hasAllowedClassPrefix(clazz.getName());
    }

    private boolean isBoundToJacksonSerializer(Class<?> clazz) {
        try {
            return this.serialization().serializerFor(clazz) instanceof JacksonSerializer;
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                return false;
            }
            throw throwable;
        }
    }

    private boolean hasAllowedClassPrefix(String className) {
        return this.allowedClassPrefix().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)className.startsWith(x$1)));
    }

    private void checkAllowedSerializationBindings() {
        if (!this.serializationBindingsCheckedOk()) {
            JacksonSerializer$.MODULE$.disallowedSerializationBindings().foreach((Function1 & Serializable & scala.Serializable)clazz -> {
                JacksonSerializer.$anonfun$checkAllowedSerializationBindings$1(this, clazz);
                return BoxedUnit.UNIT;
            });
            this.serializationBindingsCheckedOk_$eq(true);
            return;
        }
    }

    private Tuple2<Object, String> parseManifest(String manifest) {
        int i = manifest.lastIndexOf(35);
        int fromVersion = i == -1 ? 1 : new StringOps(Predef$.MODULE$.augmentString(manifest.substring(i + 1))).toInt();
        String manifestClassName = i == -1 ? manifest : manifest.substring(0, i);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
    }

    public byte[] compress(byte[] bytes) {
        boolean bl = false;
        boolean bl2 = false;
        Compression.Algoritm algoritm = this.compressionAlgorithm();
        if (Compression$Off$.MODULE$.equals(algoritm)) {
            return bytes;
        }
        if (algoritm instanceof Compression.GZip) {
            bl = true;
            long largerThan = ((Compression.GZip)algoritm).largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (bl) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
                zip.write(bytes);
            }
            return bos.toByteArray();
        }
        if (algoritm instanceof Compression.LZ4) {
            bl2 = true;
            long largerThan = ((Compression.LZ4)algoritm).largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (bl2) {
            LZ4Meta meta = JacksonSerializer$LZ4Meta$.MODULE$.apply(bytes);
            byte[] compressed = this.lz4Compressor().compress(bytes);
            return meta.prependTo(compressed);
        }
        throw new MatchError((Object)algoritm);
    }

    public byte[] decompress(byte[] bytes) {
        if (JacksonSerializer$.MODULE$.isGZipped(bytes)) {
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                this.readChunk$1(in, buffer, out);
            }
            finally {
                in.close();
            }
            return out.toByteArray();
        }
        LZ4Meta lZ4Meta = JacksonSerializer$LZ4Meta$.MODULE$.get(bytes);
        LZ4Meta lZ4Meta2 = (LZ4Meta)OptionVal.Some$.MODULE$.unapply((Object)lZ4Meta);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lZ4Meta2)) {
            LZ4Meta meta = (LZ4Meta)OptionVal$.MODULE$.get$extension((Object)lZ4Meta2);
            int srcLen = bytes.length - meta.offset();
            return this.lz4Decompressor().decompress(bytes, meta.offset(), srcLen, meta.length());
        }
        return bytes;
    }

    public static final /* synthetic */ boolean $anonfun$deserializationType$2(JacksonSerializer $this, Tuple2 x$1) {
        return ((Serializer)x$1._2()).identifier() == $this.identifier();
    }

    public static final /* synthetic */ String $anonfun$fromBinary$1(String manifestClassName$1) {
        return manifestClassName$1;
    }

    public static final /* synthetic */ String $anonfun$fromBinary$2(Class x$3) {
        return x$3.getName();
    }

    public static final /* synthetic */ Class $anonfun$fromBinary$3(JacksonSerializer $this, String className$1) {
        Try try_ = $this.system().dynamicAccess().getClassFor(className$1, ClassTag$.MODULE$.AnyRef());
        if (try_ instanceof Success) {
            return (Class)((Success)try_).value();
        }
        if (try_ instanceof Failure) {
            throw new NotSerializableException(new StringBuilder(48).append("Cannot find manifest class [").append(className$1).append("] for serializer [").append($this.getClass().getName()).append("].").toString());
        }
        throw new MatchError((Object)try_);
    }

    private final boolean isBindingOk$1(Class clazz) {
        boolean bl;
        try {
            if (this.serialization().serializerFor(clazz) == this) {
                return false;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                return true;
            }
            throw throwable;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkAllowedSerializationBindings$1(JacksonSerializer $this, Class clazz) {
        if (!$this.isBindingOk$1(clazz)) {
            String warnMsg = new StringBuilder(144).append("For security reasons it's not allowed to bind open-ended interfaces like ").append("[").append(clazz.getName()).append("] to [").append($this.getClass().getName()).append("]. ").append("Change your pekko.actor.serialization-bindings configuration.").toString();
            $this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private final void readChunk$1(GZIPInputStream in$1, byte[] buffer$1, ByteArrayOutputStream out$1) {
        while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    return;
                }
            }
            out$1.write(buffer$1, 0, n);
        }
    }

    public JacksonSerializer(ExtendedActorSystem system, String bindingName, ObjectMapper objectMapper) {
        None$ none$;
        Compression.Algoritm algoritm;
        this.system = system;
        this.bindingName = bindingName;
        this.objectMapper = objectMapper;
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, JacksonSerializer.class, LogSource$.MODULE$.fromAnyClass());
        this.conf = JacksonObjectMapperProvider$.MODULE$.configForBinding(bindingName, system.settings().config());
        this.isDebugEnabled = this.conf().getBoolean("verbose-debug-logging") && this.log().isDebugEnabled();
        String string = Helpers$.MODULE$.toRootLowerCase(this.conf().getString("compression.algorithm"));
        if ("off".equals(string)) {
            algoritm = Compression$Off$.MODULE$;
        } else if ("gzip".equals(string)) {
            Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
            algoritm = new Compression.GZip(Predef$.MODULE$.Long2long(compressLargerThan));
        } else if ("lz4".equals(string)) {
            Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
            algoritm = new Compression.LZ4(Predef$.MODULE$.Long2long(compressLargerThan));
        } else {
            throw new IllegalArgumentException(new StringBuilder(69).append("Unknown compression algorithm [").append(string).append("], possible values are ").append("\"off\" or \"gzip\"").toString());
        }
        this.compressionAlgorithm = algoritm;
        this.migrations = (Map)((TraversableOnce)package.JavaConverters$.MODULE$.mapAsScalaMapConverter(this.conf().getConfig("migrations").root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                Object v = x0$1._2();
                JacksonMigration transformer = (JacksonMigration)this.system().dynamicAccess().createInstanceFor(v.toString(), (scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(JacksonMigration.class)).get();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)transformer);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        this.denyList = new GadgetClassDenyList();
        this.allowedClassPrefix = ((TraversableOnce)package.JavaConverters$.MODULE$.asScalaBufferConverter(this.conf().getStringList("allowed-class-prefix")).asScala()).toVector();
        this.typeInManifest = this.conf().getBoolean("type-in-manifest");
        String string2 = this.conf().getString("deserialization-type");
        if ("".equals(string2)) {
            none$ = None$.MODULE$;
        } else {
            Try try_ = system.dynamicAccess().getClassFor(string2, ClassTag$.MODULE$.AnyRef());
            if (try_ instanceof Success) {
                Class c = (Class)((Success)try_).value();
                none$ = new Some((Object)c);
            } else {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException(new StringBuilder(61).append("Cannot find deserialization-type [").append(string2).append("] for Jackson serializer [").append(bindingName).append("]").toString());
                }
                throw new MatchError((Object)try_);
            }
        }
        this.configuredDeserializationType = none$;
        this.serializationBindingsCheckedOk = false;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig(bindingName, system);
    }

    public static class GadgetClassDenyList
    extends SubTypeValidator {
        private final String prefixSpring;
        private final String prefixC3P0;

        private Set<String> defaultNoDeserClassNames() {
            return SubTypeValidator.DEFAULT_NO_DESER_CLASS_NAMES;
        }

        private String prefixSpring() {
            return this.prefixSpring;
        }

        private String prefixC3P0() {
            return this.prefixC3P0;
        }

        public boolean isAllowedClassName(String className) {
            if (this.defaultNoDeserClassNames().contains(className)) {
                return false;
            }
            return !className.startsWith(this.prefixC3P0()) || !className.endsWith("DataSource");
        }

        public boolean isAllowedClass(Class<?> clazz) {
            if (clazz.getName().startsWith(this.prefixSpring())) {
                return this.isAllowedSpringClass(clazz);
            }
            return true;
        }

        private boolean isAllowedSpringClass(Class<?> clazz) {
            while (clazz != null && !clazz.equals(Object.class)) {
                String name = clazz.getSimpleName();
                if ("AbstractPointcutAdvisor".equals(name) || "AbstractApplicationContext".equals(name)) {
                    return false;
                }
                clazz = clazz.getSuperclass();
            }
            return true;
        }

        public GadgetClassDenyList() {
            this.prefixSpring = "org.springframework.";
            this.prefixC3P0 = "com.mchange.v2.c3p0.";
        }
    }

    public static final class LZ4Meta
    implements Product,
    scala.Serializable {
        private final int offset;
        private final int length;

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }

        public void putInto(ByteBuffer buffer) {
            buffer.putInt(JacksonSerializer$LZ4Meta$.MODULE$.LZ4_MAGIC());
            buffer.putInt(this.length());
        }

        public byte[] prependTo(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.offset());
            this.putInto(buffer);
            buffer.put(bytes);
            return buffer.array();
        }

        public LZ4Meta copy(int offset, int length) {
            return new LZ4Meta(offset, length);
        }

        public int copy$default$1() {
            return this.offset();
        }

        public int copy$default$2() {
            return this.length();
        }

        public String productPrefix() {
            return "LZ4Meta";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.offset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.length());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LZ4Meta;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.offset()), (int)this.length()), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof LZ4Meta)) break block3;
                    LZ4Meta lZ4Meta = (LZ4Meta)x$1;
                    if (this.offset() != lZ4Meta.offset() || this.length() != lZ4Meta.length()) break block3;
                }
                return true;
            }
            return false;
        }

        public LZ4Meta(int offset, int length) {
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }
}

