/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.plguin.jdbc.api.model.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public enum TableType {
    TABLE("TABLE"),
    VIEW("VIEW"),
    SYSTEM_TABLE("SYSTEM TABLE"),
    SYSTEM_VIEW("SYSTEM VIEW"),
    GLOBAL_TEMPORARY("GLOBAL TEMPORARY"),
    LOCAL_TEMPORARY("LOCAL TEMPORARY"),
    ALIAS("ALIAS"),
    SYNONYM("SYNONYM");

    private static final Map<String, TableType> TYPE_MAP;
    @JsonValue
    private final String typeName;

    private TableType(String typeName) {
        this.typeName = typeName;
    }

    public static TableType fromTypeName(String typeNameString) {
        if (!TYPE_MAP.containsKey(typeNameString)) {
            throw new IllegalArgumentException("Unknown table type: " + typeNameString);
        }
        return TYPE_MAP.get(typeNameString);
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    static {
        TYPE_MAP = Arrays.stream(TableType.values()).collect(Collectors.toMap(TableType::getTypeName, tableType -> tableType));
    }
}

