/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.datasource.config;

import cn.sliew.carp.framework.common.dict.datasource.DataSourceType;
import cn.sliew.carp.module.datasource.config.CarpGravitinoProperties;
import cn.sliew.carp.module.datasource.service.CarpDsInfoService;
import cn.sliew.carp.module.datasource.service.CarpGravitinoMetalakeService;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CarpGravitinoInitializer
implements InitializingBean {
    @Autowired
    private CarpGravitinoProperties properties;
    @Autowired
    private CarpDsInfoService carpDsInfoService;
    @Autowired
    private CarpGravitinoMetalakeService gravitinoMetalakeService;

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    private void initialize() {
        this.initMetalake(this.properties.getMetalake());
        this.initDataSource(this.properties.getMetalake(), DataSourceType.MYSQL);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.POSTGRESQL);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.HIVE);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.ICEBERG);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.DORIS);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.KAFKA);
        this.initDataSource(this.properties.getMetalake(), DataSourceType.HDFS);
    }

    private void initMetalake(String metalakeName) {
        this.gravitinoMetalakeService.tryAddMetalake(metalakeName);
    }

    private void initDataSource(String metalakeName, DataSourceType type) {
        List<DsInfoDTO> dsInfoDTOS = this.carpDsInfoService.listByType(type);
        for (DsInfoDTO dsInfoDTO : dsInfoDTOS) {
            this.gravitinoMetalakeService.tryAddCatalog(metalakeName, dsInfoDTO);
        }
    }
}

