/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.plugin.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpUtil;
import cn.sliew.carp.framework.common.dict.common.YesOrNo;
import cn.sliew.carp.framework.common.dict.plugin.PluginType;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.framework.common.nio.FileUtil;
import cn.sliew.carp.framework.mybatis.entity.BaseDO;
import cn.sliew.carp.framework.spring.util.SystemUtil;
import cn.sliew.carp.module.plugin.repository.entity.CarpPlugin;
import cn.sliew.carp.module.plugin.repository.mapper.CarpPluginMapper;
import cn.sliew.carp.module.plugin.service.Pf4jService;
import cn.sliew.carp.module.plugin.service.PluginService;
import cn.sliew.carp.module.plugin.service.convert.CarpPluginConvert;
import cn.sliew.carp.module.plugin.service.dto.CarpPluginDTO;
import cn.sliew.carp.module.plugin.service.param.CarpPluginAddParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginListParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginPageParam;
import cn.sliew.carp.module.plugin.service.param.CarpPluginUpdateParam;
import cn.sliew.milky.common.check.Ensures;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PluginServiceImpl
extends ServiceImpl<CarpPluginMapper, CarpPlugin>
implements PluginService {
    @Autowired
    private Pf4jService pf4jService;

    @Override
    public PageResult<CarpPluginDTO> list(CarpPluginPageParam param) {
        Page page = new Page(param.getCurrent().longValue(), param.getPageSize().longValue());
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPlugin.class).like(StringUtils.hasText((String)param.getName()), CarpPlugin::getName, (Object)param.getName())).eq(param.getType() != null, CarpPlugin::getType, (Object)param.getType())).eq(param.getStatus() != null, CarpPlugin::getStatus, (Object)param.getStatus())).orderByAsc(BaseDO::getId);
        Page secRolePage = (Page)this.page((IPage)page, (Wrapper)queryChainWrapper);
        PageResult pageResult = new PageResult(Long.valueOf(secRolePage.getCurrent()), Long.valueOf(secRolePage.getSize()), Long.valueOf(secRolePage.getTotal()));
        pageResult.setRecords(CarpPluginConvert.INSTANCE.toDto(secRolePage.getRecords()));
        return pageResult;
    }

    @Override
    public List<CarpPluginDTO> listAll(CarpPluginListParam param) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPlugin.class).like(StringUtils.hasText((String)param.getName()), CarpPlugin::getName, (Object)param.getName())).eq(param.getType() != null, CarpPlugin::getType, (Object)param.getType())).eq(param.getStatus() != null, CarpPlugin::getStatus, (Object)param.getStatus())).orderByAsc(BaseDO::getId);
        List entities = this.list((Wrapper)queryChainWrapper);
        return CarpPluginConvert.INSTANCE.toDto(entities);
    }

    @Override
    public CarpPluginDTO get(Long id) {
        CarpPlugin entity = (CarpPlugin)((Object)this.getOptById(id).orElseThrow(() -> new IllegalArgumentException("plugin not exists for id: " + id)));
        return (CarpPluginDTO)((Object)CarpPluginConvert.INSTANCE.toDto((Object)entity));
    }

    @Override
    public Optional<CarpPluginDTO> getByPluginId(String pluginId) {
        LambdaQueryWrapper queryChainWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(CarpPlugin.class).eq(CarpPlugin::getPluginId, (Object)pluginId);
        return this.getOneOpt((Wrapper)queryChainWrapper).map(arg_0 -> ((CarpPluginConvert)CarpPluginConvert.INSTANCE).toDto(arg_0));
    }

    @Override
    public boolean add(CarpPluginAddParam param) {
        CarpPlugin entity = (CarpPlugin)((Object)BeanUtil.copyProperties((Object)param, CarpPlugin.class, (String[])new String[0]));
        entity.setType(PluginType.INTERNAL);
        entity.setStatus(YesOrNo.NO);
        return this.save((Object)entity);
    }

    @Override
    public boolean update(CarpPluginUpdateParam param) {
        CarpPluginDTO dto = this.get(param.getId());
        Ensures.checkState((dto.getStatus() == YesOrNo.NO ? 1 : 0) != 0, () -> "plugin already enabled, please disable it firstly");
        CarpPlugin entity = (CarpPlugin)((Object)BeanUtil.copyProperties((Object)param, CarpPlugin.class, (String[])new String[0]));
        return this.updateById((Object)entity);
    }

    @Override
    public boolean updateStatus(String pluginId, YesOrNo status) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CarpPlugin.class).eq(CarpPlugin::getPluginId, (Object)pluginId)).set(CarpPlugin::getStatus, (Object)status);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public boolean delete(Long id) {
        return this.removeById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, transactionManager="carpTransactionManager")
    public boolean deleteBatch(Collection<Long> ids) {
        return this.removeByIds(ids);
    }

    @Override
    public Path internalDownloadPlugin(CarpPluginDTO dto) throws IOException {
        Path path = FileUtil.createFile((Path)SystemUtil.getPluginsPath(), (String)FilenameUtils.getName((String)dto.getUrl()));
        HttpUtil.downloadFileFromUrl((String)dto.getUrl(), (String)path.toAbsolutePath().toFile().getAbsolutePath());
        return path;
    }

    @Override
    public boolean enable(Long id) {
        Path path = null;
        try {
            path = this.internalDownloadPlugin(this.get(id));
            String pluginId = this.pf4jService.loadPlugin(path);
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CarpPlugin.class).eq(BaseDO::getId, (Object)id)).set(CarpPlugin::getPluginId, (Object)pluginId);
            this.update((Wrapper)updateWrapper);
            return this.pf4jService.enablePlugin(pluginId);
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (path != null) {
                try {
                    FileUtil.deleteFile((Path)path);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean disable(Long id) {
        CarpPluginDTO dto = this.get(id);
        this.pf4jService.disablePlugin(dto.getPluginId());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CarpPlugin.class).eq(BaseDO::getId, (Object)id)).set(CarpPlugin::getPluginId, null);
        return this.update((Wrapper)updateWrapper);
    }
}

