/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.queue.api;

import cn.sliew.carp.module.queue.api.MessageHandler;
import cn.sliew.carp.module.queue.api.MessageListener;
import cn.sliew.carp.module.queue.api.QueueFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Component;

@Component
public class MessageListenerBeanPostProcessor
implements ApplicationContextAware,
BeanPostProcessor,
InitializingBean,
SmartLifecycle {
    private ApplicationContext applicationContext;
    private QueueFactory queueFactory;
    private boolean running = false;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.queueFactory = (QueueFactory)this.applicationContext.getBean(QueueFactory.class);
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
        }
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MessageListener ann;
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (MessageHandler.class.isAssignableFrom(targetClass) && (ann = targetClass.getAnnotation(MessageListener.class)) != null) {
            String topic = ann.topic();
            String consumerGroup = ann.consumerGroup();
            this.queueFactory.get(topic).register(consumerGroup, (MessageHandler)bean);
        }
        return bean;
    }
}

