/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection;

import cn.sliew.carp.framework.common.reflection.AbstractJobDetailsFinder;
import cn.sliew.carp.framework.common.reflection.JavaJobDetailsBuilder;
import cn.sliew.carp.framework.common.reflection.JobDetailsGeneratorUtils;
import cn.sliew.carp.framework.common.reflection.lambdas.JobRunrJob;
import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class JavaJobDetailsFinder
extends AbstractJobDetailsFinder {
    private final JobRunrJob jobRunrJob;
    private final SerializedLambda serializedLambda;
    private final boolean isLambda;

    JavaJobDetailsFinder(JobRunrJob jobRunrJob, SerializedLambda serializedLambda, Object ... params) {
        super(new JavaJobDetailsBuilder(serializedLambda, params));
        this.jobRunrJob = jobRunrJob;
        this.serializedLambda = serializedLambda;
        boolean bl = this.isLambda = serializedLambda.getImplMethodName().startsWith("lambda$") || serializedLambda.getImplMethodName().contains("$lambda-") || serializedLambda.getImplMethodName().contains("$lambda$");
        if (this.isLambda) {
            try (InputStream classContainingLambdaInputStream = this.getClassContainingLambdaAsInputStream();){
                this.parse(classContainingLambdaInputStream);
            }
            catch (IOException e) {
                Rethrower.throwAs((Throwable)e);
            }
        } else if (serializedLambda.getCapturedArgCount() == 1 && Arrays.stream(serializedLambda.getCapturedArg(0).getClass().getAnnotations()).anyMatch(ann -> "kotlin.Metadata".equals(ann.annotationType().getName()))) {
            this.jobDetailsBuilder.setClassName(serializedLambda.getCapturedArg(0).getClass().getName());
            this.jobDetailsBuilder.setMethodName(serializedLambda.getImplMethodName().contains("$") ? StringUtils.substringAfter((String)serializedLambda.getImplMethodName(), (String)"$") : serializedLambda.getImplMethodName());
        }
    }

    @Override
    protected boolean isLambdaContainingJobDetails(String name) {
        return this.isLambda && name.equals(this.serializedLambda.getImplMethodName());
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return JobDetailsGeneratorUtils.getJavaClassContainingLambdaAsInputStream(this.jobRunrJob);
    }
}

