/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.reflection;

import cn.sliew.carp.framework.common.reflection.JobParameter;
import cn.sliew.carp.framework.common.util.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JobDetails {
    private final String className;
    private final String staticFieldName;
    private final String methodName;
    private final ArrayList<JobParameter> jobParameters;
    private Boolean cacheable;

    private JobDetails() {
        this(null, null, null, null);
    }

    public JobDetails(String className, String staticFieldName, String methodName, List<JobParameter> jobParameters) {
        this.className = className;
        this.staticFieldName = staticFieldName;
        this.methodName = methodName;
        this.jobParameters = new ArrayList<JobParameter>(jobParameters);
        this.cacheable = false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getStaticFieldName() {
        return this.staticFieldName;
    }

    public boolean hasStaticFieldName() {
        return this.staticFieldName != null;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<JobParameter> getJobParameters() {
        return Collections.unmodifiableList(this.jobParameters);
    }

    public Class[] getJobParameterTypes() {
        return (Class[])this.jobParameters.stream().map(JobParameter::getClassName).map(ReflectionUtils::toClass).toArray(Class[]::new);
    }

    public Object[] getJobParameterValues() {
        return this.jobParameters.stream().map(JobParameter::getObject).toArray();
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }
}

