/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.common.util;

import cn.sliew.milky.common.exception.Rethrower;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public final class NetUtil
extends Enum<NetUtil> {
    private static final String ETHERNET_PREFIX = "eth";
    private static final String MAC_ETHERNET_PREFIX = "en";
    private static final String WIRELESS_LAN_PREFIX = "wlp";
    private static final String[] LOCAL_IPS;
    public static InetAddress localAddress;
    private static final /* synthetic */ NetUtil[] $VALUES;

    public static NetUtil[] values() {
        return (NetUtil[])$VALUES.clone();
    }

    public static NetUtil valueOf(String name) {
        return Enum.valueOf(NetUtil.class, name);
    }

    public static InetAddress getLocalInetAddress() throws SocketException {
        if (localAddress != null) {
            return localAddress;
        }
        List<NetworkInterface> networkInterfaces = NetUtil.getNetworkInterfaces();
        NetworkInterface ni = NetUtil.getByEthPrefix(networkInterfaces).or(() -> NetUtil.getByEnPrefix(networkInterfaces)).or(() -> NetUtil.getByWlpPrefix(networkInterfaces)).or(() -> NetUtil.getByFirst(networkInterfaces)).orElseThrow();
        if (ni != null) {
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isAnyLocalAddress()) continue;
                try {
                    if (!address.isSiteLocalAddress() || !address.isReachable(1000)) continue;
                    return address;
                }
                catch (IOException iOException) {
                }
            }
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost;
        }
        catch (Exception e) {
            throw new RuntimeException("No validated local address!");
        }
    }

    private static Optional<NetworkInterface> getByEthPrefix(List<NetworkInterface> networkInterfaces) {
        return networkInterfaces.stream().filter(networkInterface -> networkInterface.getName().startsWith(ETHERNET_PREFIX)).findAny();
    }

    private static Optional<NetworkInterface> getByEnPrefix(List<NetworkInterface> networkInterfaces) {
        return networkInterfaces.stream().filter(networkInterface -> networkInterface.getName().startsWith(MAC_ETHERNET_PREFIX)).sorted(Comparator.comparingLong(NetworkInterface::getIndex).reversed()).findFirst();
    }

    private static Optional<NetworkInterface> getByWlpPrefix(List<NetworkInterface> networkInterfaces) {
        return networkInterfaces.stream().filter(networkInterface -> networkInterface.getName().startsWith(WIRELESS_LAN_PREFIX)).findAny();
    }

    private static Optional<NetworkInterface> getByFirst(List<NetworkInterface> networkInterfaces) {
        return networkInterfaces.stream().sorted(Comparator.comparingLong(NetworkInterface::getIndex).reversed()).findFirst().filter(Objects::nonNull).or(() -> networkInterfaces.stream().findAny());
    }

    private static List<NetworkInterface> getNetworkInterfaces() throws SocketException {
        ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
        while (enu.hasMoreElements()) {
            NetworkInterface ni = enu.nextElement();
            if (ni.isLoopback() || !ni.isUp() || ni.isVirtual()) continue;
            networkInterfaces.add(ni);
        }
        return networkInterfaces;
    }

    public static String getLocalAddress() {
        return localAddress.getHostAddress();
    }

    public static String getLocalIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }

    private static String bytesToMac(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'd', 'f'};
        StringJoiner stringJoiner = new StringJoiner(":");
        for (byte aByte : bytes) {
            char left = chars[(aByte & 0xF0) >> 4];
            char right = chars[aByte & 0xF];
            stringJoiner.add(new String(new char[]{left, right}));
        }
        return stringJoiner.toString();
    }

    public static String replaceLocalhost(String endpoint) {
        String result = endpoint;
        try {
            InetAddress publicAddress;
            URI uri = URI.create(endpoint);
            String host = uri.getHost();
            InetAddress inetAddress = InetAddress.getByName(host);
            if ((inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress()) && NetUtil.validateInetAddress(publicAddress = NetUtil.getLocalInetAddress())) {
                URI res = new URI(uri.getScheme(), uri.getUserInfo(), publicAddress.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                result = res.toString();
            }
        }
        catch (Exception e) {
            try {
                InetAddress publicAddress = NetUtil.getLocalInetAddress();
                if (NetUtil.validateInetAddress(publicAddress)) {
                    for (String localIp : LOCAL_IPS) {
                        if (!result.contains(localIp)) continue;
                        result = result.replace(localIp, publicAddress.getHostAddress());
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean validateInetAddress(InetAddress inetAddress) {
        return !inetAddress.isLinkLocalAddress() && !inetAddress.isLoopbackAddress() && !inetAddress.isAnyLocalAddress();
    }

    private static /* synthetic */ NetUtil[] $values() {
        return new NetUtil[0];
    }

    static {
        $VALUES = NetUtil.$values();
        LOCAL_IPS = new String[]{"localhost", "127.0.0.1", "0.0.0.0"};
        try {
            localAddress = NetUtil.getLocalInetAddress();
        }
        catch (SocketException e) {
            throw new RuntimeException("fail to get local ip.", e);
        }
    }
}

