/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.dag.service.convert;

import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.carp.framework.dag.repository.entity.DagInstance;
import cn.sliew.carp.framework.dag.service.dto.DagConfigComplexDTO;
import cn.sliew.carp.framework.dag.service.dto.DagInstanceDTO;
import cn.sliew.milky.common.util.JacksonUtil;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface DagInstanceConvert
extends BaseConvert<DagInstance, DagInstanceDTO> {
    public static final DagInstanceConvert INSTANCE = (DagInstanceConvert)Mappers.getMapper(DagInstanceConvert.class);

    default public DagInstance toDo(DagInstanceDTO dto) {
        DagInstance entity = new DagInstance();
        BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        if (dto.getDagConfig() != null) {
            entity.setDagConfigId(dto.getDagConfig().getId());
        }
        if (dto.getInputs() != null) {
            entity.setInputs(dto.getInputs().toString());
        }
        if (dto.getOutputs() != null) {
            entity.setOutputs(dto.getOutputs().toString());
        }
        return entity;
    }

    default public DagInstanceDTO toDto(DagInstance entity) {
        DagInstanceDTO dto = new DagInstanceDTO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        DagConfigComplexDTO dagConfig = new DagConfigComplexDTO();
        dagConfig.setId(entity.getDagConfigId());
        dto.setDagConfig(dagConfig);
        if (StringUtils.hasText((String)entity.getInputs())) {
            dto.setInputs(JacksonUtil.toJsonNode((String)entity.getInputs()));
        }
        if (StringUtils.hasText((String)entity.getOutputs())) {
            dto.setOutputs(JacksonUtil.toJsonNode((String)entity.getOutputs()));
        }
        return dto;
    }
}

