/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.snapshot.dao;

import java.io.Serializable;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.persistence.SnapshotMetadata;
import org.apache.pekko.persistence.SnapshotMetadata$;
import org.apache.pekko.persistence.jdbc.PekkoSerialization$;
import org.apache.pekko.persistence.jdbc.config.SnapshotConfig;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotDao;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotQueries;
import org.apache.pekko.persistence.jdbc.snapshot.dao.SnapshotTables;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.stream.Materializer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Success;
import scala.util.Try;
import slick.dbio.DBIOAction;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.RunnableCompiled;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\r\u001a\u0001!B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003,\u0001\u0005\u000b\u0007I1A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\u0006_\u0002!I\u0001\u001d\u0005\b\u0003+\u0001A\u0011BA\f\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t)\u000b\u0001C!\u0003OCq!a+\u0001\t\u0003\ni\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\n\u0011B)\u001a4bk2$8K\\1qg\"|G\u000fR1p\u0015\tQ2$A\u0002eC>T!\u0001H\u000f\u0002\u0011Mt\u0017\r]:i_RT!AH\u0010\u0002\t)$'m\u0019\u0006\u0003A\u0005\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011!eI\u0001\u0006a\u0016\\7n\u001c\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aEj\u0011!G\u0005\u0003ee\u00111b\u00158baNDw\u000e\u001e#b_\u0006\u0011AM\u0019\t\u0003kq\u0002\"A\u000e\u001e\u000e\u0003]R!A\b\u001d\u000b\u0003e\nQa\u001d7jG.L!aO\u001c\u0003\u0017)#'m\u0019\"bG.,g\u000eZ\u0005\u0003{i\u0012qB\u00133cG\u0012\u000bG/\u00192bg\u0016$UMZ\u0001\baJ|g-\u001b7f!\t1\u0004)\u0003\u0002Bo\tY!\n\u001a2d!J|g-\u001b7f\u00039\u0019h.\u00199tQ>$8i\u001c8gS\u001e\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u000f\u0002\r\r|gNZ5h\u0013\tAUI\u0001\bT]\u0006\u00048\u000f[8u\u0007>tg-[4\u0002\u001bM,'/[1mSj\fG/[8o!\tYU*D\u0001M\u0015\tI\u0015%\u0003\u0002O\u0019\ni1+\u001a:jC2L'0\u0019;j_:\f!!Z2\u0011\u0005E#V\"\u0001*\u000b\u0005M[\u0013AC2p]\u000e,(O]3oi&\u0011QK\u0015\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!\\1u+\u0005A\u0006CA-]\u001b\u0005Q&BA.\"\u0003\u0019\u0019HO]3b[&\u0011QL\u0017\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u0005[\u0006$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006C\u00164w\r\u001b\u000b\u0004E\u000e$\u0007C\u0001\u0019\u0001\u0011\u0015y\u0005\u0002q\u0001Q\u0011\u00151\u0006\u0002q\u0001Y\u0011\u0015\u0019\u0004\u00021\u00015\u0011\u0015q\u0004\u00021\u0001@\u0011\u0015\u0011\u0005\u00021\u0001D\u0011\u0015I\u0005\u00021\u0001K\u0003\u001d\tX/\u001a:jKN,\u0012a\u001b\t\u0003a1L!!\\\r\u0003\u001fMs\u0017\r]:i_R\fV/\u001a:jKN\f\u0001\"];fe&,7\u000fI\u0001\u000fi>\u001cf.\u00199tQ>$H)\u0019;b)\r\t\u00181\u0001\t\u0004eV<X\"A:\u000b\u0005Q\\\u0013\u0001B;uS2L!A^:\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003+qjt\u0018BA=,\u0005\u0019!V\u000f\u001d7feA\u00111\u0010`\u0007\u0002?%\u0011Qp\b\u0002\u0011':\f\u0007o\u001d5pi6+G/\u00193bi\u0006\u0004\"AK@\n\u0007\u0005\u00051FA\u0002B]fDq!!\u0002\f\u0001\u0004\t9!A\u0002s_^\u0004B!!\u0003\u0002\u00109\u0019\u0001'a\u0003\n\u0007\u00055\u0011$\u0001\bT]\u0006\u00048\u000f[8u)\u0006\u0014G.Z:\n\t\u0005E\u00111\u0003\u0002\f':\f\u0007o\u001d5piJ{wOC\u0002\u0002\u000ee\t\u0011c]3sS\u0006d\u0017N_3T]\u0006\u00048\u000f[8u)\u0019\tI\"a\u0007\u0002 A!!/^A\u0004\u0011\u0019\ti\u0002\u0004a\u0001u\u0006!Q.\u001a;b\u0011\u0015aB\u00021\u0001\u007f\u0003EQXM]8Pe>sWm\u00158baNDw\u000e\u001e\u000b\u0005\u0003K\tY\u0003\u0005\u0003+\u0003O9\u0018bAA\u0015W\t1q\n\u001d;j_:Dq!!\f\u000e\u0001\u0004\ty#\u0001\u0003s_^\u001c\bCBA\u0019\u0003\u0003\n9A\u0004\u0003\u00024\u0005ub\u0002BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005er%\u0001\u0004=e>|GOP\u0005\u0002Y%\u0019\u0011qH\u0016\u0002\u000fA\f7m[1hK&!\u00111IA#\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u007fY\u0013A\u00047bi\u0016\u001cHo\u00158baNDw\u000e\u001e\u000b\u0005\u0003\u0017\n\t\u0006E\u0003R\u0003\u001b\n)#C\u0002\u0002PI\u0013aAR;ukJ,\u0007bBA*\u001d\u0001\u0007\u0011QK\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\u0011\t\u0005]\u0013q\f\b\u0005\u00033\nY\u0006E\u0002\u00026-J1!!\u0018,\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\u0019\u0019FO]5oO*\u0019\u0011QL\u0016\u0002/Mt\u0017\r]:i_R4uN]'bqRKW.Z:uC6\u0004HCBA&\u0003S\nY\u0007C\u0004\u0002T=\u0001\r!!\u0016\t\u000f\u00055t\u00021\u0001\u0002p\u0005aQ.\u0019=US6,7\u000f^1naB\u0019!&!\u001d\n\u0007\u0005M4F\u0001\u0003M_:<\u0017\u0001G:oCB\u001c\bn\u001c;G_Jl\u0015\r_*fcV,gnY3OeR1\u00111JA=\u0003wBq!a\u0015\u0011\u0001\u0004\t)\u0006C\u0004\u0002~A\u0001\r!a\u001c\u0002\u001b5\f\u0007pU3rk\u0016t7-\u001a(s\u0003\u001d\u001ah.\u00199tQ>$hi\u001c:NCb\u001cV-];f]\u000e,gJ]!oI6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u0011\u0005-\u00131QAC\u0003\u000fCq!a\u0015\u0012\u0001\u0004\t)\u0006C\u0004\u0002~E\u0001\r!a\u001c\t\u000f\u00055\u0014\u00031\u0001\u0002p\u0005!1/\u0019<f)\u0019\ti)!&\u0002\u001aB)\u0011+!\u0014\u0002\u0010B\u0019!&!%\n\u0007\u0005M5F\u0001\u0003V]&$\bBBAL%\u0001\u0007!0\u0001\tt]\u0006\u00048\u000f[8u\u001b\u0016$\u0018\rZ1uC\")AD\u0005a\u0001}\u00061A-\u001a7fi\u0016$b!!$\u0002 \u0006\u0005\u0006bBA*'\u0001\u0007\u0011Q\u000b\u0005\b\u0003G\u001b\u0002\u0019AA8\u0003)\u0019X-];f]\u000e,gJ]\u0001\u0013I\u0016dW\r^3BY2\u001cf.\u00199tQ>$8\u000f\u0006\u0003\u0002\u000e\u0006%\u0006bBA*)\u0001\u0007\u0011QK\u0001\u0018I\u0016dW\r^3VaR{W*\u0019=TKF,XM\\2f\u001dJ$b!!$\u00020\u0006E\u0006bBA*+\u0001\u0007\u0011Q\u000b\u0005\b\u0003{*\u0002\u0019AA8\u0003Y!W\r\\3uKV\u0003Hk\\'bqRKW.Z:uC6\u0004HCBAG\u0003o\u000bI\fC\u0004\u0002TY\u0001\r!!\u0016\t\u000f\u00055d\u00031\u0001\u0002p\u00051C-\u001a7fi\u0016,\u0006\u000fV8NCb\u001cV-];f]\u000e,gJ]!oI6\u000b\u0007\u0010V5nKN$\u0018-\u001c9\u0015\u0011\u00055\u0015qXAa\u0003\u0007Dq!a\u0015\u0018\u0001\u0004\t)\u0006C\u0004\u0002~]\u0001\r!a\u001c\t\u000f\u00055t\u00031\u0001\u0002p\u0001")
public class DefaultSnapshotDao
implements SnapshotDao {
    private final JdbcBackend.JdbcDatabaseDef db;
    private final JdbcProfile profile;
    private final Serialization serialization;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final SnapshotQueries queries;

    public Materializer mat() {
        return this.mat;
    }

    public SnapshotQueries queries() {
        return this.queries;
    }

    private Try<Tuple2<SnapshotMetadata, Object>> toSnapshotData(SnapshotTables.SnapshotRow row) {
        return this.serialization.deserialize(row.snapshotPayload(), row.snapshotSerId(), row.snapshotSerManifest()).flatMap((Function1 & Serializable & scala.Serializable)snapshot -> {
            Tuple2 tuple2;
            Option metadata = row.metaPayload().flatMap((Function1 & Serializable & scala.Serializable)mPayload -> row.metaSerId().map((Function1 & Serializable & scala.Serializable)mSerId -> DefaultSnapshotDao.$anonfun$toSnapshotData$3(mPayload, BoxesRunTime.unboxToInt((Object)mSerId))));
            if (None$.MODULE$.equals(metadata)) {
                return new Success((Object)new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created()), snapshot));
            }
            if (metadata instanceof Some && (tuple2 = (Tuple2)((Some)metadata).value()) != null) {
                byte[] payload = (byte[])tuple2._1();
                int id = tuple2._2$mcI$sp();
                return $this.serialization.deserialize(payload, id, (String)row.metaSerManifest().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).map((Function1 & Serializable & scala.Serializable)meta -> new Tuple2((Object)SnapshotMetadata$.MODULE$.apply(row.persistenceId(), row.sequenceNumber(), row.created(), (Option)new Some(meta)), snapshot));
            }
            throw new MatchError((Object)metadata);
        });
    }

    private Try<SnapshotTables.SnapshotRow> serializeSnapshot(SnapshotMetadata meta, Object snapshot) {
        Option serializedMetadata = meta.metadata().flatMap((Function1 & Serializable & scala.Serializable)m -> PekkoSerialization$.MODULE$.serialize($this.serialization, m).toOption());
        return PekkoSerialization$.MODULE$.serialize(this.serialization, snapshot).map((Function1 & Serializable & scala.Serializable)serializedSnapshot -> new SnapshotTables.SnapshotRow(meta.persistenceId(), meta.sequenceNr(), meta.timestamp(), serializedSnapshot.serId(), serializedSnapshot.serManifest(), serializedSnapshot.payload(), (Option<Object>)serializedMetadata.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.serId())), (Option<String>)serializedMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.serManifest()), (Option<byte[]>)serializedMetadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.payload())));
    }

    private Option<Tuple2<SnapshotMetadata, Object>> zeroOrOneSnapshot(Seq<SnapshotTables.SnapshotRow> rows) {
        return rows.headOption().map((Function1 & Serializable & scala.Serializable)row -> (Tuple2)this.toSnapshotData((SnapshotTables.SnapshotRow)row).get());
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> latestSnapshot(String persistenceId) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectLatestByPersistenceId().apply((Object)persistenceId))).result()).flatMap((Function1 & Serializable & scala.Serializable)rows -> {
            Option option = rows.headOption();
            if (option instanceof Some) {
                SnapshotTables.SnapshotRow row = (SnapshotTables.SnapshotRow)((Some)option).value();
                return Future$.MODULE$.fromTry(this.toSnapshotData(row)).map((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.apply(x$4), $this.ec);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable & scala.Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr))))).result()).map((Function1 & Serializable & scala.Serializable)rows -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)rows), this.ec);
    }

    @Override
    public Future<Option<Tuple2<SnapshotMetadata, Object>>> snapshotForMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)((JdbcActionComponent.JdbcStreamingQueryActionExtensionMethodsImpl)this.profile.api().streamableAppliedCompiledFunctionActionExtensionMethods(this.queries().selectOneByPersistenceIdAndMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp))))).result()).map((Function1 & Serializable & scala.Serializable)x$5 -> this.zeroOrOneSnapshot((Seq<SnapshotTables.SnapshotRow>)x$5), this.ec);
    }

    @Override
    public Future<BoxedUnit> save(SnapshotMetadata snapshotMetadata, Object snapshot) {
        return Future$.MODULE$.fromTry(this.serializeSnapshot(snapshotMetadata, snapshot)).map((Function1 & Serializable & scala.Serializable)snapshotRow -> this.queries().insertOrUpdate((SnapshotTables.SnapshotRow)snapshotRow), this.ec).flatMap((Function1 & Serializable & scala.Serializable)a -> $this.db.run(a), this.ec).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> delete(String persistenceId, long sequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdAndSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteAllSnapshots(String persistenceId) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectAll().apply((Object)persistenceId)).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNr(String persistenceId, long maxSequenceNr) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNr().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxTimestamp(String persistenceId, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxTimestamp().apply((Object)new Tuple2((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    @Override
    public Future<BoxedUnit> deleteUpToMaxSequenceNrAndMaxTimestamp(String persistenceId, long maxSequenceNr, long maxTimestamp) {
        return this.db.run((DBIOAction)this.profile.api().runnableCompiledDeleteActionExtensionMethods((RunnableCompiled)this.queries().selectByPersistenceIdUpToMaxSequenceNrAndMaxTimestamp().apply((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)maxSequenceNr), (Object)BoxesRunTime.boxToLong((long)maxTimestamp)))).delete()).map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> {}, ExecutionContexts$.MODULE$.parasitic());
    }

    public static final /* synthetic */ Tuple2 $anonfun$toSnapshotData$3(byte[] mPayload$1, int mSerId) {
        return new Tuple2((Object)mPayload$1, (Object)BoxesRunTime.boxToInteger((int)mSerId));
    }

    public DefaultSnapshotDao(JdbcBackend.JdbcDatabaseDef db, JdbcProfile profile, SnapshotConfig snapshotConfig, Serialization serialization, ExecutionContext ec, Materializer mat) {
        this.db = db;
        this.profile = profile;
        this.serialization = serialization;
        this.ec = ec;
        this.mat = mat;
        this.queries = new SnapshotQueries(profile, snapshotConfig.snapshotTableConfiguration());
    }
}

