/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch.affinity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.AbstractBoundedNodeQueue;
import org.apache.pekko.dispatch.affinity.AffinityPool$;
import org.apache.pekko.dispatch.affinity.OnSpinWait;
import org.apache.pekko.dispatch.affinity.QueueSelector;
import org.apache.pekko.dispatch.affinity.RejectionHandler;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.util.ReentrantGuard;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5xAB+W\u0011\u00031\u0006M\u0002\u0004c-\"\u0005ak\u0019\u0005\u0006U\u0006!\t\u0001\\\u0003\u0005[\u0006\u0001a\u000eC\u0004r\u0003\t\u0007IQ\u0001:\t\rU\f\u0001\u0015!\u0004t\u0011\u001d1\u0018A1A\u0005\u0006]DaA_\u0001!\u0002\u001bA\bbB>\u0002\u0005\u0004%)\u0001 \u0005\u0007\u007f\u0006\u0001\u000bQB?\t\u0013\u0005\u0005\u0011A1A\u0005\u0006\u0005\r\u0001\u0002CA\u0005\u0003\u0001\u0006i!!\u0002\t\u0013\u0005-\u0011A1A\u0005\u0006\u00055\u0001\u0002CA\n\u0003\u0001\u0006i!a\u0004\t\u0013\u0005U\u0011A1A\u0005\u0006\u0005]\u0001\u0002CA\u000f\u0003\u0001\u0006i!!\u0007\u0006\u000b\u0005}\u0011\u0001\u00018\t\u0011\u0005\u0005\u0012A1A\u0005\u0006IDq!a\t\u0002A\u000351\u000f\u0003\u0005\u0002&\u0005\u0011\r\u0011\"\u0002x\u0011\u001d\t9#\u0001Q\u0001\u000eaD\u0001\"!\u000b\u0002\u0005\u0004%)\u0001 \u0005\b\u0003W\t\u0001\u0015!\u0004~\u0011%\ti#\u0001b\u0001\n\u000b\t\u0019\u0001\u0003\u0005\u00020\u0005\u0001\u000bQBA\u0003\r\u0019\t\t$\u0001\u0004\u00024!I\u0011QG\r\u0003\u0002\u0003\u0006IA\u001c\u0005\u0007Uf!\t!a\u000e\t\u000f\u0005}\u0012\u0004)A\u0005]\"9\u0011\u0011I\r!\u0002\u0013q\u0007bBA\"3\u0001\u0006IA\u001c\u0005\t\u0003\u000bJ\u0002\u0015!\u0003\u0002H!A\u0011QJ\r!B\u0013\ty\u0005\u0003\u0005\u0002Re\u0001\u000b\u0015BA$\u0011!\t\u0019&\u0007Q!\n\u0005\u001d\u0003\u0002CA+3\u0001\u0006K!a\u0016\t\u0011\u0005\u0015\u0014\u0004)C\u0005\u0003OBq!a\u001d\u001a\t\u0003\t)\bC\u0004\u0002xe!\t!!\u001f\t\u000f\u0005m\u0014\u0004\"\u0001\u0002z\u00191\u0011QP\u0001\u0007\u0003\u007fB\u0011\"!')\u0005\u0003\u0005\u000b\u0011\u00028\t\r)DC\u0011AAN\r\u0019\u0011g\u000b\u0001.\u0002<\"Q\u0011QZ\u0016\u0003\u0002\u0003\u0006I!a4\t\u0013\u0005\u00158F!A!\u0002\u0013q\u0007\"CAtW\t\u0005\t\u0015!\u0003o\u0011)\tIo\u000bB\u0001B\u0003%\u00111\u001e\u0005\n\u0003kY#\u0011!Q\u0001\n9D!\"!=,\u0005\u000b\u0007IQAAz\u0011)\tYp\u000bB\u0001B\u00035\u0011Q\u001f\u0005\u000b\u0003{\\#\u0011!Q\u0001\n\u0005}\bB\u00026,\t\u0003\u0011)\u0001C\u0005\u0003\u0018-\u0012\r\u0011\"\u0003\u0003\u001a!A!QE\u0016!\u0002\u0013\u0011Y\u0002C\u0005\u0003(-\u0012\r\u0011\"\u0003\u0003*!A!qG\u0016!\u0002\u0013\u0011Y\u0003C\u0005\u0003:-\u0002\r\u0011\"\u0004\u0003<!I!\u0011I\u0016A\u0002\u00135!1\t\u0005\t\u0005\u0013Z\u0003\u0015)\u0004\u0003>!A!QJ\u0016!\u0002\u001b\u0011y\u0005\u0003\u0005\u0003X-\u0002\u000bQ\u0002B-\u0011\u001d\u00119j\u000bC\u0001\u0005?CqA!),\t\u0013\u0011\u0019\u000bC\u0004\u0003*.\"IAa+\t\u000f\tU6\u0006\"\u0011\u00038\"9!QX\u0016\u0005B\t}\u0006b\u0002BhW\u0011%\u0011\u0011\u0010\u0005\b\u0005#\\C\u0011\tBj\u0011\u001d\u0011in\u000bC!\u0003sBqAa8,\t\u0003\u0012\t\u000fC\u0004\u0003d.\"\tE!9\t\u000f\t\u00158\u0006\"\u0011\u0003h\u001aA!QN\u0016!\u0002\u001b\u0011y\u0007\u0003\u0006\u0003x%\u0013)\u0019!C\u0001\u0005sB!Ba\u001fJ\u0005\u0003\u0005\u000b\u0011\u0002B+\u0011)\u0011i(\u0013BC\u0002\u0013\u0005!q\u0010\u0005\u000b\u0005\u0007K%\u0011!Q\u0001\n\t\u0005\u0005B\u00026J\t\u0003\u0011)\tC\u0005\u0003\f&\u0013\r\u0011\"\u0001\u0003\u000e\"A!QS%!\u0002\u0013\u0011y\tC\u0004\u0003\u0018&#\t!!\u001f\t\u000f\te\u0015\n\"\u0011\u0002z!9!1T%\u0005\u0002\u0005e\u0004b\u0002BO\u0013\u0012\u0005\u0011\u0011P\u0001\r\u0003\u001a4\u0017N\\5usB{w\u000e\u001c\u0006\u0003/b\u000b\u0001\"\u00194gS:LG/\u001f\u0006\u00033j\u000b\u0001\u0002Z5ta\u0006$8\r\u001b\u0006\u00037r\u000bQ\u0001]3lW>T!!\u00180\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0016aA8sOB\u0011\u0011-A\u0007\u0002-\na\u0011I\u001a4j]&$\u0018\u0010U8pYN\u0011\u0011\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0002O\u0006)1oY1mC&\u0011\u0011N\u001a\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0019\u0002\n!>|Gn\u0015;bi\u0016\u0004\"!Z8\n\u0005A4'aA%oi\u0006iQK\\5oSRL\u0017\r\\5{K\u0012,\u0012a]\b\u0002iv\t\u0001!\u0001\bV]&t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\u0019%s\u0017\u000e^5bY&T\u0018N\\4\u0016\u0003a|\u0011!_\u000f\u0002\u0003\u0005i\u0011J\\5uS\u0006d\u0017N_5oO\u0002\nqAU;o]&tw-F\u0001~\u001f\u0005qX$\u0001\u0002\u0002\u0011I+hN\\5oO\u0002\nAb\u00155viRLgn\u001a#po:,\"!!\u0002\u0010\u0005\u0005\u001dQ$A\u0002\u0002\u001bMCW\u000f\u001e;j]\u001e$un\u001e8!\u0003!\u0019\u0006.\u001e;E_^tWCAA\b\u001f\t\t\t\"H\u0001\u0005\u0003%\u0019\u0006.\u001e;E_^t\u0007%\u0001\u0006UKJl\u0017N\\1uK\u0012,\"!!\u0007\u0010\u0005\u0005mQ$A\u0003\u0002\u0017Q+'/\\5oCR,G\r\t\u0002\n\u0013\u0012dWm\u0015;bi\u0016\fq!\u00138ji&\fG.\u0001\u0005J]&$\u0018.\u00197!\u0003!\u0019\u0006/\u001b8oS:<\u0017!C*qS:t\u0017N\\4!\u0003!I\u0016.\u001a7eS:<\u0017!C-jK2$\u0017N\\4!\u0003\u001d\u0001\u0016M]6j]\u001e\f\u0001\u0002U1sW&tw\r\t\u0002\r\u0013\u0012dWm\u0015;sCR,w-_\n\u00033\u0011\fA\"\u001b3mK\u000e\u0003X\u000fT3wK2$B!!\u000f\u0002>A\u0019\u00111H\r\u000e\u0003\u0005Aa!!\u000e\u001c\u0001\u0004q\u0017\u0001C7bqN\u0003\u0018N\\:\u0002\u00135\f\u00070W5fY\u0012\u001c\u0018aD7j]B\u000b'o\u001b)fe&|GMT:\u0002\u001f5\f\u0007\u0010U1sWB+'/[8e\u001dN\u00042!ZA%\u0013\r\tYE\u001a\u0002\u0005\u0019>tw-A\u0003ti\u0006$X\rE\u0002\u0002<A\tQ\u0001^;s]N\fA\u0002]1sWB+'/[8e\u001dN\fa!\u001b3mS:<\u0007cA3\u0002Z%\u0019\u00111\f4\u0003\u000f\t{w\u000e\\3b]\"\u001a1%a\u0018\u0011\u0007\u0015\f\t'C\u0002\u0002d\u0019\u0014\u0001B^8mCRLG.Z\u0001\riJ\fgn]5uS>tGk\u001c\u000b\u0005\u0003S\ny\u0007E\u0002f\u0003WJ1!!\u001cg\u0005\u0011)f.\u001b;\t\u000f\u0005ED\u00051\u0001\u0002P\u0005Aa.Z<Ti\u0006$X-\u0001\u0005jg&#G.\u001b8h+\t\t9&\u0001\u0003jI2,GCAA5\u0003\u0015\u0011Xm]3u\u0005a\u0011u.\u001e8eK\u0012\feMZ5oSRLH+Y:l#V,W/Z\n\u0004Q\u0005\u0005\u0005CBAB\u0003\u000b\u000bI)D\u0001Y\u0013\r\t9\t\u0017\u0002\u0019\u0003\n\u001cHO]1di\n{WO\u001c3fI:{G-Z)vKV,\u0007\u0003BAF\u0003+k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0014\u0006!!.\u0019<b\u0013\u0011\t9*!$\u0003\u0011I+hN\\1cY\u0016\f\u0001bY1qC\u000eLG/\u001f\u000b\u0005\u0003;\u000by\nE\u0002\u0002<!Ba!!'+\u0001\u0004q\u0007fA\u0001\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*j\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti+a*\u0003\u0019\u0005\u0003\u0018.T1z\u0007\"\fgnZ3)\u0007\u0005\t\t\f\u0005\u0003\u0002&\u0006M\u0016\u0002BA[\u0003O\u00131\"\u00138uKJt\u0017\r\\!qS\"\u001a\u0001!a))\u0007\u0001\t\tlE\u0002,\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0006d_:\u001cWO\u001d:f]RTA!a2\u0002\u0012\u0006!Q\u000f^5m\u0013\u0011\tY-!1\u0003/\u0005\u00137\u000f\u001e:bGR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AA5e!\u0011\t\t.a8\u000f\t\u0005M\u00171\u001c\t\u0004\u0003+4WBAAl\u0015\r\tIn[\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ug-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\f\u0019O\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;4\u0017a\u00039be\u0006dG.\u001a7jg6\f\u0011#\u00194gS:LG/_$s_V\u00048+\u001b>f\u00035!\bN]3bI\u001a\u000b7\r^8ssB!\u0011qXAw\u0013\u0011\ty/!1\u0003\u001bQC'/Z1e\r\u0006\u001cGo\u001c:z\u00035\tX/Z;f'\u0016dWm\u0019;peV\u0011\u0011Q\u001f\t\u0004C\u0006]\u0018bAA}-\ni\u0011+^3vKN+G.Z2u_J\fa\"];fk\u0016\u001cV\r\\3di>\u0014\b%\u0001\tsK*,7\r^5p]\"\u000bg\u000e\u001a7feB\u0019\u0011M!\u0001\n\u0007\t\raK\u0001\tSK*,7\r^5p]\"\u000bg\u000e\u001a7feR\u0001\"q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\u0003\u0012\tM!Q\u0003\t\u0003C.Bq!!45\u0001\u0004\ty\r\u0003\u0004\u0002fR\u0002\rA\u001c\u0005\u0007\u0003O$\u0004\u0019\u00018\t\u000f\u0005%H\u00071\u0001\u0002l\"1\u0011Q\u0007\u001bA\u00029Dq!!=5\u0001\u0004\t)\u0010C\u0004\u0002~R\u0002\r!a@\u0002\u001f\t|wn[&fKBLgn\u001a'pG.,\"Aa\u0007\u0011\t\tu!\u0011E\u0007\u0003\u0005?Q1!a2[\u0013\u0011\u0011\u0019Ca\b\u0003\u001dI+WM\u001c;sC:$x)^1sI\u0006\u0001\"m\\8l\u0017\u0016,\u0007/\u001b8h\u0019>\u001c7\u000eI\u0001\u0015i\u0016\u0014X.\u001b8bi&|gnQ8oI&$\u0018n\u001c8\u0016\u0005\t-\u0002\u0003\u0002B\u0017\u0005gi!Aa\f\u000b\t\tE\u0012\u0011Y\u0001\u0006Y>\u001c7n]\u0005\u0005\u0005k\u0011yCA\u0005D_:$\u0017\u000e^5p]\u0006)B/\u001a:nS:\fG/[8o\u0007>tG-\u001b;j_:\u0004\u0013!\u00039p_2\u001cF/\u0019;f+\t\u0011i\u0004E\u0002\u0003@\rq!!\u0019\u0001\u0002\u001bA|w\u000e\\*uCR,w\fJ3r)\u0011\tIG!\u0012\t\u0013\t\u001d#(!AA\u0002\tu\u0012a\u0001=%c\u0005Q\u0001o\\8m'R\fG/\u001a\u0011)\u0007m\ny&\u0001\u0006x_J\\\u0017+^3vKN\u0004R!\u001aB)\u0005+J1Aa\u0015g\u0005\u0015\t%O]1z!\r\u0011y\u0004K\u0001\bo>\u00148.\u001a:t!\u0019\u0011YF!\u001a\u0003j5\u0011!Q\f\u0006\u0005\u0005?\u0012\t'A\u0004nkR\f'\r\\3\u000b\u0007\t\rd-\u0001\u0006d_2dWm\u0019;j_:LAAa\u001a\u0003^\t\u00191+\u001a;\u0011\u0007\t-\u0014*D\u0001,\u0005I\teMZ5oSRL\bk\\8m/>\u00148.\u001a:\u0014\u000b%\u0013\t(!#\u0011\t\u0005-%1O\u0005\u0005\u0005k\niI\u0001\u0004PE*,7\r^\u0001\u0002cV\u0011!QK\u0001\u0003c\u0002\nA\"\u001b3mKN#(/\u0019;fOf,\"A!!\u0011\u0007\t}\u0012$A\u0007jI2,7\u000b\u001e:bi\u0016<\u0017\u0010\t\u000b\u0007\u0005S\u00129I!#\t\u000f\t]d\n1\u0001\u0003V!9!Q\u0010(A\u0002\t\u0005\u0015A\u0002;ie\u0016\fG-\u0006\u0002\u0003\u0010B!\u00111\u0012BI\u0013\u0011\u0011\u0019*!$\u0003\rQC'/Z1e\u0003\u001d!\bN]3bI\u0002\nQa\u001d;beR\f1A];o\u0003\u0011\u0019Ho\u001c9\u0002\u0015M$x\u000e]%g\u0013\u0012dW\r\u0006\u0002\u0003l\u0005I\u0011\r\u001a3X_J\\WM\u001d\u000b\u0007\u0003S\u0012)Ka*\t\u000f\t]s\b1\u0001\u0003Z!9!qO A\u0002\tU\u0013\u0001D8o/>\u00148.\u001a:Fq&$HCBA5\u0005[\u0013\t\fC\u0004\u00030\u0002\u0003\rA!\u001b\u0002\u0003]DqAa-A\u0001\u0004\t9&A\tbEJ,\b\u000f\u001e+fe6Lg.\u0019;j_:\fq!\u001a=fGV$X\r\u0006\u0003\u0002j\te\u0006b\u0002B^\u0003\u0002\u0007\u0011\u0011R\u0001\bG>lW.\u00198e\u0003A\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000e\u0006\u0004\u0002X\t\u0005'Q\u0019\u0005\b\u0005\u0007\u0014\u0005\u0019AA$\u0003\u001d!\u0018.\\3pkRDqAa2C\u0001\u0004\u0011I-\u0001\u0003v]&$\b\u0003BA`\u0005\u0017LAA!4\u0002B\nAA+[7f+:LG/\u0001\fbiR,W\u000e\u001d;Q_>dG+\u001a:nS:\fG/[8o\u0003-\u0019\b.\u001e;e_^tgj\\<\u0015\u0005\tU\u0007C\u0002Bl\u00053\fI)\u0004\u0002\u0002F&!!1\\Ac\u0005\u0011a\u0015n\u001d;\u0002\u0011MDW\u000f\u001e3po:\f!\"[:TQV$Hm\\<o)\t\t9&\u0001\u0007jgR+'/\\5oCR,G-\u0001\u0005u_N#(/\u001b8h)\t\ty\rK\u0002,\u0003GC3aKAY\u0001")
@InternalApi
@ApiMayChange
public class AffinityPool
extends AbstractExecutorService {
    private final String id;
    private final int parallelism;
    private final int affinityGroupSize;
    public final ThreadFactory org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory;
    private final int idleCpuLevel;
    private final QueueSelector queueSelector;
    private final RejectionHandler rejectionHandler;
    private final ReentrantGuard bookKeepingLock;
    private final Condition terminationCondition;
    private volatile int org$apache$pekko$dispatch$affinity$AffinityPool$$poolState;
    private final BoundedAffinityTaskQueue[] workQueues;
    private final Set<AffinityPoolWorker> workers;

    public static int Parking() {
        return AffinityPool$.MODULE$.Parking();
    }

    public static int Yielding() {
        return AffinityPool$.MODULE$.Yielding();
    }

    public static int Spinning() {
        return AffinityPool$.MODULE$.Spinning();
    }

    public static int Initial() {
        return AffinityPool$.MODULE$.Initial();
    }

    public static int Terminated() {
        return AffinityPool$.MODULE$.Terminated();
    }

    public static int ShutDown() {
        return AffinityPool$.MODULE$.ShutDown();
    }

    public static int ShuttingDown() {
        return AffinityPool$.MODULE$.ShuttingDown();
    }

    public static int Running() {
        return AffinityPool$.MODULE$.Running();
    }

    public static int Initializing() {
        return AffinityPool$.MODULE$.Initializing();
    }

    public static int Uninitialized() {
        return AffinityPool$.MODULE$.Uninitialized();
    }

    public final QueueSelector queueSelector() {
        return this.queueSelector;
    }

    private ReentrantGuard bookKeepingLock() {
        return this.bookKeepingLock;
    }

    private Condition terminationCondition() {
        return this.terminationCondition;
    }

    public final int org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() {
        return this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState;
    }

    private final void org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(int x$1) {
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = x$1;
    }

    public AffinityPool start() {
        AffinityPool affinityPool;
        ReentrantGuard reentrantGuard = this.bookKeepingLock();
        if (reentrantGuard == null) {
            throw null;
        }
        ReentrantGuard withGuard_this = reentrantGuard;
        withGuard_this.lock();
        try {
            affinityPool = AffinityPool.$anonfun$start$1(this);
        }
        finally {
            withGuard_this.unlock();
        }
        return affinityPool;
    }

    private void addWorker(Set<AffinityPoolWorker> workers, BoundedAffinityTaskQueue q) {
        AffinityPoolWorker worker = new AffinityPoolWorker(this, q, new IdleStrategy(this.idleCpuLevel));
        workers.add((Object)worker);
        worker.start();
    }

    public void org$apache$pekko$dispatch$affinity$AffinityPool$$onWorkerExit(AffinityPoolWorker w, boolean abruptTermination) {
        ReentrantGuard reentrantGuard = this.bookKeepingLock();
        if (reentrantGuard == null) {
            throw null;
        }
        ReentrantGuard withGuard_this = reentrantGuard;
        withGuard_this.lock();
        try {
            AffinityPool.$anonfun$onWorkerExit$1(this, w, abruptTermination);
        }
        finally {
            withGuard_this.unlock();
        }
    }

    @Override
    public void execute(Runnable command) {
        BoundedAffinityTaskQueue queue = this.workQueues[this.queueSelector().getQueue(command, this.parallelism)];
        if (this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() >= 3 || !queue.add(command)) {
            this.rejectionHandler.reject(command, this);
            return;
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        boolean bl;
        ReentrantGuard reentrantGuard = this.bookKeepingLock();
        if (reentrantGuard == null) {
            throw null;
        }
        ReentrantGuard withGuard_this = reentrantGuard;
        withGuard_this.lock();
        try {
            bl = this.awaitTermination$1(unit.toNanos(timeout));
        }
        finally {
            withGuard_this.unlock();
        }
        return bl;
    }

    private void attemptPoolTermination() {
        if (this.workers.isEmpty() && this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() == 4) {
            this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(5);
            this.terminationCondition().signalAll();
            return;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        List list;
        ReentrantGuard reentrantGuard = this.bookKeepingLock();
        if (reentrantGuard == null) {
            throw null;
        }
        ReentrantGuard withGuard_this = reentrantGuard;
        withGuard_this.lock();
        try {
            list = AffinityPool.$anonfun$shutdownNow$1(this);
        }
        finally {
            withGuard_this.unlock();
        }
        return list;
    }

    @Override
    public void shutdown() {
        ReentrantGuard reentrantGuard = this.bookKeepingLock();
        if (reentrantGuard == null) {
            throw null;
        }
        ReentrantGuard withGuard_this = reentrantGuard;
        withGuard_this.lock();
        try {
            AffinityPool.$anonfun$shutdown$1(this);
        }
        finally {
            withGuard_this.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() >= 4;
    }

    @Override
    public boolean isTerminated() {
        return this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() == 5;
    }

    public String toString() {
        return new StringBuilder(119).append(Logging$.MODULE$.simpleName(this)).append("(id = ").append(this.id).append(", parallelism = ").append(this.parallelism).append(", affinityGroupSize = ").append(this.affinityGroupSize).append(", threadFactory = ").append(this.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory).append(", idleCpuLevel = ").append(this.idleCpuLevel).append(", queueSelector = ").append(this.queueSelector()).append(", rejectionHandler = ").append(this.rejectionHandler).append(")").toString();
    }

    public static final /* synthetic */ AffinityPool $anonfun$start$1(AffinityPool $this) {
        if ($this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() == 0) {
            $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(1);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.workQueues)).foreach((Function1 & Serializable & scala.Serializable)q -> {
                $this.addWorker($this.workers, q);
                return BoxedUnit.UNIT;
            });
            $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(2);
        }
        return $this;
    }

    public static final /* synthetic */ void $anonfun$onWorkerExit$1(AffinityPool $this, AffinityPoolWorker w$1, boolean abruptTermination$1) {
        $this.workers.remove((Object)w$1);
        if (abruptTermination$1 && $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() == 2) {
            $this.addWorker($this.workers, w$1.q());
            return;
        }
        if ($this.workers.isEmpty() && !abruptTermination$1 && $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() >= 3) {
            $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(4);
            $this.attemptPoolTermination();
            return;
        }
    }

    private final boolean awaitTermination$1(long nanos) {
        while (this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState() != 5) {
            if (nanos <= 0L) {
                return false;
            }
            nanos = this.terminationCondition().awaitNanos(nanos);
        }
        return true;
    }

    public static final /* synthetic */ List $anonfun$shutdownNow$1(AffinityPool $this) {
        $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(4);
        $this.workers.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
        $this.attemptPoolTermination();
        return Collections.emptyList();
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(AffinityPool $this) {
        $this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState_$eq(3);
        $this.workers.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stopIfIdle();
            return BoxedUnit.UNIT;
        });
        $this.attemptPoolTermination();
    }

    public AffinityPool(String id, int parallelism, int affinityGroupSize, ThreadFactory threadFactory, int idleCpuLevel, QueueSelector queueSelector, RejectionHandler rejectionHandler) {
        this.id = id;
        this.parallelism = parallelism;
        this.affinityGroupSize = affinityGroupSize;
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory = threadFactory;
        this.idleCpuLevel = idleCpuLevel;
        this.queueSelector = queueSelector;
        this.rejectionHandler = rejectionHandler;
        if (parallelism <= 0) {
            throw new IllegalArgumentException("Size of pool cannot be less or equal to 0");
        }
        this.bookKeepingLock = new ReentrantGuard();
        this.terminationCondition = this.bookKeepingLock().newCondition();
        this.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState = 0;
        this.workQueues = (BoundedAffinityTaskQueue[])Array$.MODULE$.fill(parallelism, (Function0 & Serializable & scala.Serializable)() -> new BoundedAffinityTaskQueue($this.affinityGroupSize), ClassTag$.MODULE$.apply(BoundedAffinityTaskQueue.class));
        this.workers = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private final class AffinityPoolWorker
    implements Runnable {
        private final BoundedAffinityTaskQueue q;
        private final IdleStrategy idleStrategy;
        private final Thread thread;
        private final /* synthetic */ AffinityPool $outer;

        public BoundedAffinityTaskQueue q() {
            return this.q;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Thread thread() {
            return this.thread;
        }

        public void start() {
            if (this.thread() == null) {
                throw new IllegalStateException(new StringBuilder(43).append("Was not able to allocate worker thread for ").append(this.$outer).toString());
            }
            this.thread().start();
        }

        @Override
        public void run() {
            boolean abruptTermination = true;
            try {
                this.runLoop$1();
                abruptTermination = false;
            }
            finally {
                this.$outer.org$apache$pekko$dispatch$affinity$AffinityPool$$onWorkerExit(this, abruptTermination);
            }
        }

        public void stop() {
            if (!this.thread().isInterrupted()) {
                this.thread().interrupt();
                return;
            }
        }

        public void stopIfIdle() {
            if (this.idleStrategy().isIdling()) {
                this.stop();
                return;
            }
        }

        private final boolean executeNext$1() {
            boolean next;
            Runnable c = (Runnable)this.q().poll();
            boolean bl = next = c != null;
            if (next) {
                c.run();
                this.idleStrategy().reset();
            } else {
                this.idleStrategy().idle();
            }
            return next;
        }

        private final void runLoop$1() {
            block6: while (!Thread.interrupted()) {
                int n = this.$outer.org$apache$pekko$dispatch$affinity$AffinityPool$$poolState();
                switch (n) {
                    case 0: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        this.executeNext$1();
                        continue block6;
                    }
                    case 3: {
                        if (!this.executeNext$1()) break block6;
                        continue block6;
                    }
                    case 4: 
                    case 5: {
                        return;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
            }
        }

        public AffinityPoolWorker(AffinityPool $outer, BoundedAffinityTaskQueue q, IdleStrategy idleStrategy) {
            this.q = q;
            this.idleStrategy = idleStrategy;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.thread = $outer.org$apache$pekko$dispatch$affinity$AffinityPool$$threadFactory.newThread(this);
        }
    }

    private static final class BoundedAffinityTaskQueue
    extends AbstractBoundedNodeQueue<Runnable> {
        public BoundedAffinityTaskQueue(int capacity) {
            super(capacity);
        }
    }

    private static final class IdleStrategy {
        private final int maxSpins;
        private final int maxYields;
        private final int minParkPeriodNs;
        private final long maxParkPeriodNs;
        private int state;
        private long turns;
        private long parkPeriodNs;
        private volatile boolean idling;

        private void transitionTo(int newState) {
            this.state = newState;
            this.turns = 0L;
        }

        public boolean isIdling() {
            return this.idling;
        }

        public void idle() {
            int n = this.state;
            switch (n) {
                case 0: {
                    this.idling = true;
                    this.transitionTo(1);
                    return;
                }
                case 1: {
                    OnSpinWait.spinWait();
                    ++this.turns;
                    if (this.turns > (long)this.maxSpins) {
                        this.transitionTo(2);
                        return;
                    }
                    return;
                }
                case 2: {
                    ++this.turns;
                    if (this.turns > (long)this.maxYields) {
                        this.parkPeriodNs = this.minParkPeriodNs;
                        this.transitionTo(3);
                        return;
                    }
                    Thread.yield();
                    return;
                }
                case 3: {
                    LockSupport.parkNanos(this.parkPeriodNs);
                    this.parkPeriodNs = Math.min(this.parkPeriodNs << 1, this.maxParkPeriodNs);
                    return;
                }
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }

        public void reset() {
            this.idling = false;
            this.transitionTo(0);
        }

        public IdleStrategy(int idleCpuLevel) {
            this.maxSpins = 1100 * idleCpuLevel - 1000;
            this.maxYields = 5 * idleCpuLevel;
            this.minParkPeriodNs = 1;
            this.maxParkPeriodNs = TimeUnit.MICROSECONDS.toNanos(250 - 80 * (idleCpuLevel - 1) / 3);
            this.state = 0;
            this.turns = 0L;
            this.parkPeriodNs = 0L;
            this.idling = false;
        }
    }
}

