/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.FrequencySketch$;
import org.apache.pekko.util.FrequencySketch$Bits$;
import org.apache.pekko.util.FrequencySketchUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\t-rAB\u001d;\u0011\u0003a$I\u0002\u0004Eu!\u0005A(\u0012\u0005\u0006\u0019\u0006!\tA\u0014\u0005\u0006\u001f\u0006!\t\u0001\u0015\u0005\n\u0003/\f\u0011\u0013!C\u0001\u00033D\u0011\"!=\u0002#\u0003%\t!a=\t\u0013\u0005m\u0018!%A\u0005\u0002\u0005u\b\"\u0003B\u0001\u0003E\u0005I\u0011\u0001B\u0002\r\u001d\u0001\u0017\u0001%A\u0012\"\u0005DQa\u0019\u0005\u0007\u0002\u0011<aAa\u0002\u0002\u0011\u00031h!\u00021\u0002\u0011\u0003!\b\"\u0002'\f\t\u0003)\bb\u0002=\f\u0005\u0004%)!\u001f\u0005\u0007y.\u0001\u000bQ\u0002>\t\u000fu\\!\u0019!C\u0002}\"9\u00111A\u0006!\u0002\u0013yh!B:\f\u0005\u0005\u0015\u0001\"CA\u0010#\t\u0005\t\u0015!\u0003X\u0011\u0019a\u0015\u0003\"\u0001\u0002\"!11-\u0005C!\u0003K9qA!\u0003\u0002\u0011\u0003\u0011YAB\u0004\u0003\u000e\u0005A\tAa\u0004\t\r13B\u0011\u0001B\t\u0011\u001d\u0011\u0019B\u0006C\u0001\u0005+AqAa\u0007\u0017\t\u0003\u0011i\u0002C\u0004\u0003\"Y!\tAa\t\u0007\u000b\u0011S$\u0001\u0010+\t\u0011Y[\"\u0011!Q\u0001\n]C\u0001BW\u000e\u0003\u0002\u0003\u0006Ia\u0016\u0005\t7n\u0011\t\u0011)A\u0005/\"AAl\u0007B\u0001B\u0003%q\u000b\u0003\u0005^7\t\u0005\t\u0015!\u0003_\u0011\u0019a5\u0004\"\u0001\u0002.!I\u00111H\u000eC\u0002\u00135\u0011Q\b\u0005\t\u0003\u0007Z\u0002\u0015!\u0004\u0002@!9\u0011QI\u000e!\u0002\u00139\u0006bBA$7\u0001\u0006Ia\u0016\u0005\b\u0003\u0013Z\u0002\u0015!\u0003X\u0011\u001d\tYe\u0007Q\u0001\n]Cq!!\u0014\u001cA\u0003%q\u000bC\u0004\u0002Pm\u0001\u000b\u0011B,\t\u000f\u0005E3\u0004)A\u0005/\"A\u00111K\u000e!\u0002\u0013\t)\u0006\u0003\u0005\u0002\\m\u0001\u000b\u0011BA+\u0011!\tif\u0007Q\u0001\n\u0005U\u0003\u0002CA07\u0001\u0006I!!\u0019\t\u0011\u0005%4\u0004)A\u0005\u0003WBq!!\u001c\u001cA\u0003&q\u000bC\u0004\u0002pm!\t!!\u001d\t\u000f\u0005M4\u0004\"\u0001\u0002v!9\u0011\u0011P\u000e\u0005\u0002\u0005m\u0004bBAC7\u0011%\u0011q\u0011\u0005\b\u0003\u0017[B\u0011BAG\u0011\u001d\t)j\u0007C\u0005\u0003/Cq!a)\u001c\t\u0013\t)\u000bC\u0004\u0002(n!\t!!+\u0002\u001f\u0019\u0013X-];f]\u000eL8k[3uG\"T!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003{y\nQ\u0001]3lW>T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sOB\u00111)A\u0007\u0002u\tyaI]3rk\u0016t7-_*lKR\u001c\u0007n\u0005\u0002\u0002\rB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002\u0005\u0006)\u0011\r\u001d9msV\u0019\u0011+a/\u0015\u0017I\u000b\t-!2\u0002J\u0006M\u0017Q\u001b\u000b\u0004'\u0006u\u0006\u0003B\"\u001c\u0003s+2!VA\u0016'\tYb)A\u0003eKB$\b\u000e\u0005\u0002H1&\u0011\u0011\f\u0013\u0002\u0004\u0013:$\u0018!B<jIRD\u0017aC2pk:$XM\u001d\"jiN\f\u0011B]3tKR\u001c\u0016N_3\u0002\r!\f7\u000f[3s!\u0011y\u0006\"!\u000b\u000f\u0005\r\u0003!A\u0002%bg\",'/\u0006\u0002cSN\u0011\u0001BR\u0001\u0005Q\u0006\u001c\b\u000e\u0006\u0002XK\")a-\u0003a\u0001O\u0006)a/\u00197vKB\u0011\u0001.\u001b\u0007\u0001\t\u0015Q\u0007B1\u0001l\u0005\u0005\t\u0015C\u00017p!\t9U.\u0003\u0002o\u0011\n9aj\u001c;iS:<\u0007CA$q\u0013\t\t\bJA\u0002B]fL#\u0001C\t\u0003\u0019M#(/\u001b8h\u0011\u0006\u001c\b.\u001a:\u0014\u0005-1E#\u0001<\u0011\u0005]\\Q\"A\u0001\u0002\u0017\u0011+g-Y;miN+W\rZ\u000b\u0002u>\t10\b\u0003\t!\t+\u0013\u0001\u0004#fM\u0006,H\u000e^*fK\u0012\u0004\u0013\u0001D*ue&tw\rS1tQ\u0016\u0014X#A@\u0011\u0007\u0005\u0005\u0011#D\u0001\f\u00035\u0019FO]5oO\"\u000b7\u000f[3sAM!\u0011CRA\u0004!\u00119\b\"!\u0003\u0011\t\u0005-\u0011\u0011\u0004\b\u0005\u0003\u001b\t)\u0002E\u0002\u0002\u0010!k!!!\u0005\u000b\u0007\u0005MQ*\u0001\u0004=e>|GOP\u0005\u0004\u0003/A\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018!\u000bAa]3fIR\u0019q0a\t\t\r\u0005}1\u00031\u0001X)\r9\u0016q\u0005\u0005\u0007MR\u0001\r!!\u0003\u0011\u0007!\fY\u0003B\u0003k7\t\u00071\u000e\u0006\u0007\u00020\u0005E\u00121GA\u001b\u0003o\tI\u0004\u0005\u0003D7\u0005%\u0002\"\u0002,\"\u0001\u00049\u0006\"\u0002.\"\u0001\u00049\u0006\"B.\"\u0001\u00049\u0006\"\u0002/\"\u0001\u00049\u0006\"B/\"\u0001\u0004q\u0016\u0001C*m_R\u0014\u0015\u000e^:\u0016\u0005\u0005}rBAA!;\u0005\u0001\u0015!C*m_R\u0014\u0015\u000e^:!\u00031\u0019w.\u001e8uKJ<\u0016\u000e\u001a;i\u0003\u0015\u0019Hn\u001c;t\u0003!\u0011xn^,jIRD\u0017AC2pYVlg.T1tW\u0006I1\u000f\\8u'\"Lg\r^\u0001\tg2|G/T1tW\u0006a1m\\;oi\u0016\u00148\u000b[5gi\u0006Y1m\\;oi\u0016\u0014X*Y:l!\r9\u0015qK\u0005\u0004\u00033B%\u0001\u0002'p]\u001e\fqa\u001c3e\u001b\u0006\u001c8.A\u0005sKN,G/T1tW\u00061Q.\u0019;sSb\u0004RaRA2\u0003OJ1!!\u001aI\u0005\u0015\t%O]1z!\u00159\u00151MA+\u0003!\u0011xn^*ju\u0016\u001c\b\u0003B$\u0002d]\u000b1\"\u001e9eCR,GmU5{K\u0006!1/\u001b>f+\u00059\u0016!\u00034sKF,XM\\2z)\r9\u0016q\u000f\u0005\u0007MJ\u0002\r!!\u000b\u0002\u0013%t7M]3nK:$H\u0003BA?\u0003\u0007\u00032aRA@\u0013\r\t\t\t\u0013\u0002\u0005+:LG\u000f\u0003\u0004gg\u0001\u0007\u0011\u0011F\u0001\u0007e\u0016D\u0017m\u001d5\u0015\u0007]\u000bI\tC\u0003di\u0001\u0007q+\u0001\u0006hKR\u001cu.\u001e8uKJ$RaVAH\u0003'Ca!!%6\u0001\u00049\u0016a\u0001:po\")1-\u000ea\u0001/\u0006\u0001\u0012N\\2sK6,g\u000e^\"pk:$XM\u001d\u000b\u0007\u00033\u000by*!)\u0011\u0007\u001d\u000bY*C\u0002\u0002\u001e\"\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0012Z\u0002\ra\u0016\u0005\u0006GZ\u0002\raV\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0003\u0003{\nQ\u0002^8EK\n,xm\u0015;sS:<WCAA\u0005Q\rY\u0012Q\u0016\t\u0005\u0003_\u000b),\u0004\u0002\u00022*\u0019\u00111\u0017\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u0006E&aC%oi\u0016\u0014h.\u00197Ba&\u00042\u0001[A^\t\u0015Q7A1\u0001l\u0011\u0019i6\u0001q\u0001\u0002@B!q\u000fCA]\u0011\u0019\t\u0019m\u0001a\u0001/\u0006A1-\u00199bG&$\u0018\u0010\u0003\u0005\u0002H\u000e\u0001\n\u00111\u0001X\u0003=9\u0018\u000e\u001a;i\u001bVdG/\u001b9mS\u0016\u0014\b\"CAf\u0007A\u0005\t\u0019AAg\u0003=\u0011Xm]3u\u001bVdG/\u001b9mS\u0016\u0014\bcA$\u0002P&\u0019\u0011\u0011\u001b%\u0003\r\u0011{WO\u00197f\u0011\u001d16\u0001%AA\u0002]CqaW\u0002\u0011\u0002\u0003\u0007q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\tY.a<\u0016\u0005\u0005u'fA,\u0002`.\u0012\u0011\u0011\u001d\t\u0005\u0003G\fY/\u0004\u0002\u0002f*!\u0011q]Au\u0003%)hn\u00195fG.,GMC\u0002\u00024\"KA!!<\u0002f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b)$!\u0019A6\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*B!!>\u0002zV\u0011\u0011q\u001f\u0016\u0005\u0003\u001b\fy\u000eB\u0003k\u000b\t\u00071.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\tY.a@\u0005\u000b)4!\u0019A6\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU*B!a7\u0003\u0006\u0011)!n\u0002b\u0001W\u00061\u0001*Y:iKJ\fAAQ5ugB\u0011qO\u0006\u0002\u0005\u0005&$8o\u0005\u0002\u0017\rR\u0011!1B\u0001\rSN\u0004vn^3s\u001f\u001a$vo\u001c\u000b\u0005\u00033\u00139\u0002\u0003\u0004\u0003\u001aa\u0001\raV\u0001\u0002S\u0006\u0011\u0002o\\<fe>3Gk^8FqB|g.\u001a8u)\r9&q\u0004\u0005\u0007\u00053I\u0002\u0019A,\u0002#\r,\u0017\u000e\\5oOB{w/\u001a:PMR;x\u000eF\u0002X\u0005KAaA!\u0007\u001b\u0001\u00049\u0006fA\u0001\u0002.\"\u001a\u0001!!,")
@InternalApi
public final class FrequencySketch<A> {
    private final int depth;
    private final int resetSize;
    private final Hasher<A> hasher;
    private final int counterWidth;
    private final int slots;
    private final int rowWidth;
    private final int columnMask;
    private final int slotShift;
    private final int slotMask;
    private final int counterShift;
    private final long counterMask;
    private final long oddMask;
    private final long resetMask;
    private final long[][] matrix;
    private final int[] rowSizes;
    private int updatedSize;

    public static <A> int apply$default$5() {
        return FrequencySketch$.MODULE$.apply$default$5();
    }

    public static <A> int apply$default$4() {
        return FrequencySketch$.MODULE$.apply$default$4();
    }

    public static <A> double apply$default$3() {
        return FrequencySketch$.MODULE$.apply$default$3();
    }

    public static <A> int apply$default$2() {
        return FrequencySketch$.MODULE$.apply$default$2();
    }

    public static <A> FrequencySketch<A> apply(int n, int n2, double d, int n3, int n4, Hasher<A> hasher) {
        return FrequencySketch$.MODULE$.apply(n, n2, d, n3, n4, hasher);
    }

    private final int SlotBits() {
        return 64;
    }

    public int size() {
        return this.updatedSize;
    }

    public int frequency(A value) {
        int hash1 = this.hasher.hash(value);
        int hash2 = this.rehash(hash1);
        int minCount = Integer.MAX_VALUE;
        for (int row = 0; row < this.depth; ++row) {
            int hash = hash1 + row * hash2;
            minCount = Math.min(minCount, this.getCounter(row, hash));
        }
        return minCount;
    }

    public void increment(A value) {
        int hash1 = this.hasher.hash(value);
        int hash2 = this.rehash(hash1);
        boolean updated = false;
        for (int row = 0; row < this.depth; ++row) {
            int hash = hash1 + row * hash2;
            updated |= this.incrementCounter(row, hash);
        }
        if (updated) {
            ++this.updatedSize;
            if (this.updatedSize == this.resetSize) {
                this.reset();
                return;
            }
            return;
        }
    }

    private int rehash(int hash) {
        return MurmurHash3$.MODULE$.finalizeHash(MurmurHash3$.MODULE$.mixLast(hash, hash), 2);
    }

    private int getCounter(int row, int hash) {
        int column = (hash & this.columnMask) >>> this.slotShift;
        int slot = (hash & this.slotMask) << this.counterShift;
        return (int)(this.matrix[row][column] >>> slot & this.counterMask);
    }

    private boolean incrementCounter(int row, int hash) {
        int column = (hash & this.columnMask) >>> this.slotShift;
        int slot = (hash & this.slotMask) << this.counterShift;
        long mask = this.counterMask << slot;
        if ((this.matrix[row][column] & mask) != mask) {
            long[] lArray = this.matrix[row];
            lArray[column] = lArray[column] + (1L << slot);
            this.rowSizes[row] = this.rowSizes[row] + 1;
            return true;
        }
        return false;
    }

    private void reset() {
        for (int row = 0; row < this.depth; ++row) {
            int odd = 0;
            for (int column = 0; column < this.rowWidth; ++column) {
                odd += Long.bitCount(this.matrix[row][column] & this.oddMask);
                this.matrix[row][column] = this.matrix[row][column] >>> 1 & this.resetMask;
            }
            this.rowSizes[row] = this.rowSizes[row] - odd >>> 1;
        }
        this.updatedSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.rowSizes)).max((Ordering)Ordering.Int$.MODULE$));
    }

    public String toDebugString() {
        return FrequencySketchUtil$.MODULE$.debugString(this.matrix, this.rowWidth, this.slots, this.counterWidth, this.counterMask);
    }

    public FrequencySketch(int depth, int width, int counterBits, int resetSize, Hasher<A> hasher) {
        this.depth = depth;
        this.resetSize = resetSize;
        this.hasher = hasher;
        Predef$.MODULE$.require(FrequencySketch$Bits$.MODULE$.isPowerOfTwo(width), (Function0 & Serializable & scala.Serializable)() -> "width must be a power of two");
        Predef$.MODULE$.require(((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 8, 16, 32, 64}))).apply((Object)BoxesRunTime.boxToInteger((int)counterBits)), (Function0 & Serializable & scala.Serializable)() -> "counterBits must be 2, 4, 8, 16, 32, or 64 bits");
        this.counterWidth = counterBits;
        this.slots = 64 / this.counterWidth;
        this.rowWidth = package$.MODULE$.max(1, width / this.slots);
        this.columnMask = width - 1;
        this.slotShift = FrequencySketch$Bits$.MODULE$.powerOfTwoExponent(this.slots);
        this.slotMask = this.slots - 1;
        this.counterShift = FrequencySketch$Bits$.MODULE$.powerOfTwoExponent(this.counterWidth);
        this.counterMask = counterBits == 64 ? Long.MAX_VALUE : (1L << this.counterWidth) - 1L;
        this.oddMask = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.slots).foldLeft((Object)BoxesRunTime.boxToLong((long)1L), (Function2)(JFunction2.mcJJI.sp & Serializable & scala.Serializable)(mask, count) -> mask | 1L << count * $this.counterWidth));
        long counterResetMask = this.counterMask >> 1;
        this.resetMask = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.slots).foldLeft((Object)BoxesRunTime.boxToLong((long)counterResetMask), (Function2)(JFunction2.mcJJI.sp & Serializable & scala.Serializable)(mask, count) -> mask | counterResetMask << count * $this.counterWidth));
        this.matrix = (long[][])Array$.MODULE$.fill(depth, (Function0 & Serializable & scala.Serializable)() -> (long[])Array$.MODULE$.ofDim($this.rowWidth, ClassTag$.MODULE$.Long()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        this.rowSizes = (int[])Array$.MODULE$.ofDim(depth, ClassTag$.MODULE$.Int());
        this.updatedSize = 0;
    }

    public static interface Hasher<A> {
        public int hash(A var1);
    }
}

