/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.Collection;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;

public final class LogHelper {
    private static final int MAX_COLLECTION_LOG_SIZE = Integer.valueOf(System.getProperty("redisson.maxCollectionLogSize", "10"));
    private static final int MAX_STRING_LOG_SIZE = Integer.valueOf(System.getProperty("redisson.maxStringLogSize", "1000"));

    private LogHelper() {
    }

    public static String toString(RedisCommand<?> command, Object ... params) {
        if (RedisCommands.AUTH.equals(command)) {
            return command + ", params: (password masked)";
        }
        return command + ", params: " + LogHelper.toString(params);
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return LogHelper.toStringString((String)object);
        }
        if (object.getClass().isArray()) {
            return LogHelper.toArrayString(object);
        }
        if (object instanceof Collection) {
            return LogHelper.toCollectionString((Collection)object);
        }
        if (object instanceof CommandData) {
            CommandData cd = (CommandData)object;
            if (RedisCommands.AUTH.equals(cd.getCommand())) {
                return cd.getCommand() + ", params: (password masked)";
            }
            return cd.getCommand() + ", promise: " + cd.getPromise() + ", params: " + LogHelper.toString(cd.getParams());
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return byteBuf.toString();
        }
        return String.valueOf(object);
    }

    private static String toStringString(String string) {
        if (string.length() > MAX_STRING_LOG_SIZE) {
            return string.substring(0, MAX_STRING_LOG_SIZE) + "...";
        }
        return string;
    }

    private static String toCollectionString(Collection<?> collection) {
        if (collection.isEmpty()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(collection.size() * 3);
        b.append('[');
        int i = 0;
        for (Object object : collection) {
            b.append(LogHelper.toString(object));
            if (++i == collection.size()) {
                b.append(']');
                break;
            }
            b.append(", ");
            if (i != MAX_COLLECTION_LOG_SIZE) continue;
            b.append("...]");
            break;
        }
        return b.toString();
    }

    private static String toArrayString(Object array) {
        int length = Array.getLength(array) - 1;
        if (length == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(length * 3);
        b.append('[');
        int i = 0;
        while (true) {
            b.append(LogHelper.toString(Array.get(array, i)));
            if (i == length) {
                return b.append(']').toString();
            }
            b.append(", ");
            if (i == MAX_COLLECTION_LOG_SIZE - 1) {
                return b.append("...]").toString();
            }
            ++i;
        }
    }
}

