/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.concurrent.CompletableFuture;
import org.redisson.RedissonLockEntry;
import org.redisson.pubsub.PublishSubscribe;
import org.redisson.pubsub.PublishSubscribeService;

public class LockPubSub
extends PublishSubscribe<RedissonLockEntry> {
    public static final Long UNLOCK_MESSAGE = 0L;
    public static final Long READ_UNLOCK_MESSAGE = 1L;

    public LockPubSub(PublishSubscribeService service) {
        super(service);
    }

    @Override
    protected RedissonLockEntry createEntry(CompletableFuture<RedissonLockEntry> newPromise) {
        return new RedissonLockEntry(newPromise);
    }

    @Override
    protected void onMessage(RedissonLockEntry value, Long message) {
        if (message.equals(UNLOCK_MESSAGE)) {
            Runnable runnableToExecute = value.getListeners().poll();
            if (runnableToExecute != null) {
                runnableToExecute.run();
            }
            value.getLatch().release();
        } else if (message.equals(READ_UNLOCK_MESSAGE)) {
            Runnable runnableToExecute;
            while ((runnableToExecute = value.getListeners().poll()) != null) {
                runnableToExecute.run();
            }
            value.getLatch().release(value.getLatch().getQueueLength());
        }
    }
}

