/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.authorization;

import cn.sliew.carp.module.security.spring.authentication.CarpUserDetail;
import cn.sliew.carp.module.security.spring.util.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.stereotype.Service;

@Service(value="carpSecurity")
public class CarpSecurityValidateService {
    public boolean support(HttpServletRequest request) {
        return false;
    }

    public boolean access(Supplier<Authentication> authentication, RequestAuthorizationContext context) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validate(String ... privileges) {
        CarpUserDetail userDetails = SecurityUtil.getCurrentUser();
        if (userDetails == null) {
            return false;
        }
        List privilegeList = userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        if (privilegeList.contains("ROLE_SYS_SUPER_ADMIN")) return true;
        if (!Arrays.stream(privileges).anyMatch(privilegeList::contains)) return false;
        return true;
    }
}

