/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.web;

import cn.sliew.carp.framework.common.security.CarpSecurityContext;
import cn.sliew.carp.framework.common.security.OnlineUserInfo;
import cn.sliew.carp.framework.redis.RedissonUtil;
import cn.sliew.carp.module.security.core.service.SecUserService;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.spring.authentication.CarpUserDetail;
import cn.sliew.carp.module.security.spring.authentication.CarpUserDetailsServiceImpl;
import cn.sliew.carp.module.security.spring.util.SecurityUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class CarpTokenFilter
extends OncePerRequestFilter {
    @Autowired
    private RedissonUtil redisUtil;
    @Autowired
    private SecUserService secUserService;
    @Autowired
    private CarpUserDetailsServiceImpl carpUserDetailsService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        Long userId;
        String token = SecurityUtil.resolveToken(request);
        if (StringUtils.hasText((String)token) && (userId = (Long)this.redisUtil.get("online-token:" + token)) != null) {
            SecUserDTO secUserDTO = this.secUserService.get(userId);
            CarpUserDetail carpUserDetail = this.carpUserDetailsService.fillUserDetails(secUserDTO);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)carpUserDetail, (Object)token, carpUserDetail.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            OnlineUserInfo userInfo = new OnlineUserInfo();
            userInfo.setUserId(userId);
            userInfo.setType(secUserDTO.getType());
            userInfo.setUserName(secUserDTO.getUserName());
            userInfo.setNickName(secUserDTO.getNickName());
            userInfo.setStatus(secUserDTO.getStatus());
            CarpSecurityContext.set((OnlineUserInfo)userInfo);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        CarpSecurityContext.clear();
    }
}

