/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.domain.dao;

import cn.sliew.carp.framework.common.dict.datasource.DataSourceType;
import cn.sliew.carp.module.dataservice.domain.dao.DaoExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.MybatisDaoExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DaoExecutorRegistry
implements InitializingBean {
    private ConcurrentMap<DataSourceType, DaoExecutor> registry = new ConcurrentHashMap<DataSourceType, DaoExecutor>();
    @Autowired
    private MybatisDaoExecutor mybatisDataServiceExecutor;

    public void afterPropertiesSet() throws Exception {
        this.register(DataSourceType.MYSQL, this.mybatisDataServiceExecutor);
    }

    public DaoExecutor get(DataSourceType dataSourceType) {
        return (DaoExecutor)this.registry.get(dataSourceType);
    }

    public void register(DataSourceType dataSourceType, DaoExecutor daoExecutor) {
        this.registry.put(dataSourceType, daoExecutor);
    }

    public void unregister(DataSourceType dataSourceType) {
        this.registry.remove(dataSourceType);
    }
}

