/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.service.impl;

import cn.sliew.carp.module.dataservice.domain.controller.ControllerExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.DaoExecutor;
import cn.sliew.carp.module.dataservice.domain.dao.DaoExecutorRegistry;
import cn.sliew.carp.module.dataservice.service.CarpDataServiceConfigService;
import cn.sliew.carp.module.dataservice.service.CarpDataServiceExecutorService;
import cn.sliew.carp.module.dataservice.service.dto.CarpDataServiceConfigDTO;
import cn.sliew.carp.module.dataservice.service.param.ExecuteParam;
import cn.sliew.carp.module.datasource.service.CarpDsInfoService;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CarpDataServiceExecutorServiceImpl
implements CarpDataServiceExecutorService {
    @Autowired
    private ControllerExecutor controllerExecutor;
    @Autowired
    private DaoExecutorRegistry registry;
    @Autowired
    private CarpDataServiceConfigService dataServiceConfigService;
    @Autowired
    private CarpDsInfoService carpDsInfoService;

    @Override
    public void deploy(Long configId) {
        CarpDataServiceConfigDTO carpDataServiceConfigDTO = this.dataServiceConfigService.get(configId);
        DsInfoDTO dsInfoDTO = this.carpDsInfoService.selectOne(carpDataServiceConfigDTO.getDsId(), true);
        DaoExecutor daoExecutor = this.registry.get(dsInfoDTO.getDsType().getType());
        daoExecutor.register(configId.toString(), carpDataServiceConfigDTO.getQueryScript(), dsInfoDTO);
        this.controllerExecutor.register(configId.toString(), carpDataServiceConfigDTO.getHttpPath());
    }

    @Override
    public void stop(Long configId) {
        CarpDataServiceConfigDTO carpDataServiceConfigDTO = this.dataServiceConfigService.get(configId);
        DsInfoDTO dsInfoDTO = this.carpDsInfoService.selectOne(carpDataServiceConfigDTO.getDsId(), true);
        DaoExecutor daoExecutor = this.registry.get(dsInfoDTO.getDsType().getType());
        daoExecutor.unregister(configId.toString(), dsInfoDTO);
        this.controllerExecutor.unregister(configId.toString());
    }

    @Override
    public Object execute(ExecuteParam param) {
        CarpDataServiceConfigDTO carpDataServiceConfigDTO = this.dataServiceConfigService.get(param.getId());
        DsInfoDTO dsInfoDTO = this.carpDsInfoService.selectOne(carpDataServiceConfigDTO.getDsId(), true);
        DaoExecutor daoExecutor = this.registry.get(dsInfoDTO.getDsType().getType());
        return daoExecutor.execute(param.getId().toString(), carpDataServiceConfigDTO.getQueryScript(), param.getParams(), dsInfoDTO);
    }
}

