/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.typed.internal;

import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.StashOverflowException;
import org.apache.pekko.actor.typed.scaladsl.adapter.package;
import org.apache.pekko.actor.typed.scaladsl.package;
import org.apache.pekko.actor.typed.scaladsl.package$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.typed.internal.BehaviorSetup;
import org.apache.pekko.persistence.typed.internal.InternalProtocol;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy$Drop$;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy$Fail$;
import org.apache.pekko.persistence.typed.internal.StashState;
import org.apache.pekko.util.ConstantFun$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001C\b\u0011!\u0003\r\tA\u0006\u000f\t\u000b\u0011\u0002A\u0011\u0001\u0014\t\u000b)\u0002a\u0011A\u0016\t\u000b\u0005\u0003A\u0011\u0002\"\t\u000b=\u0003A\u0011\u0002)\t\u000bQ\u0003A\u0011C+\t\u000be\u0003A\u0011\u0003.\t\u000b\u0005\u0004A\u0011\u00032\t\u000b\u0011\u0004A\u0011B3\t\u000b1\u0004A\u0011C7\t\u000bA\u0004A\u0011\u0003\u0014\t\u000bE\u0004A\u0011C+\t\u000bI\u0004A\u0011B:\t\u000bY\u0004A\u0011B<\t\u000be\u0004A\u0011\u0002\u0014\u0003\u001fM#\u0018m\u001d5NC:\fw-Z7f]RT!!\u0005\n\u0002\u0011%tG/\u001a:oC2T!a\u0005\u000b\u0002\u000bQL\b/\u001a3\u000b\u0005U1\u0012a\u00039feNL7\u000f^3oG\u0016T!a\u0006\r\u0002\u000bA,7n[8\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u000b\u0005;Ibth\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002OA\u0011q\u0004K\u0005\u0003S\u0001\u0012A!\u00168ji\u0006)1/\u001a;vaV\tA\u0006E\u0003.]AZd(D\u0001\u0011\u0013\ty\u0003CA\u0007CK\"\fg/[8s'\u0016$X\u000f\u001d\t\u0003cIb\u0001\u0001B\u00034\u0001\t\u0007AGA\u0001D#\t)\u0004\b\u0005\u0002 m%\u0011q\u0007\t\u0002\b\u001d>$\b.\u001b8h!\ty\u0012(\u0003\u0002;A\t\u0019\u0011I\\=\u0011\u0005EbD!B\u001f\u0001\u0005\u0004!$!A#\u0011\u0005EzD!\u0002!\u0001\u0005\u0004!$!A*\u0002\u000f\r|g\u000e^3yiV\t1\tE\u0002E\u00152k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003'!S!!\u0013\f\u0002\u000b\u0005\u001cGo\u001c:\n\u0005-+%\u0001D!di>\u00148i\u001c8uKb$\bCA\u0017N\u0013\tq\u0005C\u0001\tJ]R,'O\\1m!J|Go\\2pY\u0006Q1\u000f^1tQN#\u0018\r^3\u0016\u0003E\u0003\"!\f*\n\u0005M\u0003\"AC*uCND7\u000b^1uK\u0006!\u0012n]%oi\u0016\u0014h.\u00197Ti\u0006\u001c\b.R7qif,\u0012A\u0016\t\u0003?]K!\u0001\u0017\u0011\u0003\u000f\t{w\u000e\\3b]\u0006i1\u000f^1tQ&sG/\u001a:oC2$\"aW0\u0011\u0007qkF*D\u0001H\u0013\tqvI\u0001\u0005CK\"\fg/[8s\u0011\u0015\u0001g\u00011\u0001M\u0003\ri7oZ\u0001\ngR\f7\u000f[+tKJ$\"aJ2\t\u000b\u0001<\u0001\u0019\u0001'\u0002\u000bM$\u0018m\u001d5\u0015\u0007\u001d2w\rC\u0003a\u0011\u0001\u0007A\nC\u0003i\u0011\u0001\u0007\u0011.\u0001\u0004ck\u001a4WM\u001d\t\u0004\t*d\u0015BA6F\u0005-\u0019F/Y:i\u0005V4g-\u001a:\u0002\u001bQ\u0014\u00180\u00168ti\u0006\u001c\bn\u00148f)\tYf\u000eC\u0003p\u0013\u0001\u00071,\u0001\u0005cK\"\fg/[8s\u0003))hn\u001d;bg\"\fE\u000e\\\u0001\u0017SN,fn\u001d;bg\"\fE\u000e\\%o!J|wM]3tg\u0006yAn\\4Ti\u0006\u001c\b.T3tg\u0006<W\rF\u0002(iVDQ\u0001\u0019\u0007A\u00021CQ\u0001\u001b\u0007A\u0002%\f\u0011\u0003\\8h+:\u001cH/Y:i\u001b\u0016\u001c8/Y4f)\t9\u0003\u0010C\u0003i\u001b\u0001\u0007\u0011.A\u0007m_\u001e,fn\u001d;bg\"\fE\u000e\u001c\u0015\u0003\u0001m\u0004\"\u0001`@\u000e\u0003uT!A \f\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0002u\u00141\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public interface StashManagement<C, E, S> {
    public BehaviorSetup<C, E, S> setup();

    private ActorContext<InternalProtocol> context() {
        return this.setup().context();
    }

    private StashState stashState() {
        return this.setup().stashState();
    }

    public static /* synthetic */ boolean isInternalStashEmpty$(StashManagement $this) {
        return $this.isInternalStashEmpty();
    }

    default public boolean isInternalStashEmpty() {
        return this.stashState().internalStashBuffer().isEmpty();
    }

    public static /* synthetic */ Behavior stashInternal$(StashManagement $this, InternalProtocol msg) {
        return $this.stashInternal(msg);
    }

    default public Behavior<InternalProtocol> stashInternal(InternalProtocol msg) {
        this.stash(msg, this.stashState().internalStashBuffer());
        return Behaviors$.MODULE$.same();
    }

    public static /* synthetic */ void stashUser$(StashManagement $this, InternalProtocol msg) {
        $this.stashUser(msg);
    }

    default public void stashUser(InternalProtocol msg) {
        this.stash(msg, this.stashState().userStashBuffer());
    }

    private void stash(InternalProtocol msg, StashBuffer<InternalProtocol> buffer) {
        this.logStashMessage(msg, buffer);
        try {
            buffer.stash((Object)msg);
            return;
        }
        catch (StashOverflowException e) {
            StashOverflowStrategy stashOverflowStrategy = this.setup().settings().stashOverflowStrategy();
            if (StashOverflowStrategy$Drop$.MODULE$.equals(stashOverflowStrategy)) {
                String dropName = msg instanceof InternalProtocol.IncomingCommand ? ((InternalProtocol.IncomingCommand)msg).c().getClass().getName() : msg.getClass().getName();
                this.context().log().warn("Stash buffer is full, dropping message [{}]", new Object[]{dropName});
                package.TypedActorSystemOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorSystemOps(this.context().system())).eventStream().publish((Object)Dropped$.MODULE$.apply((Object)msg, "Stash buffer is full", package.TypedActorRefOps$.MODULE$.toClassic$extension(org.apache.pekko.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(this.context().self()))));
                return;
            }
            if (StashOverflowStrategy$Fail$.MODULE$.equals(stashOverflowStrategy)) {
                throw e;
            }
            throw new MatchError((Object)stashOverflowStrategy);
        }
    }

    public static /* synthetic */ Behavior tryUnstashOne$(StashManagement $this, Behavior behavior) {
        return $this.tryUnstashOne((Behavior<InternalProtocol>)behavior);
    }

    default public Behavior<InternalProtocol> tryUnstashOne(Behavior<InternalProtocol> behavior) {
        StashBuffer<InternalProtocol> buffer;
        StashBuffer<InternalProtocol> stashBuffer = buffer = this.stashState().isUnstashAllInProgress() ? this.stashState().userStashBuffer() : this.stashState().internalStashBuffer();
        if (buffer.nonEmpty()) {
            this.logUnstashMessage(buffer);
            this.stashState().decrementUnstashAllProgress();
            return buffer.unstash(behavior, 1, ConstantFun$.MODULE$.scalaIdentityFunction());
        }
        return behavior;
    }

    public static /* synthetic */ void unstashAll$(StashManagement $this) {
        $this.unstashAll();
    }

    default public void unstashAll() {
        if (this.stashState().userStashBuffer().nonEmpty()) {
            this.logUnstashAll();
            this.stashState().startUnstashAll();
            return;
        }
    }

    public static /* synthetic */ boolean isUnstashAllInProgress$(StashManagement $this) {
        return $this.isUnstashAllInProgress();
    }

    default public boolean isUnstashAllInProgress() {
        return this.stashState().isUnstashAllInProgress();
    }

    private void logStashMessage(InternalProtocol msg, StashBuffer<InternalProtocol> buffer) {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debugN$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Stashing message to {} stash: [{}] ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer == this.stashState().internalStashBuffer() ? "internal" : "user", msg}));
            return;
        }
    }

    private void logUnstashMessage(StashBuffer<InternalProtocol> buffer) {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debugN$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Unstashing message from {} stash: [{}]", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buffer == this.stashState().internalStashBuffer() ? "internal" : "user", buffer.head()}));
            return;
        }
    }

    private void logUnstashAll() {
        if (this.setup().settings().logOnStashing()) {
            package.LoggerOps$.MODULE$.debug2$extension0(package$.MODULE$.LoggerOps(this.setup().internalLogger()), "Unstashing all [{}] messages from user stash, first is: [{}]", (Object)BoxesRunTime.boxToInteger((int)this.stashState().userStashBuffer().size()), this.stashState().userStashBuffer().head());
            return;
        }
    }

    public static void $init$(StashManagement $this) {
    }
}

