/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.persistence;

import cn.sliew.carp.framework.common.model.BaseDTO;
import cn.sliew.carp.framework.common.model.PageParam;
import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.persistence.AbstractPersistenceService;
import cn.sliew.carp.module.persistence.BaseResourceVisitor;
import cn.sliew.carp.module.persistence.api.selectors.Selector;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class MemoryPersistenceService<R extends BaseDTO>
extends AbstractPersistenceService<Long, R> {
    private final ConcurrentMap<Long, R> map = new ConcurrentHashMap<Long, R>();
    private final BaseResourceVisitor resourceVisitor;

    public MemoryPersistenceService(BaseResourceVisitor resourceVisitor) {
        this.resourceVisitor = resourceVisitor;
    }

    @Override
    public Iterable<R> select(Selector selector) {
        Predicate predicate = selector.accept(this.resourceVisitor);
        Preconditions.checkNotNull((Object)predicate);
        return Iterables.filter(this.map.values(), predicate::test);
    }

    @Override
    public PageResult<R> page(PageParam param, Selector selector) {
        return null;
    }

    @Override
    public Optional<R> get(Long id) {
        return Optional.ofNullable((BaseDTO)this.map.get(id));
    }

    @Override
    protected void doAdd(R resource) {
        this.map.putIfAbsent(resource.getId(), resource);
    }

    @Override
    protected void doUpdate(Long id, R resource) {
        this.map.put(id, resource);
    }

    @Override
    protected void doDelete(Long id) {
        this.map.remove(id);
    }
}

