/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Capability;
import feign.Client;
import feign.Contract;
import feign.ExceptionPropagationPolicy;
import feign.Feign;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.ResponseInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.openfeign.FeignBuilderCustomizer;
import org.springframework.cloud.openfeign.FeignClientFactory;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.FeignErrorDecoderFactory;
import org.springframework.cloud.openfeign.FeignLoggerFactory;
import org.springframework.cloud.openfeign.PropertyBasedTarget;
import org.springframework.cloud.openfeign.RefreshableHardCodedTarget;
import org.springframework.cloud.openfeign.RefreshableUrl;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware,
BeanFactoryAware {
    private static final Log LOG = LogFactory.getLog(FeignClientFactoryBean.class);
    private Class<?> type;
    private String name;
    private String url;
    private String contextId;
    private String path;
    private boolean dismiss404;
    private boolean inheritParentContext = true;
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;
    private int readTimeoutMillis = new Request.Options().readTimeoutMillis();
    private int connectTimeoutMillis = new Request.Options().connectTimeoutMillis();
    private boolean followRedirects = new Request.Options().isFollowRedirects();
    private boolean refreshableClient = false;
    private final List<FeignBuilderCustomizer> additionalCustomizers = new ArrayList<FeignBuilderCustomizer>();
    private String[] qualifiers = new String[0];

    public FeignClientFactoryBean() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating a FeignClientFactoryBean.");
        }
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.contextId, (String)"Context id must be set");
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    protected Feign.Builder feign(FeignClientFactory context) {
        FeignLoggerFactory loggerFactory = this.get(context, FeignLoggerFactory.class);
        Logger logger = loggerFactory.create(this.type);
        Feign.Builder builder = this.get(context, Feign.Builder.class).logger(logger).encoder(this.get(context, Encoder.class)).decoder(this.get(context, Decoder.class)).contract(this.get(context, Contract.class));
        this.configureFeign(context, builder);
        return builder;
    }

    private void applyBuildCustomizers(FeignClientFactory context, Feign.Builder builder) {
        Map customizerMap = context.getInstances(this.contextId, FeignBuilderCustomizer.class);
        if (customizerMap != null) {
            customizerMap.values().stream().sorted(AnnotationAwareOrderComparator.INSTANCE).forEach(feignBuilderCustomizer -> feignBuilderCustomizer.customize(builder));
        }
        this.additionalCustomizers.forEach(customizer -> customizer.customize(builder));
    }

    protected void configureFeign(FeignClientFactory context, Feign.Builder builder) {
        FeignClientProperties properties = this.beanFactory != null ? (FeignClientProperties)this.beanFactory.getBean(FeignClientProperties.class) : (FeignClientProperties)this.applicationContext.getBean(FeignClientProperties.class);
        FeignClientConfigurer feignClientConfigurer = this.getOptional(context, FeignClientConfigurer.class);
        this.setInheritParentContext(feignClientConfigurer.inheritParentConfiguration());
        if (properties != null && this.inheritParentContext) {
            if (properties.isDefaultToProperties()) {
                this.configureUsingConfiguration(context, builder);
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), properties.getConfig().get(this.contextId), builder);
            } else {
                this.configureUsingProperties(properties.getConfig().get(properties.getDefaultConfig()), properties.getConfig().get(this.contextId), builder);
                this.configureUsingConfiguration(context, builder);
            }
            this.configureDefaultRequestElements(properties.getConfig().get(properties.getDefaultConfig()), properties.getConfig().get(this.contextId), builder);
        } else {
            this.configureUsingConfiguration(context, builder);
        }
    }

    protected void configureUsingConfiguration(FeignClientFactory context, Feign.Builder builder) {
        Map<String, Capability> capabilities;
        ExceptionPropagationPolicy exceptionPropagationPolicy;
        QueryMapEncoder queryMapEncoder;
        ResponseInterceptor responseInterceptor;
        Map<String, RequestInterceptor> requestInterceptors;
        ErrorDecoder errorDecoder;
        Retryer retryer;
        Logger.Level level = this.getInheritedAwareOptional(context, Logger.Level.class);
        if (level != null) {
            builder.logLevel(level);
        }
        if ((retryer = this.getInheritedAwareOptional(context, Retryer.class)) != null) {
            builder.retryer(retryer);
        }
        if ((errorDecoder = this.getInheritedAwareOptional(context, ErrorDecoder.class)) != null) {
            builder.errorDecoder(errorDecoder);
        } else {
            FeignErrorDecoderFactory errorDecoderFactory = this.getOptional(context, FeignErrorDecoderFactory.class);
            if (errorDecoderFactory != null) {
                ErrorDecoder factoryErrorDecoder = errorDecoderFactory.create(this.type);
                builder.errorDecoder(factoryErrorDecoder);
            }
        }
        Request.Options options = this.getInheritedAwareOptional(context, Request.Options.class);
        if (options == null) {
            options = this.getOptionsByName(context, this.contextId);
        }
        if (options != null) {
            builder.options(options);
            this.readTimeoutMillis = options.readTimeoutMillis();
            this.connectTimeoutMillis = options.connectTimeoutMillis();
            this.followRedirects = options.isFollowRedirects();
        }
        if ((requestInterceptors = this.getInheritedAwareInstances(context, RequestInterceptor.class)) != null) {
            ArrayList<RequestInterceptor> interceptors = new ArrayList<RequestInterceptor>(requestInterceptors.values());
            AnnotationAwareOrderComparator.sort(interceptors);
            builder.requestInterceptors(interceptors);
        }
        if ((responseInterceptor = this.getInheritedAwareOptional(context, ResponseInterceptor.class)) != null) {
            builder.responseInterceptor(responseInterceptor);
        }
        if ((queryMapEncoder = this.getInheritedAwareOptional(context, QueryMapEncoder.class)) != null) {
            builder.queryMapEncoder(queryMapEncoder);
        }
        if (this.dismiss404) {
            builder.dismiss404();
        }
        if ((exceptionPropagationPolicy = this.getInheritedAwareOptional(context, ExceptionPropagationPolicy.class)) != null) {
            builder.exceptionPropagationPolicy(exceptionPropagationPolicy);
        }
        if ((capabilities = this.getInheritedAwareInstances(context, Capability.class)) != null) {
            capabilities.values().stream().sorted((Comparator<Capability>)AnnotationAwareOrderComparator.INSTANCE).forEach(arg_0 -> ((Feign.Builder)builder).addCapability(arg_0));
        }
    }

    protected void configureUsingProperties(FeignClientProperties.FeignClientConfiguration baseConfig, FeignClientProperties.FeignClientConfiguration finalConfig, Feign.Builder builder) {
        Boolean dismiss404;
        this.configureUsingProperties(baseConfig, builder);
        this.configureUsingProperties(finalConfig, builder);
        Boolean bl = finalConfig != null && finalConfig.getDismiss404() != null ? finalConfig.getDismiss404() : (dismiss404 = baseConfig != null && baseConfig.getDismiss404() != null ? baseConfig.getDismiss404() : null);
        if (dismiss404 != null && dismiss404.booleanValue()) {
            builder.dismiss404();
        }
    }

    protected void configureUsingProperties(FeignClientProperties.FeignClientConfiguration config, Feign.Builder builder) {
        if (config == null) {
            return;
        }
        if (config.getLoggerLevel() != null) {
            builder.logLevel(config.getLoggerLevel());
        }
        if (!this.refreshableClient) {
            this.connectTimeoutMillis = config.getConnectTimeout() != null ? config.getConnectTimeout() : this.connectTimeoutMillis;
            this.readTimeoutMillis = config.getReadTimeout() != null ? config.getReadTimeout() : this.readTimeoutMillis;
            this.followRedirects = config.isFollowRedirects() != null ? config.isFollowRedirects() : this.followRedirects;
            builder.options(new Request.Options((long)this.connectTimeoutMillis, TimeUnit.MILLISECONDS, (long)this.readTimeoutMillis, TimeUnit.MILLISECONDS, this.followRedirects));
        }
        if (config.getRetryer() != null) {
            Retryer retryer = this.getOrInstantiate(config.getRetryer());
            builder.retryer(retryer);
        }
        if (config.getErrorDecoder() != null) {
            ErrorDecoder errorDecoder = this.getOrInstantiate(config.getErrorDecoder());
            builder.errorDecoder(errorDecoder);
        }
        if (config.getRequestInterceptors() != null && !config.getRequestInterceptors().isEmpty()) {
            for (Class<RequestInterceptor> bean : config.getRequestInterceptors()) {
                RequestInterceptor interceptor = this.getOrInstantiate(bean);
                builder.requestInterceptor(interceptor);
            }
        }
        if (config.getResponseInterceptor() != null) {
            builder.responseInterceptor(this.getOrInstantiate(config.getResponseInterceptor()));
        }
        if (Objects.nonNull(config.getEncoder())) {
            builder.encoder(this.getOrInstantiate(config.getEncoder()));
        }
        if (Objects.nonNull(config.getDecoder())) {
            builder.decoder(this.getOrInstantiate(config.getDecoder()));
        }
        if (Objects.nonNull(config.getContract())) {
            builder.contract(this.getOrInstantiate(config.getContract()));
        }
        if (Objects.nonNull(config.getExceptionPropagationPolicy())) {
            builder.exceptionPropagationPolicy(config.getExceptionPropagationPolicy());
        }
        if (config.getCapabilities() != null) {
            config.getCapabilities().stream().map(this::getOrInstantiate).forEach(arg_0 -> ((Feign.Builder)builder).addCapability(arg_0));
        }
        if (config.getQueryMapEncoder() != null) {
            builder.queryMapEncoder(this.getOrInstantiate(config.getQueryMapEncoder()));
        }
    }

    protected void configureDefaultRequestElements(FeignClientProperties.FeignClientConfiguration defaultConfig, FeignClientProperties.FeignClientConfiguration clientConfig, Feign.Builder builder) {
        HashMap<String, Collection<String>> defaultRequestHeaders = new HashMap<String, Collection<String>>();
        if (defaultConfig != null) {
            defaultConfig.getDefaultRequestHeaders().forEach((k, v) -> defaultRequestHeaders.put((String)k, new ArrayList(v)));
        }
        if (clientConfig != null) {
            clientConfig.getDefaultRequestHeaders().forEach((k, v) -> defaultRequestHeaders.put((String)k, new ArrayList(v)));
        }
        if (!defaultRequestHeaders.isEmpty()) {
            this.addDefaultRequestHeaders(defaultRequestHeaders, builder);
        }
        HashMap<String, Collection<String>> defaultQueryParameters = new HashMap<String, Collection<String>>();
        if (defaultConfig != null) {
            defaultConfig.getDefaultQueryParameters().forEach((k, v) -> defaultQueryParameters.put((String)k, new ArrayList(v)));
        }
        if (clientConfig != null) {
            clientConfig.getDefaultQueryParameters().forEach((k, v) -> defaultQueryParameters.put((String)k, new ArrayList(v)));
        }
        if (!defaultQueryParameters.isEmpty()) {
            this.addDefaultQueryParams(defaultQueryParameters, builder);
        }
    }

    private void addDefaultQueryParams(Map<String, Collection<String>> defaultQueryParameters, Feign.Builder builder) {
        builder.requestInterceptor(requestTemplate -> {
            Map queries = requestTemplate.queries();
            defaultQueryParameters.keySet().forEach(key -> {
                if (!queries.containsKey(key)) {
                    requestTemplate.query(key, (Iterable)defaultQueryParameters.get(key));
                }
            });
        });
    }

    private void addDefaultRequestHeaders(Map<String, Collection<String>> defaultRequestHeaders, Feign.Builder builder) {
        builder.requestInterceptor(requestTemplate -> {
            Map headers = requestTemplate.headers();
            defaultRequestHeaders.keySet().forEach(key -> {
                if (!headers.containsKey(key)) {
                    requestTemplate.header(key, (Iterable)defaultRequestHeaders.get(key));
                }
            });
        });
    }

    private <T> T getOrInstantiate(Class<T> tClass) {
        try {
            return (T)(this.beanFactory != null ? this.beanFactory.getBean(tClass) : this.applicationContext.getBean(tClass));
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)BeanUtils.instantiateClass(tClass);
        }
    }

    protected <T> T get(FeignClientFactory context, Class<T> type) {
        Object instance = context.getInstance(this.contextId, type);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.contextId);
        }
        return (T)instance;
    }

    protected <T> T getOptional(FeignClientFactory context, Class<T> type) {
        return (T)context.getInstance(this.contextId, type);
    }

    protected <T> T getInheritedAwareOptional(FeignClientFactory context, Class<T> type) {
        if (this.inheritParentContext) {
            return this.getOptional(context, type);
        }
        return context.getInstanceWithoutAncestors(this.contextId, type);
    }

    protected <T> Map<String, T> getInheritedAwareInstances(FeignClientFactory context, Class<T> type) {
        if (this.inheritParentContext) {
            return context.getInstances(this.contextId, type);
        }
        return context.getInstancesWithoutAncestors(this.contextId, type);
    }

    protected <T> T loadBalance(Feign.Builder builder, FeignClientFactory context, Target.HardCodedTarget<T> target) {
        Client client = this.getOptional(context, Client.class);
        if (client != null) {
            builder.client(client);
            this.applyBuildCustomizers(context, builder);
            Targeter targeter = this.get(context, Targeter.class);
            return targeter.target(this, builder, context, target);
        }
        throw new IllegalStateException("No Feign Client for loadBalancing defined. Did you forget to include spring-cloud-starter-loadbalancer?");
    }

    protected Request.Options getOptionsByName(FeignClientFactory context, String contextId) {
        if (this.refreshableClient) {
            return context.getInstance(contextId, Request.Options.class.getCanonicalName() + "-" + contextId, Request.Options.class);
        }
        return null;
    }

    public Object getObject() {
        return this.getTarget();
    }

    <T> T getTarget() {
        Client client;
        FeignClientFactory feignClientFactory = this.beanFactory != null ? (FeignClientFactory)((Object)this.beanFactory.getBean(FeignClientFactory.class)) : (FeignClientFactory)((Object)this.applicationContext.getBean(FeignClientFactory.class));
        Feign.Builder builder = this.feign(feignClientFactory);
        if (!StringUtils.hasText((String)this.url) && !this.isUrlAvailableInConfig(this.contextId)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("For '" + this.name + "' URL not provided. Will try picking an instance via load-balancing."));
            }
            this.url = !this.name.startsWith("http://") && !this.name.startsWith("https://") ? "http://" + this.name : this.name;
            this.url = this.url + this.cleanPath();
            return this.loadBalance(builder, feignClientFactory, new Target.HardCodedTarget(this.type, this.name, this.url));
        }
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = "http://" + this.url;
        }
        if ((client = this.getOptional(feignClientFactory, Client.class)) != null) {
            if (client instanceof FeignBlockingLoadBalancerClient) {
                client = ((FeignBlockingLoadBalancerClient)client).getDelegate();
            }
            if (client instanceof RetryableFeignBlockingLoadBalancerClient) {
                client = ((RetryableFeignBlockingLoadBalancerClient)client).getDelegate();
            }
            builder.client(client);
        }
        this.applyBuildCustomizers(feignClientFactory, builder);
        Targeter targeter = this.get(feignClientFactory, Targeter.class);
        return targeter.target(this, builder, feignClientFactory, this.resolveTarget(feignClientFactory, this.contextId, this.url));
    }

    private String cleanPath() {
        if (this.path == null) {
            return "";
        }
        Object path = this.path.trim();
        if (StringUtils.hasLength((String)path)) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }

    private <T> Target.HardCodedTarget<T> resolveTarget(FeignClientFactory context, String contextId, String url) {
        RefreshableUrl refreshableUrl;
        if (StringUtils.hasText((String)url)) {
            return new Target.HardCodedTarget(this.type, this.name, url + this.cleanPath());
        }
        if (this.refreshableClient && Objects.nonNull(refreshableUrl = context.getInstance(contextId, RefreshableUrl.class.getCanonicalName() + "-" + contextId, RefreshableUrl.class)) && StringUtils.hasText((String)refreshableUrl.getUrl())) {
            return new RefreshableHardCodedTarget(this.type, this.name, refreshableUrl, this.cleanPath());
        }
        FeignClientProperties.FeignClientConfiguration config = this.findConfigByKey(contextId);
        if (Objects.isNull(config) || !StringUtils.hasText((String)config.getUrl())) {
            throw new IllegalStateException("Provide Feign client URL either in @FeignClient() or in config properties.");
        }
        return new PropertyBasedTarget(this.type, this.name, config, this.cleanPath());
    }

    private boolean isUrlAvailableInConfig(String contextId) {
        FeignClientProperties.FeignClientConfiguration config = this.findConfigByKey(contextId);
        return Objects.nonNull(config) && StringUtils.hasText((String)config.getUrl());
    }

    private FeignClientProperties.FeignClientConfiguration findConfigByKey(String configKey) {
        FeignClientProperties properties = this.beanFactory != null ? (FeignClientProperties)this.beanFactory.getBean(FeignClientProperties.class) : (FeignClientProperties)this.applicationContext.getBean(FeignClientProperties.class);
        return properties.getConfig().get(configKey);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDismiss404() {
        return this.dismiss404;
    }

    public void setDismiss404(boolean dismiss404) {
        this.dismiss404 = dismiss404;
    }

    public boolean isInheritParentContext() {
        return this.inheritParentContext;
    }

    public void setInheritParentContext(boolean inheritParentContext) {
        this.inheritParentContext = inheritParentContext;
    }

    public void addCustomizer(FeignBuilderCustomizer customizer) {
        this.additionalCustomizers.add(customizer);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
        this.beanFactory = context;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public void setRefreshableClient(boolean refreshableClient) {
        this.refreshableClient = refreshableClient;
    }

    public String[] getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(String[] qualifiers) {
        this.qualifiers = qualifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientFactoryBean that = (FeignClientFactoryBean)o;
        return Objects.equals(this.applicationContext, that.applicationContext) && Objects.equals(this.beanFactory, that.beanFactory) && this.dismiss404 == that.dismiss404 && this.inheritParentContext == that.inheritParentContext && Objects.equals(this.fallback, that.fallback) && Objects.equals(this.fallbackFactory, that.fallbackFactory) && Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.url, that.url) && Objects.equals(this.connectTimeoutMillis, that.connectTimeoutMillis) && Objects.equals(this.readTimeoutMillis, that.readTimeoutMillis) && Objects.equals(this.followRedirects, that.followRedirects) && Objects.equals(this.refreshableClient, that.refreshableClient);
    }

    public int hashCode() {
        return Objects.hash(this.applicationContext, this.beanFactory, this.dismiss404, this.inheritParentContext, this.fallback, this.fallbackFactory, this.name, this.path, this.type, this.url, this.readTimeoutMillis, this.connectTimeoutMillis, this.followRedirects, this.refreshableClient);
    }

    public String toString() {
        return "FeignClientFactoryBean{" + "type=" + this.type + ", " + "name='" + this.name + "', " + "url='" + this.url + "', " + "path='" + this.path + "', " + "dismiss404=" + this.dismiss404 + ", " + "inheritParentContext=" + this.inheritParentContext + ", " + "applicationContext=" + this.applicationContext + ", " + "beanFactory=" + this.beanFactory + ", " + "fallback=" + this.fallback + ", " + "fallbackFactory=" + this.fallbackFactory + "}" + "connectTimeoutMillis=" + this.connectTimeoutMillis + "}" + "readTimeoutMillis=" + this.readTimeoutMillis + "}" + "followRedirects=" + this.followRedirects + "refreshableClient=" + this.refreshableClient + "}";
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

