/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.impl;

import com.alibaba.cola.statemachine.Transition;
import com.alibaba.cola.statemachine.impl.StateMachineException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EventTransitions<S, E, C> {
    private HashMap<E, List<Transition<S, E, C>>> eventTransitions = new HashMap();

    public void put(E event, Transition<S, E, C> transition) {
        if (this.eventTransitions.get(event) == null) {
            ArrayList<Transition<S, E, C>> transitions = new ArrayList<Transition<S, E, C>>();
            transitions.add(transition);
            this.eventTransitions.put(event, transitions);
        } else {
            List<Transition<S, Transition<S, E, C>, C>> existingTransitions = this.eventTransitions.get(event);
            this.verify(existingTransitions, transition);
            existingTransitions.add(transition);
        }
    }

    private void verify(List<Transition<S, E, C>> existingTransitions, Transition<S, E, C> newTransition) {
        for (Transition<S, E, C> transition : existingTransitions) {
            if (!transition.equals(newTransition)) continue;
            throw new StateMachineException(transition + " already Exist, you can not add another one");
        }
    }

    public List<Transition<S, E, C>> get(E event) {
        return this.eventTransitions.get(event);
    }

    public List<Transition<S, E, C>> allTransitions() {
        ArrayList<Transition<S, Transition<S, E, C>, C>> allTransitions = new ArrayList<Transition<S, Transition<S, E, C>, C>>();
        for (List<Transition<S, E, C>> transitions : this.eventTransitions.values()) {
            allTransitions.addAll(transitions);
        }
        return allTransitions;
    }
}

