/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.starter;

import java.util.List;
import java.util.stream.Collectors;
import org.redisson.misc.RedisURI;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;

public class PropertiesRedisConnectionDetails
implements RedisConnectionDetails {
    private final RedisProperties properties;

    PropertiesRedisConnectionDetails(RedisProperties properties) {
        this.properties = properties;
    }

    public String getUsername() {
        if (this.properties.getUrl() != null) {
            RedisURI uri = this.parseURL();
            return uri.getUsername();
        }
        return this.properties.getUsername();
    }

    public String getPassword() {
        if (this.properties.getUrl() != null) {
            RedisURI uri = this.parseURL();
            return uri.getPassword();
        }
        return this.properties.getPassword();
    }

    public RedisConnectionDetails.Standalone getStandalone() {
        if (this.properties.getUrl() != null) {
            RedisURI uri = this.parseURL();
            return RedisConnectionDetails.Standalone.of((String)uri.getHost(), (int)uri.getPort(), (int)this.properties.getDatabase());
        }
        return RedisConnectionDetails.Standalone.of((String)this.properties.getHost(), (int)this.properties.getPort(), (int)this.properties.getDatabase());
    }

    private RedisURI parseURL() {
        if (this.properties.getUrl() != null) {
            return new RedisURI(this.properties.getUrl());
        }
        return null;
    }

    public RedisConnectionDetails.Sentinel getSentinel() {
        final RedisProperties.Sentinel sentinel = this.properties.getSentinel();
        if (sentinel == null) {
            return null;
        }
        return new RedisConnectionDetails.Sentinel(){

            public int getDatabase() {
                return PropertiesRedisConnectionDetails.this.properties.getDatabase();
            }

            public String getMaster() {
                return sentinel.getMaster();
            }

            public List<RedisConnectionDetails.Node> getNodes() {
                return sentinel.getNodes().stream().map(x$0 -> PropertiesRedisConnectionDetails.this.asNode(x$0)).collect(Collectors.toList());
            }

            public String getUsername() {
                return sentinel.getUsername();
            }

            public String getPassword() {
                return sentinel.getPassword();
            }
        };
    }

    public RedisConnectionDetails.Cluster getCluster() {
        RedisProperties.Cluster cluster = this.properties.getCluster();
        List nodes = cluster != null ? cluster.getNodes().stream().map(this::asNode).collect(Collectors.toList()) : null;
        return nodes != null ? () -> nodes : null;
    }

    private RedisConnectionDetails.Node asNode(String node) {
        String[] components = node.split(":");
        return new RedisConnectionDetails.Node(components[0], Integer.parseInt(components[1]));
    }
}

