/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.dataservice.domain.dao.mybatis;

import cn.sliew.carp.framework.common.model.PageResult;
import cn.sliew.carp.module.dataservice.domain.dao.mybatis.mapper.MybatisMapper;
import cn.sliew.carp.module.datasource.service.dto.DsInfoDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class JdbcExecutor {
    private static final Integer PAGE_NUM = 1;
    private static final Integer PAGE_SIZE = 200;
    private final MybatisMapper mybatisMapper;

    public JdbcExecutor(MybatisMapper mybatisMapper) {
        this.mybatisMapper = mybatisMapper;
    }

    public Object selectOne(DsInfoDTO dsInfoDTO, String sql, Object params) {
        List maps = this.selectList(dsInfoDTO, sql, params);
        return maps.size() > 0 ? maps.get(0) : Collections.emptyMap();
    }

    public List selectList(DsInfoDTO dsInfoDTO, String sql, Object params) {
        PageResult page = this.selectPage(dsInfoDTO, sql, params, PAGE_NUM, PAGE_SIZE);
        return page.getRecords();
    }

    public PageResult selectPage(DsInfoDTO dsInfoDTO, String sql, Object params, int pageNum, int pageSize) {
        Map<String, Object> paramsMap = this.buildParams(sql, params);
        return (PageResult)this.doSwitchDataSource(dsInfoDTO, () -> {
            List<Map<String, Object>> list = this.mybatisMapper.select(paramsMap);
            PageResult pageResult = new PageResult(Long.valueOf(pageNum), Long.valueOf(pageSize), Long.valueOf(Long.MAX_VALUE));
            pageResult.setRecords(list);
            return pageResult;
        });
    }

    public int insert(DsInfoDTO dsInfoDTO, String sql, Object params) {
        Map<String, Object> paramsMap = this.buildParams(sql, params);
        return (Integer)this.doSwitchDataSource(dsInfoDTO, () -> this.mybatisMapper.insert(paramsMap));
    }

    public int update(DsInfoDTO dsInfoDTO, String sql, Object params) {
        Map<String, Object> paramsMap = this.buildParams(sql, params);
        return (Integer)this.doSwitchDataSource(dsInfoDTO, () -> this.mybatisMapper.update(paramsMap));
    }

    public int delete(DsInfoDTO dsInfoDTO, String sql, Object params) {
        Map<String, Object> paramsMap = this.buildParams(sql, params);
        return (Integer)this.doSwitchDataSource(dsInfoDTO, () -> this.mybatisMapper.delete(paramsMap));
    }

    private Map<String, Object> buildParams(String sql, Object params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("_@_CARP_SQL_SCRIPT_@_", sql);
        if (params instanceof Map) {
            Map map = (Map)params;
            paramsMap.putAll(map);
        }
        return paramsMap;
    }

    private Object doSwitchDataSource(DsInfoDTO dsInfoDTO, Supplier supplier) {
        return supplier.get();
    }
}

