/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.log.enums;

import cn.sliew.carp.framework.log.annotation.WebLog;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;

public enum LogEntity {
    HTTP_REQUEST_HEADERS,
    HTTP_REQUEST_BODY,
    HTTP_REQUEST_PARAM,
    HTTP_RESPONSE_BODY;


    public static Set<LogEntity> getIncludes(WebLog methodLog, WebLog classLog) {
        Set<LogEntity> classIncludes = LogEntity.getClassIncludes(classLog);
        return LogEntity.getMethodIncludes(classIncludes, methodLog);
    }

    private static Set<LogEntity> getClassIncludes(WebLog classLog) {
        if (Objects.isNull(classLog)) {
            return Collections.emptySet();
        }
        Optional<Set> includeOptional = Optional.ofNullable(classLog).map(WebLog::includes).filter(includes -> ArrayUtils.isNotEmpty((Object[])includes)).map(Set::of);
        if (includeOptional.isPresent()) {
            return includeOptional.get();
        }
        HashSet<LogEntity> includeSet = new HashSet<LogEntity>(Arrays.asList(LogEntity.values()));
        Optional.ofNullable(classLog).map(WebLog::excludes).filter(excludes -> ArrayUtils.isNotEmpty((Object[])excludes)).map(Set::of).ifPresent(excludes -> includeSet.removeAll((Collection<?>)excludes));
        return includeSet;
    }

    private static Set<LogEntity> getMethodIncludes(Set<LogEntity> classIncludeSet, WebLog methodLog) {
        if (Objects.isNull(methodLog)) {
            return classIncludeSet;
        }
        HashSet<LogEntity> methodIncludeSet = new HashSet<LogEntity>();
        Optional<Set> includeOptional = Optional.ofNullable(methodLog).map(WebLog::includes).filter(includes -> ArrayUtils.isNotEmpty((Object[])includes)).map(Set::of);
        if (includeOptional.isPresent()) {
            methodIncludeSet.addAll(classIncludeSet);
            methodIncludeSet.addAll(includeOptional.get());
            return methodIncludeSet;
        }
        if (CollectionUtils.isEmpty(classIncludeSet)) {
            methodIncludeSet.addAll(Arrays.asList(LogEntity.values()));
        } else {
            methodIncludeSet.addAll(classIncludeSet);
        }
        Optional.ofNullable(methodLog).map(WebLog::excludes).filter(excludes -> ArrayUtils.isNotEmpty((Object[])excludes)).map(Set::of).ifPresent(excludes -> methodIncludeSet.removeAll((Collection<?>)excludes));
        return methodIncludeSet;
    }
}

