/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.security.spring.service.impl;

import cn.sliew.carp.framework.common.enums.ResponseCodeEnum;
import cn.sliew.carp.framework.common.security.CarpSecurityContext;
import cn.sliew.carp.framework.common.security.OnlineUserInfo;
import cn.sliew.carp.framework.common.util.UUIDUtil;
import cn.sliew.carp.framework.exception.SliewException;
import cn.sliew.carp.framework.redis.RedissonUtil;
import cn.sliew.carp.framework.web.util.I18nUtil;
import cn.sliew.carp.module.security.core.service.SecAuthenticationService;
import cn.sliew.carp.module.security.core.service.SecAuthorizationService;
import cn.sliew.carp.module.security.core.service.SecCaptchaService;
import cn.sliew.carp.module.security.core.service.SecUserService;
import cn.sliew.carp.module.security.core.service.dto.OnlineUserVO;
import cn.sliew.carp.module.security.core.service.dto.SecRoleDTO;
import cn.sliew.carp.module.security.core.service.dto.SecUserDTO;
import cn.sliew.carp.module.security.core.service.param.authenticate.LoginParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecResourceWebListByRoleParam;
import cn.sliew.carp.module.security.core.service.param.authorize.SecRoleListByUserParam;
import cn.sliew.carp.module.security.spring.authentication.CarpPasswordEncoder;
import cn.sliew.carp.module.security.spring.authentication.CarpUserDetail;
import cn.sliew.carp.module.security.spring.util.CookieUtil;
import cn.sliew.carp.module.security.spring.util.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class SecAuthenticationServiceImpl
implements SecAuthenticationService {
    @Autowired
    private RedissonUtil redisUtil;
    @Autowired
    private SecUserService secUserService;
    @Autowired
    private SecAuthorizationService secAuthorizationService;
    @Autowired
    private SecCaptchaService secCaptchaService;
    @Autowired
    private AuthenticationManagerBuilder authenticationManagerBuilder;

    public OnlineUserVO login(LoginParam param, HttpServletRequest request, HttpServletResponse response) {
        if (!this.secCaptchaService.verityCaptcha(param.getUuid(), param.getAuthCode())) {
            throw new SliewException(ResponseCodeEnum.ERROR_CUSTOM.getCode(), I18nUtil.get((String)"response.error.authCode"));
        }
        try {
            this.authenticateForm(param);
            OnlineUserVO onlineUserVO = new OnlineUserVO();
            onlineUserVO.setToken(UUIDUtil.randomUUId());
            CarpUserDetail userDetail = SecurityUtil.getCurrentUser();
            SecUserDTO secUserDTO = userDetail.getUser();
            onlineUserVO.setUserId(secUserDTO.getId());
            onlineUserVO.setUserName(secUserDTO.getUserName());
            onlineUserVO.setNickName(secUserDTO.getNickName());
            onlineUserVO.setAvatar(secUserDTO.getAvatar());
            onlineUserVO.setEmail(secUserDTO.getEmail());
            onlineUserVO.setPhone(secUserDTO.getPhone());
            onlineUserVO.setType(secUserDTO.getType().getValue());
            onlineUserVO.setStatus(secUserDTO.getStatus().getValue());
            onlineUserVO.setRoles(userDetail.getRoles());
            onlineUserVO.setResourceWebs(userDetail.getResourceWebs());
            this.redisUtil.set("online-token:" + onlineUserVO.getToken(), (Object)onlineUserVO.getUserId(), Duration.ofHours(12L));
            CookieUtil.addCookie(response, onlineUserVO.getToken());
            return onlineUserVO;
        }
        catch (BadCredentialsException | InternalAuthenticationServiceException e) {
            throw new SliewException(ResponseCodeEnum.ERROR_CUSTOM.getCode(), I18nUtil.get((String)"response.error.login.password"));
        }
    }

    private void authenticateForm(LoginParam param) {
        Optional optional = this.secUserService.getByUserName(param.getUserName());
        if (optional.isEmpty()) {
            throw new UsernameNotFoundException(I18nUtil.get((String)"response.error.login.password"));
        }
        SecUserDTO secUserDTO = (SecUserDTO)optional.get();
        String rawPassword = param.getPassword() + CarpPasswordEncoder.SPLIT + secUserDTO.getSalt();
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)param.getUserName(), (Object)rawPassword);
        Authentication authentication = ((AuthenticationManager)this.authenticationManagerBuilder.getObject()).authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.clearCookieByName(request, response);
        String token = SecurityUtil.resolveToken(request);
        this.redisUtil.remove("online-token:" + token);
        return true;
    }

    public OnlineUserVO getOnlineUser() {
        OnlineUserInfo userInfo = CarpSecurityContext.get();
        SecUserDTO secUserDTO = this.secUserService.get(userInfo.getUserId());
        return this.getOnlineUser(secUserDTO);
    }

    public OnlineUserVO getOnlineUser(SecUserDTO secUserDTO) {
        OnlineUserVO onlineUserVO = new OnlineUserVO();
        onlineUserVO.setUserId(secUserDTO.getId());
        onlineUserVO.setUserName(secUserDTO.getUserName());
        onlineUserVO.setNickName(secUserDTO.getNickName());
        onlineUserVO.setAvatar(secUserDTO.getAvatar());
        onlineUserVO.setEmail(secUserDTO.getEmail());
        onlineUserVO.setPhone(secUserDTO.getPhone());
        onlineUserVO.setType(secUserDTO.getType().getValue());
        onlineUserVO.setStatus(secUserDTO.getStatus().getValue());
        SecRoleListByUserParam userParam = new SecRoleListByUserParam();
        userParam.setUserId(secUserDTO.getId());
        onlineUserVO.setRoles(new HashSet(this.secAuthorizationService.listAllAuthorizedRolesByUserId(userParam)));
        HashSet resourceWebs = new HashSet();
        for (SecRoleDTO secRoleDTO : onlineUserVO.getRoles()) {
            SecResourceWebListByRoleParam roleParam = new SecResourceWebListByRoleParam();
            roleParam.setRoleId(secRoleDTO.getId());
            resourceWebs.addAll(this.secAuthorizationService.listAuthorizedResourceWebsByRoleId(roleParam));
        }
        onlineUserVO.setResourceWebs(resourceWebs);
        return onlineUserVO;
    }
}

