/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogMarker$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.AllDeadLetters;
import org.apache.pekko.actor.DeadLetter;
import org.apache.pekko.actor.DeadLetterActorRef;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.Dropped;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.UnhandledMessage;
import org.apache.pekko.actor.WrappedMessage;
import org.apache.pekko.actor.WrappedMessage$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Info$;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.PrettyDuration$PrettyPrintableDuration$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\r\u001a\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0005;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0013\u0001\u0005B\u0002#\u0001A\u0003%\u0011\tC\u0004F\u0001\u0001\u0007I\u0011\u0003\u001e\t\u000f\u0019\u0003\u0001\u0019!C\t\u000f\"1Q\n\u0001Q!\nmBQA\u0014\u0001\u0005B=CQ\u0001\u0015\u0001\u0005BECQ\u0001\u0019\u0001\u0005B\u0005DQa\u001b\u0001\u0005B=CQ\u0001\u001c\u0001\u0005\n=CQ!\u001c\u0001\u0005\u00029DQa\u001d\u0001\u0005\n9DQ\u0001\u001e\u0001\u0005\n9DQ!\u001e\u0001\u0005\nYDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u00111\t\u0001\u0005\n\u0005\u0015#A\u0005#fC\u0012dU\r\u001e;fe2K7\u000f^3oKJT!AG\u000e\u0002\u000b\u00154XM\u001c;\u000b\u0005qi\u0012!\u00029fW.|'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u001c\u0003\u0015\t7\r^8s\u0013\tq3FA\u0003BGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u00023\u0005YQM^3oiN#(/Z1n+\u0005)\u0004C\u0001\u001a7\u0013\t9\u0014DA\u0006Fm\u0016tGo\u0015;sK\u0006l\u0017\u0001D3wK:$8\u000b\u001e:fC6\u0004\u0013\u0001C7bq\u000e{WO\u001c;\u0016\u0003m\u0002\"\u0001\n\u001f\n\u0005u*#aA%oi\u0006IQ.\u0019=D_VtG\u000fI\u0001\u001bSN\fEn^1zg2{wmZ5oO\u0012+\u0017\r\u001a'fiR,'o]\u000b\u0002\u0003B\u0011AEQ\u0005\u0003\u0007\u0016\u0012qAQ8pY\u0016\fg.A\u000ejg\u0006cw/Y=t\u0019><w-\u001b8h\t\u0016\fG\rT3ui\u0016\u00148\u000fI\u0001\u0006G>,h\u000e^\u0001\nG>,h\u000e^0%KF$\"\u0001S&\u0011\u0005\u0011J\u0015B\u0001&&\u0005\u0011)f.\u001b;\t\u000f1K\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\r\r|WO\u001c;!\u0003!\u0001(/Z*uCJ$H#\u0001%\u0002\u0017A|7\u000f\u001e*fgR\f'\u000f\u001e\u000b\u0003\u0011JCQa\u0015\u0007A\u0002Q\u000baA]3bg>t\u0007CA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002ZC\u00051AH]8pizJ\u0011AJ\u0005\u00039\u0016\nq\u0001]1dW\u0006<W-\u0003\u0002_?\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u00039\u0016\n!\u0002\u001d:f%\u0016\u001cH/\u0019:u)\rA%m\u0019\u0005\u0006'6\u0001\r\u0001\u0016\u0005\u0006I6\u0001\r!Z\u0001\b[\u0016\u001c8/Y4f!\r!c\r[\u0005\u0003O\u0016\u0012aa\u00149uS>t\u0007C\u0001\u0013j\u0013\tQWEA\u0002B]f\f\u0001\u0002]8tiN#x\u000e]\u0001\u000fS:\u001c'/Z7f]R\u001cu.\u001e8u\u0003\u001d\u0011XmY3jm\u0016,\u0012a\u001c\t\u0003aFl\u0011\u0001A\u0005\u0003e6\u0012qAU3dK&4X-\u0001\rsK\u000e,\u0017N^3XSRD\u0017\t\\<bsNdunZ4j]\u001e\f!D]3dK&4XmV5uQ6\u000b\u0007pQ8v]RdunZ4j]\u001e\f\u0011D]3dK&4XmV5uQN+8\u000f]3oI2{wmZ5oOR\u0011qn\u001e\u0005\u0006qN\u0001\r!_\u0001\u0010gV\u001c\b/\u001a8e\tV\u0014\u0018\r^5p]B\u0011!p`\u0007\u0002w*\u0011A0`\u0001\tIV\u0014\u0018\r^5p]*\u0011a0J\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0001w\nqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001\u0006:fG\u0016Lg/Z,iK:\u001cVo\u001d9f]\u0012,G\rF\u0003p\u0003\u000f\tI\u0001C\u0003y)\u0001\u0007\u0011\u0010C\u0004\u0002\fQ\u0001\r!!\u0004\u0002\u001fM,8\u000f]3oI\u0012+\u0017\r\u001a7j]\u0016\u00042A_A\b\u0013\r\t\tb\u001f\u0002\t\t\u0016\fG\r\\5oK\u0006iAn\\4EK\u0006$G*\u001a;uKJ$R\u0001SA\f\u0003CAq!!\u0007\u0016\u0001\u0004\tY\"A\u0001e!\rQ\u0013QD\u0005\u0004\u0003?Y#AD!mY\u0012+\u0017\r\u001a'fiR,'o\u001d\u0005\b\u0003G)\u0002\u0019AA\u0013\u0003\u001d!wN\\3Ng\u001e\u0004B!a\n\u000209!\u0011\u0011FA\u0016!\t9V%C\u0002\u0002.\u0015\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u0011aa\u0015;sS:<'bAA\u0017K\u00051\u0011n\u001d*fC2$2!QA\u001d\u0011\u001d\tYD\u0006a\u0001\u0003{\t1a\u001d8e!\rQ\u0013qH\u0005\u0004\u0003\u0003Z#\u0001C!di>\u0014(+\u001a4\u0002'%\u001cxK]1qa\u0016$7+\u001e9qe\u0016\u001c8/\u001a3\u0015\u0007\u0005\u000b9\u0005C\u0004\u0002\u001a]\u0001\r!a\u0007")
public class DeadLetterListener
implements Actor {
    private final EventStream eventStream;
    private final int maxCount;
    private final boolean isAlwaysLoggingDeadLetters;
    private int count;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public int maxCount() {
        return this.maxCount;
    }

    private boolean isAlwaysLoggingDeadLetters() {
        return this.isAlwaysLoggingDeadLetters;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public void preStart() {
        this.eventStream().subscribe(this.self(), DeadLetter.class);
        this.eventStream().subscribe(this.self(), Dropped.class);
        this.eventStream().subscribe(this.self(), UnhandledMessage.class);
    }

    @Override
    public void postRestart(Throwable reason) {
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
    }

    @Override
    public void postStop() {
        this.eventStream().unsubscribe(this.self());
    }

    public void org$apache$pekko$event$DeadLetterListener$$incrementCount() {
        if (this.count() == Integer.MAX_VALUE) {
            Logging$.MODULE$.getLogger(this).info("Resetting DeadLetterListener counter after reaching Int.MaxValue.");
            this.count_$eq(1);
            return;
        }
        this.count_$eq(this.count() + 1);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        if (this.isAlwaysLoggingDeadLetters()) {
            return this.receiveWithAlwaysLogging();
        }
        Duration duration = this.context().system().settings().LogDeadLettersSuspendDuration();
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            return this.org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(finiteDuration);
        }
        return this.receiveWithMaxCountLogging();
    }

    private PartialFunction<Object, BoxedUnit> receiveWithAlwaysLogging() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AllDeadLetters) {
                    AllDeadLetters allDeadLetters = (AllDeadLetters)x1;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(allDeadLetters)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AllDeadLetters;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private PartialFunction<Object, BoxedUnit> receiveWithMaxCountLogging() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AllDeadLetters) {
                    AllDeadLetters allDeadLetters = (AllDeadLetters)x1;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(allDeadLetters)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, ", no more dead letters will be logged");
                            this.$outer.context().stop(this.$outer.self());
                            return (B1)BoxedUnit.UNIT;
                        }
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AllDeadLetters;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(FiniteDuration suspendDuration) {
        return new Serializable(this, suspendDuration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;
            private final FiniteDuration suspendDuration$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AllDeadLetters) {
                    AllDeadLetters allDeadLetters = (AllDeadLetters)x1;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(allDeadLetters)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.$outer.count() == this.$outer.maxCount()) {
                            String doneMsg = new StringBuilder(48).append(", no more dead letters will be logged in next [").append(PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.suspendDuration$1))).append("]").toString();
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, doneMsg);
                            this.$outer.context().become(this.$outer.org$apache$pekko$event$DeadLetterListener$$receiveWhenSuspended(this.suspendDuration$1, Deadline$.MODULE$.now().$plus(this.suspendDuration$1)));
                            return (B1)BoxedUnit.UNIT;
                        }
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AllDeadLetters;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.suspendDuration$1 = suspendDuration$1;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> org$apache$pekko$event$DeadLetterListener$$receiveWhenSuspended(FiniteDuration suspendDuration, Deadline suspendDeadline) {
        return new Serializable(this, suspendDeadline, suspendDuration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;
            private final Deadline suspendDeadline$1;
            private final FiniteDuration suspendDuration$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof AllDeadLetters) {
                    AllDeadLetters allDeadLetters = (AllDeadLetters)x1;
                    if (!this.$outer.org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(allDeadLetters)) {
                        this.$outer.org$apache$pekko$event$DeadLetterListener$$incrementCount();
                        if (this.suspendDeadline$1.isOverdue()) {
                            String doneMsg = new StringBuilder(58).append(", of which ").append(this.$outer.count() - this.$outer.maxCount() - 1).append(" were not logged. The counter will be reset now").toString();
                            this.$outer.org$apache$pekko$event$DeadLetterListener$$logDeadLetter(allDeadLetters, doneMsg);
                            this.$outer.count_$eq(0);
                            this.$outer.context().become(this.$outer.org$apache$pekko$event$DeadLetterListener$$receiveWithSuspendLogging(this.suspendDuration$2));
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                return x1 instanceof AllDeadLetters;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.suspendDeadline$1 = suspendDeadline$1;
                this.suspendDuration$2 = suspendDuration$2;
            }
        };
    }

    public void org$apache$pekko$event$DeadLetterListener$$logDeadLetter(AllDeadLetters d, String doneMsg) {
        String string;
        String wrappedIn;
        String origin = this.isReal(d.sender()) ? new StringBuilder(6).append(" from ").append(d.sender()).toString() : "";
        String messageStr = WrappedMessage$.MODULE$.unwrap(d.message()).getClass().getName();
        String string2 = wrappedIn = d.message() instanceof WrappedMessage ? new StringBuilder(14).append(" wrapped in [").append(d.message().getClass().getName()).append("]").toString() : "";
        if (d instanceof Dropped) {
            Dropped dropped = (Dropped)d;
            String destination = this.isReal(d.recipient()) ? new StringBuilder(4).append(" to ").append(d.recipient()).toString() : "";
            string = new StringBuilder(55).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(destination).append(" was dropped. ").append(dropped.reason()).append(". ").append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString();
        } else if (d instanceof UnhandledMessage) {
            String destination = this.isReal(d.recipient()) ? new StringBuilder(4).append(" to ").append(d.recipient()).toString() : "";
            string = new StringBuilder(55).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(destination).append(" was unhandled. ").append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString();
        } else {
            string = new StringBuilder(139).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(" to ").append(d.recipient()).append(" was not delivered. ").append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").append("If this is not an expected behavior then ").append(d.recipient()).append(" may have terminated unexpectedly. ").toString();
        }
        String logMessage = string;
        this.eventStream().publish(Logging$Info$.MODULE$.apply(d.recipient().path().toString(), d.recipient().getClass(), new StringBuilder(141).append(logMessage).append("This logging can be turned off or adjusted with configuration settings 'pekko.log-dead-letters' ").append("and 'pekko.log-dead-letters-during-shutdown'.").toString(), Logging$.MODULE$.emptyMDC(), ActorLogMarker$.MODULE$.deadLetter(messageStr)));
    }

    private boolean isReal(ActorRef snd) {
        return snd != ActorRef$.MODULE$.noSender() && snd != this.context().system().deadLetters() && !(snd instanceof DeadLetterActorRef);
    }

    public boolean org$apache$pekko$event$DeadLetterListener$$isWrappedSuppressed(AllDeadLetters d) {
        Object object = d.message();
        return object instanceof WrappedMessage && ((WrappedMessage)object).message() instanceof DeadLetterSuppression;
    }

    public DeadLetterListener() {
        Actor.$init$(this);
        this.eventStream = this.context().system().eventStream();
        this.maxCount = this.context().system().settings().LogDeadLetters();
        this.isAlwaysLoggingDeadLetters = this.maxCount() == Integer.MAX_VALUE;
        this.count = 0;
    }
}

