/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.actor.ActorSystemImpl;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.Envelope$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.routing.OptimalSizeExploringResizer;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.ResizablePoolActor$Resize$;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.RoutedActorCell;
import org.apache.pekko.routing.Routee;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!\u0002\u000b\u0016\u0005]i\u0002\"\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013+\u0011%q\u0003A!A!\u0002\u0013y#\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011%A\u0004A!A!\u0002\u0013It\bC\u0005B\u0001\t\u0005\t\u0015!\u00036\u0005\"IA\t\u0001B\u0001B\u0003%q&\u0012\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\"AA\n\u0001B\u0001B\u0003%\u0011\nC\u0003N\u0001\u0011\u0005a\nC\u0004X\u0001\t\u0007I\u0011\u0001-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u001di\u0006A1A\u0005\nyCaa\u001b\u0001!\u0002\u0013y\u0006b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000bI\u0004A\u0011K:\t\u000bi\u0004A\u0011I>\t\u0011\u0005\r\u0001\u0001\"\u0001\u0018\u0003\u000bAa!!\u0005\u0001\t\u0013\u0019(!\u0005*fg&T\u0018M\u00197f!>|GnQ3mY*\u0011acF\u0001\be>,H/\u001b8h\u0015\tA\u0012$A\u0003qK.\\wN\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0016\u0013\t\tSCA\bS_V$X\rZ!di>\u00148)\u001a7m\u0003\u001dy6/_:uK6\u001c\u0001\u0001\u0005\u0002&Q5\taE\u0003\u0002(/\u0005)\u0011m\u0019;pe&\u0011\u0011F\n\u0002\u0010\u0003\u000e$xN]*zgR,W.S7qY&\u00111\u0006L\u0001\u0007gf\u001cH/Z7\n\u000552#!C!di>\u00148)\u001a7m\u0003\u0011y&/\u001a4\u0011\u0005\u0015\u0002\u0014BA\u0019'\u0005AIe\u000e^3s]\u0006d\u0017i\u0019;peJ+g-\u0003\u00024Y\u0005!1/\u001a7g\u00031y&o\\;uKJ\u0004&o\u001c9t!\t)c'\u0003\u00028M\t)\u0001K]8qg\u0006\trL]8vi\u0016\u0014H)[:qCR\u001c\u0007.\u001a:\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0012\u0001\u00033jgB\fGo\u00195\n\u0005yZ$!E'fgN\fw-\u001a#jgB\fGo\u00195fe&\u0011\u0001\tL\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\u0018\u0001D0s_V$X-\u001a)s_B\u001c\u0018BA\"!\u0003-\u0011x.\u001e;fKB\u0013x\u000e]:\u0002\u0017}\u001bX\u000f]3sm&\u001cxN]\u0005\u0003\r2\na\u0001]1sK:$\u0018\u0001\u00029p_2,\u0012!\u0013\t\u0003?)K!aS\u000b\u0003\tA{w\u000e\\\u0001\u0006a>|G\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011=\u0003\u0016KU*U+Z\u0003\"a\b\u0001\t\u000b\tJ\u0001\u0019\u0001\u0013\t\u000b9J\u0001\u0019A\u0018\t\u000bQJ\u0001\u0019A\u001b\t\u000baJ\u0001\u0019A\u001d\t\u000b\u0005K\u0001\u0019A\u001b\t\u000b\u0011K\u0001\u0019A\u0018\t\u000b\u001dK\u0001\u0019A%\u0002\u000fI,7/\u001b>feV\t\u0011\f\u0005\u0002 5&\u00111,\u0006\u0002\b%\u0016\u001c\u0018N_3s\u0003!\u0011Xm]5{KJ\u0004\u0013\u0001\u0005:fg&TX-\u00138Qe><'/Z:t+\u0005y\u0006C\u00011j\u001b\u0005\t'B\u00012d\u0003\u0019\tGo\\7jG*\u0011A-Z\u0001\u000bG>t7-\u001e:sK:$(B\u00014h\u0003\u0011)H/\u001b7\u000b\u0003!\fAA[1wC&\u0011!.\u0019\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002#I,7/\u001b>f\u0013:\u0004&o\\4sKN\u001c\b%A\u0007sKNL'0Z\"pk:$XM]\u000b\u0002]B\u0011\u0001m\\\u0005\u0003a\u0006\u0014!\"\u0011;p[&\u001cGj\u001c8h\u00039\u0011Xm]5{K\u000e{WO\u001c;fe\u0002\nQ\u0002\u001d:f'V\u0004XM]*uCJ$H#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0003]\fQa]2bY\u0006L!!\u001f<\u0003\tUs\u0017\u000e^\u0001\fg\u0016tG-T3tg\u0006<W\r\u0006\u0002uy\")Q0\u0005a\u0001}\u0006AQM\u001c<fY>\u0004X\r\u0005\u0002;\u007f&\u0019\u0011\u0011A\u001e\u0003\u0011\u0015sg/\u001a7pa\u0016\faA]3tSj,Gc\u0001;\u0002\b!9\u0011\u0011\u0002\nA\u0002\u0005-\u0011aB5oSRL\u0017\r\u001c\t\u0004k\u00065\u0011bAA\bm\n9!i\\8mK\u0006t\u0017!\u0006;ssJ+\u0007o\u001c:u\u001b\u0016\u001c8/Y4f\u0007>,h\u000e\u001e")
public final class ResizablePoolCell
extends RoutedActorCell {
    private final Pool pool;
    private final Resizer resizer;
    private final AtomicBoolean resizeInProgress;
    private final AtomicLong resizeCounter;

    public Pool pool() {
        return this.pool;
    }

    public Resizer resizer() {
        return this.resizer;
    }

    private AtomicBoolean resizeInProgress() {
        return this.resizeInProgress;
    }

    private AtomicLong resizeCounter() {
        return this.resizeCounter;
    }

    @Override
    public void preSuperStart() {
        if (this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement())) {
            this.resize(true);
            return;
        }
    }

    @Override
    public void sendMessage(Envelope envelope) {
        if (!this.routerConfig().isManagementMessage(envelope.message()) && this.resizer().isTimeForResize(this.resizeCounter().getAndIncrement()) && this.resizeInProgress().compareAndSet(false, true)) {
            super.sendMessage(Envelope$.MODULE$.apply(ResizablePoolActor$Resize$.MODULE$, this.self(), this.system()));
        }
        super.sendMessage(envelope);
    }

    public void resize(boolean initial) {
        if (this.resizeInProgress().get() || initial) {
            try {
                this.tryReportMessageCount();
                int requestedCapacity = this.resizer().resize(this.router().routees());
                if (requestedCapacity > 0) {
                    Vector newRoutees = (Vector)package$.MODULE$.Vector().fill(requestedCapacity, (Function0 & Serializable & scala.Serializable)() -> this.pool().newRoutee(this.routeeProps(), this));
                    this.addRoutees((Iterable<Routee>)newRoutees);
                } else if (requestedCapacity < 0) {
                    IndexedSeq<Routee> currentRoutees = this.router().routees();
                    IndexedSeq abandon = (IndexedSeq)currentRoutees.drop(currentRoutees.length() + requestedCapacity);
                    this.removeRoutees((Iterable<Routee>)abandon, true);
                }
            }
            finally {
                this.resizeInProgress().set(false);
            }
            return;
        }
    }

    private void tryReportMessageCount() {
        Resizer resizer = this.resizer();
        if (resizer instanceof OptimalSizeExploringResizer) {
            ((OptimalSizeExploringResizer)resizer).reportMessageCount(this.router().routees(), this.resizeCounter().get());
            return;
        }
    }

    public ResizablePoolCell(ActorSystemImpl _system, InternalActorRef _ref, Props _routerProps, MessageDispatcher _routerDispatcher, Props _routeeProps, InternalActorRef _supervisor, Pool pool) {
        this.pool = pool;
        super(_system, _ref, _routerProps, _routerDispatcher, _routeeProps, _supervisor);
        Predef$.MODULE$.require(pool.resizer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "RouterConfig must be a Pool with defined resizer");
        this.resizer = (Resizer)pool.resizer().get();
        this.resizeInProgress = new AtomicBoolean();
        this.resizeCounter = new AtomicLong();
    }
}

