/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.typed.delivery.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.Done;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.DispatcherSelector$;
import org.apache.pekko.actor.typed.Props;
import org.apache.pekko.actor.typed.RecipientRef;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.typed.ShardingEnvelope;
import org.apache.pekko.cluster.sharding.typed.delivery.ShardingProducerController;
import org.apache.pekko.cluster.sharding.typed.delivery.internal.ShardingProducerControllerImpl;
import org.apache.pekko.cluster.sharding.typed.delivery.internal.ShardingProducerControllerImpl$CleanupUnused$;
import org.apache.pekko.cluster.sharding.typed.delivery.internal.ShardingProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.cluster.sharding.typed.delivery.internal.ShardingProducerControllerImpl$ResendFirstUnconfirmed$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;

@InternalApi
public final class ShardingProducerControllerImpl$ {
    public static ShardingProducerControllerImpl$ MODULE$;

    static {
        new ShardingProducerControllerImpl$();
    }

    /*
     * WARNING - void declaration
     */
    public <A> Behavior<ShardingProducerController.Command<A>> apply(String producerId, ActorRef<ShardingEnvelope<ConsumerController.SequencedMessage<A>>> region, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ShardingProducerController.Settings settings, ClassTag<A> evidence$1) {
        void withStash_factory;
        void withStash_capacity;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)stashBuffer -> {
            void setup_factory;
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)context -> {
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
                context.setLoggerName("org.apache.pekko.cluster.sharding.typed.delivery.ShardingProducerController");
                Option durableQueue = MODULE$.askLoadState((ActorContext<ShardingProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
                return Behaviors$.MODULE$.withMdc(map, MODULE$.waitingForStart(producerId, (ActorContext<ShardingProducerControllerImpl.InternalCommand>)context, (StashBuffer<ShardingProducerControllerImpl.InternalCommand>)stashBuffer, region, durableQueue, (Option)None$.MODULE$, MODULE$.createInitialState(durableQueue.nonEmpty()), settings, evidence$1), ClassTag$.MODULE$.apply(ShardingProducerControllerImpl.InternalCommand.class));
            };
            if (Behaviors$.MODULE$ == null) {
                throw null;
            }
            if (BehaviorImpl.DeferredBehavior$.MODULE$ == null) {
                throw null;
            }
            return new /* Unavailable Anonymous Inner Class!! */;
        };
        int n = settings.bufferSize();
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        Function1 & Serializable & scala.Serializable withStash_setup_factory = arg_0 -> Behaviors$.$anonfun$withStash$1((int)withStash_capacity, (Function1)withStash_factory, arg_0);
        if (BehaviorImpl.DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new /* Unavailable Anonymous Inner Class!! */.narrow();
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        if (hasDurableQueue) {
            return None$.MODULE$;
        }
        return new Some((Object)DurableProducerQueue.State$.MODULE$.empty());
    }

    /*
     * WARNING - void declaration
     */
    private <A> Behavior<ShardingProducerControllerImpl.InternalCommand> waitingForStart(String producerId, ActorContext<ShardingProducerControllerImpl.InternalCommand> context, StashBuffer<ShardingProducerControllerImpl.InternalCommand> stashBuffer, ActorRef<ShardingEnvelope<ConsumerController.SequencedMessage<A>>> region, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, Option<ActorRef<ShardingProducerController.RequestNext<A>>> producer, Option<DurableProducerQueue.State<A>> initialState, ShardingProducerController.Settings settings, ClassTag<A> evidence$2) {
        void receiveMessage_onMessage;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof ShardingProducerController.Start) {
                ShardingProducerController.Start start = (ShardingProducerController.Start)x0$1;
                ProducerControllerImpl$.MODULE$.enforceLocalProducer(start.producer());
                if (initialState instanceof Some) {
                    DurableProducerQueue.State s = (DurableProducerQueue.State)((Some)initialState).value();
                    return ShardingProducerControllerImpl$.becomeActive$1(start.producer(), s, settings, stashBuffer, context, producerId, region, durableQueue, evidence$2);
                }
                if (None$.MODULE$.equals(initialState)) {
                    return MODULE$.waitingForStart(producerId, context, stashBuffer, region, durableQueue, (Option)new Some(start.producer()), initialState, settings, evidence$2);
                }
                throw new MatchError((Object)initialState);
            }
            if (x0$1 instanceof ShardingProducerControllerImpl.LoadStateReply) {
                ShardingProducerControllerImpl.LoadStateReply loadStateReply = (ShardingProducerControllerImpl.LoadStateReply)x0$1;
                if (producer instanceof Some) {
                    return ShardingProducerControllerImpl$.becomeActive$1((ActorRef)((Some)producer).value(), loadStateReply.state(), settings, stashBuffer, context, producerId, region, durableQueue, evidence$2);
                }
                if (None$.MODULE$.equals(producer)) {
                    return MODULE$.waitingForStart(producerId, context, stashBuffer, region, durableQueue, producer, (Option)new Some(loadStateReply.state()), settings, evidence$2);
                }
                throw new MatchError((Object)producer);
            }
            if (x0$1 instanceof ShardingProducerControllerImpl.LoadStateFailed) {
                int attempt = ((ShardingProducerControllerImpl.LoadStateFailed)x0$1).attempt();
                if (attempt >= settings.producerControllerSettings().durableQueueRetryAttempts()) {
                    String errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                    context.log().error(errorMessage);
                    throw new TimeoutException(errorMessage);
                }
                context.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger((int)attempt), (Object)BoxesRunTime.boxToInteger((int)settings.producerControllerSettings().durableQueueRetryAttempts()));
                MODULE$.askLoadState(context, durableQueue, settings, attempt + 1);
                return Behaviors$.MODULE$.same();
            }
            if (ShardingProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(x0$1)) {
                throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
            }
            MODULE$.checkStashFull(stashBuffer);
            stashBuffer.stash(x0$1);
            return Behaviors$.MODULE$.same();
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        return new Behaviors.ReceiveMessageImpl((Function1)receiveMessage_onMessage);
    }

    private <A> void checkStashFull(StashBuffer<ShardingProducerControllerImpl.InternalCommand> stashBuffer) {
        if (stashBuffer.isFull()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Buffer is full, size [").append(stashBuffer.size()).append("].").toString());
        }
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<ShardingProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ShardingProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1 & Serializable & scala.Serializable)b -> {
            ActorRef ref = context.spawn(b, "durable", (Props)DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, (Object)ShardingProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.askLoadState(context, (Option)new Some((Object)ref), settings, 1);
            return ref;
        });
    }

    private <A> void askLoadState(ActorContext<ShardingProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ShardingProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.producerControllerSettings().durableQueueRequestTimeout());
        durableQueue.foreach((Function1 & Serializable & scala.Serializable)ref -> {
            context.ask((RecipientRef)ref, (Function1 & Serializable & scala.Serializable)askReplyTo -> new DurableProducerQueue.LoadState(askReplyTo), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 instanceof Success) {
                    DurableProducerQueue.State s = (DurableProducerQueue.State)((Success)x0$1).value();
                    return new ShardingProducerControllerImpl.LoadStateReply(s);
                }
                if (x0$1 instanceof Failure) {
                    return new ShardingProducerControllerImpl.LoadStateFailed(attempt$1);
                }
                throw new MatchError(x0$1);
            }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Behavior becomeActive$1(ActorRef p, DurableProducerQueue.State s, ShardingProducerController.Settings settings$2, StashBuffer stashBuffer$2, ActorContext context$1, String producerId$2, ActorRef region$2, Option durableQueue$1, ClassTag evidence$2$1) {
        void withTimers_withTimers_setup_factory;
        void withTimers_factory;
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)timers -> {
            void withStash_factory;
            void withStash_capacity;
            timers.startTimerWithFixedDelay((Object)ShardingProducerControllerImpl$CleanupUnused$.MODULE$, settings$2.cleanupUnusedAfter().$div(2L));
            timers.startTimerWithFixedDelay((Object)ShardingProducerControllerImpl$ResendFirstUnconfirmed$.MODULE$, settings$2.resendFirstUnconfirmedIdleTimeout().$div(2L));
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)newStashBuffer -> {
                void setup_factory;
                Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$1 -> {
                    s.unconfirmed().foreach((Function1 & Serializable & scala.Serializable)m -> newStashBuffer.stash(new ShardingProducerControllerImpl.Msg<Object>(new ShardingEnvelope<Object>(m.confirmationQualifier(), m.message()), m.seqNr())));
                    stashBuffer$2.foreach((Function1 & Serializable & scala.Serializable)message -> {
                        newStashBuffer.stash((Object)message);
                        return BoxedUnit.UNIT;
                    });
                    ActorRef msgAdapter = context$1.messageAdapter((Function1 & Serializable & scala.Serializable)msg -> new ShardingProducerControllerImpl.Msg(msg, 0L), ClassTag$.MODULE$.apply(ShardingEnvelope.class));
                    if (s.unconfirmed().isEmpty()) {
                        ActorRef.ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(p), new ShardingProducerController.RequestNext(msgAdapter, context$1.self(), (Set<String>)Predef$.MODULE$.Set().empty(), (Map<String, Object>)Predef$.MODULE$.Map().empty()));
                    }
                    Behavior<ShardingProducerControllerImpl.InternalCommand> b = new ShardingProducerControllerImpl((ActorContext<ShardingProducerControllerImpl.InternalCommand>)context$1, producerId$2, msgAdapter, region$2, durableQueue$1, settings$2, evidence$2$1).org$apache$pekko$cluster$sharding$typed$delivery$internal$ShardingProducerControllerImpl$$active(new ShardingProducerControllerImpl.State(s.currentSeqNr(), p, Predef$.MODULE$.Map().empty(), (Map<Object, ActorRef<Done>>)Predef$.MODULE$.Map().empty()));
                    return newStashBuffer.unstashAll(b);
                };
                if (Behaviors$.MODULE$ == null) {
                    throw null;
                }
                if (BehaviorImpl.DeferredBehavior$.MODULE$ == null) {
                    throw null;
                }
                return new /* Unavailable Anonymous Inner Class!! */;
            };
            int n = settings$2.bufferSize();
            if (Behaviors$.MODULE$ == null) {
                throw null;
            }
            Function1 & Serializable & scala.Serializable withStash_setup_factory = arg_0 -> Behaviors$.$anonfun$withStash$1((int)withStash_capacity, (Function1)withStash_factory, arg_0);
            if (BehaviorImpl.DeferredBehavior$.MODULE$ == null) {
                throw null;
            }
            return new /* Unavailable Anonymous Inner Class!! */;
        };
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (TimerSchedulerImpl$.MODULE$ == null) {
            throw null;
        }
        Function1 & Serializable & scala.Serializable intersect2 = arg_0 -> TimerSchedulerImpl$.$anonfun$withTimers$1((Function1)withTimers_factory, arg_0);
        if (Behaviors$.MODULE$ == null) {
            throw null;
        }
        if (BehaviorImpl.DeferredBehavior$.MODULE$ == null) {
            throw null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private ShardingProducerControllerImpl$() {
        MODULE$ = this;
    }
}

