/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.typed.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.scaladsl.package;
import org.apache.pekko.actor.typed.scaladsl.package$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.typed.ReplicatedEntity;
import org.apache.pekko.cluster.sharding.typed.ReplicatedEntityProvider;
import org.apache.pekko.cluster.sharding.typed.ReplicatedSharding;
import org.apache.pekko.cluster.sharding.typed.ReplicatedShardingExtension;
import org.apache.pekko.cluster.sharding.typed.ShardingDirectReplication$;
import org.apache.pekko.cluster.sharding.typed.internal.ReplicatedShardingImpl;
import org.apache.pekko.cluster.sharding.typed.scaladsl.ClusterSharding;
import org.apache.pekko.cluster.sharding.typed.scaladsl.ClusterSharding$;
import org.apache.pekko.cluster.sharding.typed.scaladsl.EntityTypeKey;
import org.apache.pekko.persistence.typed.ReplicaId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\u0006\f\u0005MI\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u000be\u0002A\u0011\u0001\u001e\t\u000f\t\u0003!\u0019!C\u0005\u0007\"1\u0001\u000b\u0001Q\u0001\n\u0011Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004Z\u0001\u0001\u0006Ia\u0015\u0005\u00065\u0002!\te\u0017\u0005\u00065\u0002!\t\u0005\u001b\u0005\u0006q\u0002!I!\u001f\u0002 %\u0016\u0004H.[2bi\u0016$7\u000b[1sI&tw-\u0012=uK:\u001c\u0018n\u001c8J[Bd'B\u0001\u0007\u000e\u0003!Ig\u000e^3s]\u0006d'B\u0001\b\u0010\u0003\u0015!\u0018\u0010]3e\u0015\t\u0001\u0012#\u0001\u0005tQ\u0006\u0014H-\u001b8h\u0015\t\u00112#A\u0004dYV\u001cH/\u001a:\u000b\u0005Q)\u0012!\u00029fW.|'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c2\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EI\u0007\u0002\u001b%\u00111%\u0004\u0002\u001c%\u0016\u0004H.[2bi\u0016$7\u000b[1sI&tw-\u0012=uK:\u001c\u0018n\u001c8\u0002\rML8\u000f^3n\u0007\u0001\u0001$a\n\u0019\u0011\u0007!bc&D\u0001*\u0015\tq!F\u0003\u0002,'\u0005)\u0011m\u0019;pe&\u0011Q&\u000b\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0005\u00020a1\u0001A!C\u0019\u0002\u0003\u0003\u0005\tQ!\u00013\u0005\ryF%M\t\u0003gY\u0002\"a\u0007\u001b\n\u0005Ub\"a\u0002(pi\"Lgn\u001a\t\u00037]J!\u0001\u000f\u000f\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003wu\u0002\"\u0001\u0010\u0001\u000e\u0003-AQ\u0001\n\u0002A\u0002y\u0002$aP!\u0011\u0007!b\u0003\t\u0005\u00020\u0003\u0012I\u0011'PA\u0001\u0002\u0003\u0015\tAM\u0001\bG>,h\u000e^3s+\u0005!\u0005CA#O\u001b\u00051%BA$I\u0003\u0019\tGo\\7jG*\u0011\u0011JS\u0001\u000bG>t7-\u001e:sK:$(BA&M\u0003\u0011)H/\u001b7\u000b\u00035\u000bAA[1wC&\u0011qJ\u0012\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001C2pk:$XM\u001d\u0011\u0002\r1|wmZ3s+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,\u0018\u0003\u0015\u0019HN\u001a\u001bk\u0013\tAVK\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0011Ig.\u001b;\u0016\u0005q\u000bGCA/d!\r\tc\fY\u0005\u0003?6\u0011!CU3qY&\u001c\u0017\r^3e'\"\f'\u000fZ5oOB\u0011q&\u0019\u0003\u0006E\u001e\u0011\rA\r\u0002\u0002\u001b\")Am\u0002a\u0001K\u0006A1/\u001a;uS:<7\u000fE\u0002\"M\u0002L!aZ\u0007\u00031I+\u0007\u000f\\5dCR,G-\u00128uSRL\bK]8wS\u0012,'/\u0006\u0002jYR\u0019!.\u001c<\u0011\u0007\u0005r6\u000e\u0005\u00020Y\u0012)!\r\u0003b\u0001e!)a\u000e\u0003a\u0001_\u0006YA\u000f[5t%\u0016\u0004H.[2b!\t\u0001H/D\u0001r\u0015\tq!O\u0003\u0002t'\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\t)\u0018OA\u0005SKBd\u0017nY1JI\")A\r\u0003a\u0001oB\u0019\u0011EZ6\u0002\u0019%t\u0017\u000e^%oi\u0016\u0014h.\u00197\u0016\u0005ilH\u0003B>\u007f\u0003\u000b\u00012!\t0}!\tyS\u0010B\u0003c\u0013\t\u0007!\u0007C\u0003o\u0013\u0001\u0007q\u0010\u0005\u0003\u001c\u0003\u0003y\u0017bAA\u00029\t1q\n\u001d;j_:Da\u0001Z\u0005A\u0002\u0005\u001d\u0001cA\u0011gy\"\u001a\u0001!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0014\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tyAA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public final class ReplicatedShardingExtensionImpl
implements ReplicatedShardingExtension {
    private final ActorSystem<?> system;
    private final AtomicLong counter;
    private final Logger logger;

    private AtomicLong counter() {
        return this.counter;
    }

    private Logger logger() {
        return this.logger;
    }

    @Override
    public <M> ReplicatedSharding<M> init(ReplicatedEntityProvider<M> settings) {
        return this.initInternal((Option<ReplicaId>)None$.MODULE$, settings);
    }

    @Override
    public <M> ReplicatedSharding<M> init(ReplicaId thisReplica, ReplicatedEntityProvider<M> settings) {
        return this.initInternal((Option<ReplicaId>)new Some((Object)thisReplica), settings);
    }

    private <M> ReplicatedSharding<M> initInternal(Option<ReplicaId> thisReplica, ReplicatedEntityProvider<M> settings) {
        Predef$.MODULE$.require(settings.replicas().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Replicas must not be empty");
        ClusterSharding sharding = (ClusterSharding)ClusterSharding$.MODULE$.apply(this.system);
        scala.collection.immutable.Seq initializedReplicas = (scala.collection.immutable.Seq)settings.replicas().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ReplicatedEntity replicaSettings = (ReplicatedEntity)x0$1._1();
                String typeName = (String)x0$1._2();
                package.LoggerOps$.MODULE$.infoN$extension0(package$.MODULE$.LoggerOps(this.logger()), "Starting Replicated Event Sourcing sharding for replica [{}] (ShardType: [{}], typeName [{}])", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicaSettings.replicaId().id(), replicaSettings.entity().typeKey().name()}));
                ActorRef regionOrProxy = sharding.init(replicaSettings.entity());
                return new Tuple5((Object)typeName, (Object)replicaSettings.replicaId(), replicaSettings.entity().typeKey(), regionOrProxy, replicaSettings.entity().dataCenter());
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        if (settings.directReplication()) {
            Map replicaToRegionOrProxy = ((TraversableOnce)initializedReplicas.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    ReplicaId replicaId = (ReplicaId)x0$2._2();
                    ActorRef regionOrProxy = (ActorRef)x0$2._4();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replicaId), (Object)regionOrProxy);
                }
                throw new MatchError(null);
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String typeNameWithoutReplicaId = (String)((Tuple2)settings.replicas().head())._2();
            package.LoggerOps$.MODULE$.infoN$extension0(package$.MODULE$.LoggerOps(this.logger()), "Starting Replicated Event Sourcing Direct Replication", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.system.systemActorOf(ShardingDirectReplication$.MODULE$.apply(typeNameWithoutReplicaId, thisReplica, replicaToRegionOrProxy), new StringBuilder(18).append("directReplication-").append(this.counter().incrementAndGet()).toString(), this.system.systemActorOf$default$3());
        }
        Map replicaToTypeKey = ((TraversableOnce)initializedReplicas.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 != null) {
                String typeName = (String)x0$3._1();
                ReplicaId id = (ReplicaId)x0$3._2();
                EntityTypeKey typeKey = (EntityTypeKey)x0$3._3();
                Option dc = (Option)x0$3._5();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), (Object)new Tuple3((Object)typeKey, (Object)dc, (Object)typeName));
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new ReplicatedShardingImpl(sharding, replicaToTypeKey);
    }

    public ReplicatedShardingExtensionImpl(ActorSystem<?> system) {
        this.system = system;
        this.counter = new AtomicLong(0L);
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

