/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowTaskInstanceStage;
import cn.sliew.carp.framework.dag.service.dto.DagStepDTO;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowTaskInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.task.AbstractWorkflowTaskInstanceEventListener;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class WorkflowTaskInstanceSuccessEventListener
extends AbstractWorkflowTaskInstanceEventListener {
    public CarpWorkflowTaskInstanceEvent getType() {
        return CarpWorkflowTaskInstanceEvent.PROCESS_SUCCESS;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowTaskInstanceEventDTO event) {
        return CompletableFuture.runAsync(new SuccessRunner(event.getWorkflowTaskInstanceId())).toCompletableFuture();
    }

    private class SuccessRunner
    implements Runnable,
    Serializable {
        private Long workflowTaskInstanceId;

        public SuccessRunner(Long workflowTaskInstanceId) {
            this.workflowTaskInstanceId = workflowTaskInstanceId;
        }

        @Override
        public void run() {
            DagStepDTO dagStepUpdateParam = new DagStepDTO();
            dagStepUpdateParam.setId(this.workflowTaskInstanceId);
            dagStepUpdateParam.setStatus(CarpWorkflowTaskInstanceStage.SUCCESS.getValue());
            dagStepUpdateParam.setEndTime(new Date());
            WorkflowTaskInstanceSuccessEventListener.this.dagStepService.update(dagStepUpdateParam);
            WorkflowTaskInstance taskInstance = WorkflowTaskInstanceSuccessEventListener.this.workflowInstanceService.getTask(this.workflowTaskInstanceId);
            WorkflowTaskInstanceSuccessEventListener.this.workflowInstanceStateMachine.onTaskChange(WorkflowTaskInstanceSuccessEventListener.this.workflowInstanceService.get(taskInstance.getWorkflowInstanceId()));
        }
    }
}

