/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow;

import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowExecuteType;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowInstanceEvent;
import cn.sliew.carp.framework.common.dict.workflow.CarpWorkflowInstanceState;
import cn.sliew.carp.framework.dag.algorithm.DAG;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowInstance;
import cn.sliew.carp.module.workflow.api.engine.domain.instance.WorkflowTaskInstance;
import cn.sliew.carp.module.workflow.api.service.convert.WorkflowExecutionGraphConvert;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.event.WorkflowInstanceEventDTO;
import cn.sliew.carp.module.workflow.internal.engine.dispatch.handler.workflow.AbstractWorkflowInstanceEventListener;
import cn.sliew.carp.module.workflow.internal.executor.WorkflowInstanceExecutorManager;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowInstanceTaskChangeEventListener
extends AbstractWorkflowInstanceEventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceTaskChangeEventListener.class);
    @Autowired
    private WorkflowInstanceExecutorManager workflowInstanceExecutorManager;

    public CarpWorkflowInstanceEvent getType() {
        return CarpWorkflowInstanceEvent.PROCESS_TASK_CHANGE;
    }

    @Override
    protected CompletableFuture handleEventAsync(WorkflowInstanceEventDTO event) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.run(event.getWorkflowInstanceId()));
        future.whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.onFailure(event.getWorkflowInstanceId(), (Throwable)throwable);
            }
        });
        return future;
    }

    private void run(Long workflowInstanceId) {
        WorkflowInstance workflowInstance = this.workflowInstanceService.getGraph(workflowInstanceId);
        if (CarpWorkflowInstanceState.FAILURE == workflowInstance.getStatus()) {
            return;
        }
        DAG dag = WorkflowExecutionGraphConvert.INSTANCE.toDto(workflowInstance.getGraph());
        int successTaskCount = 0;
        boolean isAnyFailure = false;
        String anyFailureMessage = null;
        for (WorkflowTaskInstance taskInstance : dag.nodes()) {
            if (!taskInstance.getStatus().isEnd()) continue;
            if (taskInstance.getStatus().isFailure()) {
                isAnyFailure = true;
                break;
            }
            if (!taskInstance.getStatus().isSuccess()) continue;
            ++successTaskCount;
        }
        if (successTaskCount == dag.nodes().size()) {
            this.stateMachine.onSuccess(this.workflowInstanceService.get(workflowInstanceId));
            return;
        }
        if (isAnyFailure) {
            this.onFailure(workflowInstanceId, new Exception(anyFailureMessage));
            return;
        }
        this.workflowInstanceExecutorManager.execute(CarpWorkflowExecuteType.EXECUTE, workflowInstance, (DAG<WorkflowTaskInstance>)dag);
    }
}

